/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;

public class ConsumerRecordTest {
    @Test
    public void testOldConstructor() {
        String topic = "topic";
        int partition = 0;
        long offset = 23L;
        String key = "key";
        String value = "value";
        ConsumerRecord record = new ConsumerRecord(topic, partition, offset, (Object)key, (Object)value);
        Assert.assertEquals((Object)topic, (Object)record.topic());
        Assert.assertEquals((long)partition, (long)record.partition());
        Assert.assertEquals((long)offset, (long)record.offset());
        Assert.assertEquals((Object)key, (Object)record.key());
        Assert.assertEquals((Object)value, (Object)record.value());
        Assert.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)record.timestampType());
        Assert.assertEquals((long)-1L, (long)record.timestamp());
        Assert.assertEquals((long)-1L, (long)record.checksum());
        Assert.assertEquals((long)-1L, (long)record.serializedKeySize());
        Assert.assertEquals((long)-1L, (long)record.serializedValueSize());
        Assert.assertEquals((Object)new RecordHeaders(), (Object)record.headers());
    }

    @Test
    public void testNullChecksumInConstructor() {
        String key = "key";
        String value = "value";
        long timestamp = 242341324L;
        ConsumerRecord record = new ConsumerRecord("topic", 0, 23L, timestamp, TimestampType.CREATE_TIME, null, key.length(), value.length(), (Object)key, (Object)value, (Headers)new RecordHeaders());
        Assert.assertEquals((long)DefaultRecord.computePartialChecksum((long)timestamp, (int)key.length(), (int)value.length()), (long)record.checksum());
    }
}

