/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.transform.Builder;

public class BuilderSwap<T, B> {
    private final Class<T> pojoClass;
    private final Class<B> builderClass;
    private final Constructor<T> pojoConstructor;
    private final Constructor<B> builderConstructor;
    private final MethodInfo createBuilderMethod;
    private final MethodInfo createPojoMethod;
    private ClassMeta<?> builderClassMeta;

    protected BuilderSwap(Class<T> pojoClass, Class<B> builderClass, Constructor<T> pojoConstructor, Constructor<B> builderConstructor, MethodInfo createBuilderMethod, MethodInfo createPojoMethod) {
        this.pojoClass = pojoClass;
        this.builderClass = builderClass;
        this.pojoConstructor = pojoConstructor;
        this.builderConstructor = builderConstructor;
        this.createBuilderMethod = createBuilderMethod;
        this.createPojoMethod = createPojoMethod;
    }

    public Class<T> getPojoClass() {
        return this.pojoClass;
    }

    public Class<B> getBuilderClass() {
        return this.builderClass;
    }

    public ClassMeta<?> getBuilderClassMeta(BeanSession session) {
        if (this.builderClassMeta == null) {
            this.builderClassMeta = session.getClassMeta(this.getBuilderClass());
        }
        return this.builderClassMeta;
    }

    public B create(BeanSession session, ClassMeta<?> hint) throws ExecutableException {
        if (this.createBuilderMethod != null) {
            return (B)this.createBuilderMethod.invoke(null, new Object[0]);
        }
        try {
            return this.builderConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public T build(BeanSession session, B builder, ClassMeta<?> hint) throws ExecutableException {
        if (this.createPojoMethod != null) {
            return this.createPojoMethod.invoke(builder, new Object[0]);
        }
        try {
            return this.pojoConstructor.newInstance(builder);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public static BuilderSwap<?, ?> findSwapFromBuilderClass(Class<?> builderClass, Visibility cVis, Visibility mVis) {
        ClassInfo bci = ClassInfo.of(builderClass);
        if (bci.isNotPublic()) {
            return null;
        }
        Class<Object> pojoClass = ClassInfo.of(builderClass).getParameterType(0, Builder.class);
        MethodInfo createPojoMethod = bci.getBuilderBuildMethod();
        if (createPojoMethod != null) {
            pojoClass = createPojoMethod.getReturnType().inner();
        }
        if (pojoClass == null) {
            return null;
        }
        ClassInfo pci = ClassInfo.of(pojoClass);
        ConstructorInfo pojoConstructor = pci.getConstructor(cVis, builderClass);
        if (pojoConstructor == null) {
            return null;
        }
        ConstructorInfo builderConstructor = bci.getNoArgConstructor(cVis);
        MethodInfo createBuilderMethod = pci.getBuilderCreateMethod();
        if (builderConstructor == null && createBuilderMethod == null) {
            return null;
        }
        return new BuilderSwap(pojoClass, builderClass, pojoConstructor.inner(), builderConstructor == null ? null : builderConstructor.inner(), createBuilderMethod, createPojoMethod);
    }

    public static BuilderSwap<?, ?> findSwapFromPojoClass(BeanContext bc, Class<?> pojoClass, Visibility cVis, Visibility mVis) {
        Class<Object> builderClass = null;
        ConstructorInfo pojoConstructor = null;
        org.apache.juneau.annotation.Builder b = bc.getAnnotation(org.apache.juneau.annotation.Builder.class, pojoClass);
        if (b != null && b.value() != Null.class) {
            builderClass = b.value();
        }
        ClassInfo pci = ClassInfo.of(pojoClass);
        MethodInfo builderCreateMethod = pci.getBuilderCreateMethod();
        if (builderClass == null && builderCreateMethod != null) {
            builderClass = builderCreateMethod.getReturnType().inner();
        }
        if (builderClass == null) {
            for (ConstructorInfo cc : pci.getPublicConstructors()) {
                ClassInfo pt;
                if (!cc.isVisible(cVis) || !cc.hasNumParams(1) || !(pt = cc.getParamType(0)).isChildOf(Builder.class)) continue;
                pojoConstructor = cc;
                builderClass = pt.inner();
            }
        }
        if (builderClass == null) {
            return null;
        }
        ClassInfo bci = ClassInfo.of(builderClass);
        ConstructorInfo builderConstructor = bci.getNoArgConstructor(cVis);
        if (builderConstructor == null && builderCreateMethod == null) {
            return null;
        }
        MethodInfo pojoCreateMethod = bci.getBuilderBuildMethod();
        if (pojoConstructor == null) {
            pojoConstructor = pci.getConstructor(cVis, builderClass);
        }
        if (pojoConstructor == null && pojoCreateMethod == null) {
            return null;
        }
        return new BuilderSwap(pojoClass, builderClass, pojoConstructor == null ? null : pojoConstructor.inner(), builderConstructor == null ? null : builderConstructor.inner(), builderCreateMethod, pojoCreateMethod);
    }
}

