/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.juneau.ValueListener;
import org.apache.juneau.reflect.ClassInfo;

public class Value<T> {
    private T t;
    private ValueListener<T> listener;

    public static Type getParameterType(Method m, int i) {
        return Value.getParameterType(m.getGenericParameterTypes()[i]);
    }

    public static Type getParameterType(Type t) {
        Class c;
        if (t instanceof ParameterizedType) {
            Type[] ta;
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType() == Value.class && (ta = pt.getActualTypeArguments()).length > 0) {
                return ta[0];
            }
        } else if (t instanceof Class && Value.class.isAssignableFrom(c = (Class)t)) {
            return ClassInfo.of(c).getParameterType(0, Value.class);
        }
        return null;
    }

    public static boolean isType(Type t) {
        return t instanceof ParameterizedType && ((ParameterizedType)t).getRawType() == Value.class || t instanceof Class && Value.class.isAssignableFrom((Class)t);
    }

    public Value() {
    }

    public Value(T t) {
        this.set(t);
    }

    public Value<T> listener(ValueListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public Value<T> set(T t) {
        this.t = t;
        if (this.listener != null) {
            this.listener.onSet(t);
        }
        return this;
    }

    public T get() {
        return this.t;
    }

    public boolean isSet() {
        return this.get() != null;
    }
}

