/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn.journal;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.Adler32;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.BufferChannelFile;
import org.apache.jena.dboe.base.file.BufferChannelMem;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.PrepareState;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntry;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Journal
implements Sync,
Closeable {
    private static final boolean LOGGING = false;
    private static Logger log = LoggerFactory.getLogger(Journal.class);
    private BufferChannel channel;
    private long position;
    private final Location location;
    private long journalWriteStart = -1L;
    private boolean journalWriteEnded = false;
    private static final int posnLength = 0;
    private static final int posnCRC = 4;
    private static final int posnEntry = 8;
    private static final int posnComponent = 12;
    private static final int posnData = 16;
    private static int HeaderLen = 16;
    private ByteBuffer header = ByteBuffer.allocate(HeaderLen);

    private static boolean logging() {
        return false;
    }

    private static void log(String fmt, Object ... args) {
        if (!Journal.logging()) {
            return;
        }
        log.info(String.format(fmt, args));
    }

    public static boolean exists(Location location) {
        if (location.isMemUnique()) {
            return false;
        }
        if (location.isMem()) {
            return location.exists("journal.jrnl");
        }
        return FileOps.exists((String)Journal.journalFilename(location));
    }

    public static Journal create(BufferChannel chan) {
        return new Journal(chan, null);
    }

    public static Journal create(Location location) {
        return new Journal(location);
    }

    private static String journalFilename(Location location) {
        return location.absolute("journal.jrnl");
    }

    private Journal(Location location) {
        this(Journal.openFromLocation(location), location);
    }

    private Journal(BufferChannel chan, Location location) {
        this.channel = chan;
        this.position = 0L;
        this.location = location;
    }

    public void reopen() {
        if (this.location == null) {
            return;
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel = Journal.openFromLocation(this.location);
        long posn = this.writeStartPosn();
        if (posn >= 0L) {
            this.truncate(posn);
            this.position = posn;
            this.sync();
        } else {
            this.position = this.channel.size();
        }
        this.writeReset();
    }

    private static BufferChannel openFromLocation(Location location) {
        String channelName = Journal.journalFilename(location);
        if (location.isMem()) {
            return BufferChannelMem.create((String)channelName);
        }
        return BufferChannelFile.create((String)channelName);
    }

    public synchronized long writeJournal(JournalEntry entry) {
        long posn = this.write(entry.getType(), entry.getComponentId(), entry.getByteBuffer());
        if (entry.getPosition() < 0L) {
            entry.setPosition(posn);
            entry.setEndPosition(this.position);
        }
        return posn;
    }

    public long write(PrepareState prepareState) {
        return this.write(JournalEntryType.REDO, prepareState.getComponent(), prepareState.getData());
    }

    public synchronized long write(JournalEntryType type, ComponentId componentId, ByteBuffer buffer) {
        long posn = this.position;
        int len = -1;
        int bufferLimit = -1;
        int bufferPosition = -1;
        if (buffer != null) {
            bufferLimit = buffer.limit();
            bufferPosition = buffer.position();
            buffer.rewind();
            len = buffer.remaining();
        }
        this.header.clear();
        this.header.putInt(len);
        this.header.putInt(0);
        this.header.putInt(type.id);
        this.header.put(componentId.getBytes());
        this.header.flip();
        Adler32 adler = new Adler32();
        adler.update(this.header.array());
        if (len > 0) {
            adler.update(buffer);
            buffer.rewind();
        }
        int crc = (int)adler.getValue();
        this.header.putInt(4, crc);
        this.channel.write(this.header);
        if (len > 0) {
            this.channel.write(buffer);
            buffer.position(bufferPosition);
            buffer.limit(bufferLimit);
        }
        this.position += (long)(HeaderLen + len);
        if (len > 0) {
            buffer.position(bufferPosition);
            buffer.limit(bufferLimit);
        }
        return posn;
    }

    public synchronized JournalEntry readJournal(long id) {
        return this._readJournal(id);
    }

    private JournalEntry _readJournal(long id) {
        long x = this.channel.position();
        if (x != id) {
            this.channel.position(id);
        }
        JournalEntry entry = this._read();
        long x2 = this.channel.position();
        entry.setPosition(id);
        entry.setEndPosition(x2);
        if (x != id) {
            this.channel.position(x);
        }
        return entry;
    }

    public void startWrite() {
        this.journalWriteStart = this.position;
        this.journalWriteEnded = false;
    }

    public long writeStartPosn() {
        return this.journalWriteStart;
    }

    public void commitWrite() {
        this.journalWriteStart = -1L;
        this.journalWriteEnded = true;
        this.channel.sync();
    }

    public void abortWrite() {
        if (!this.journalWriteEnded && this.journalWriteStart > 0L) {
            this.truncate(this.journalWriteStart);
            this.sync();
        }
        this.journalWriteEnded = true;
    }

    public void endWrite() {
        if (!this.journalWriteEnded) {
            this.abortWrite();
        }
        this.writeReset();
    }

    private void writeReset() {
        this.journalWriteStart = -1L;
        this.journalWriteEnded = false;
    }

    private JournalEntry _read() {
        int crc;
        this.header.clear();
        int lenRead = this.channel.read(this.header);
        if (lenRead == -1) {
            throw new TransactionException("Read off the end of a journal file");
        }
        if (lenRead != this.header.capacity()) {
            throw new TransactionException("Partial read of journal file");
        }
        this.header.rewind();
        int len = this.header.getInt();
        int checksum = this.header.getInt();
        this.header.putInt(4, 0);
        int entryType = this.header.getInt();
        byte[] bytes = new byte[4];
        this.header.get(bytes);
        ComponentId component = ComponentId.create(null, bytes);
        Adler32 adler = new Adler32();
        adler.update(this.header.array());
        ByteBuffer bb = null;
        if (len > 0) {
            bb = ByteBuffer.allocate(len);
            lenRead = this.channel.read(bb);
            if (lenRead != len) {
                throw new TransactionException("Failed to read the journal entry data: wanted " + len + " bytes, got " + lenRead);
            }
            bb.rewind();
            adler.update(bb);
            bb.rewind();
        }
        if (checksum != (crc = (int)adler.getValue())) {
            throw new TransactionException("Checksum error reading from the Journal. " + Integer.toHexString(checksum) + " / " + Integer.toHexString(crc));
        }
        JournalEntryType type = JournalEntryType.type(entryType);
        JournalEntry entry = new JournalEntry(type, component, bb);
        return entry;
    }

    public Iterator<JournalEntry> entries() {
        return new IteratorEntries(0L);
    }

    public synchronized Iterator<JournalEntry> entries(long startPosition) {
        return new IteratorEntries(startPosition);
    }

    public void sync() {
        this.channel.sync();
    }

    public void close() {
        this.channel.close();
    }

    public long size() {
        return this.channel.size();
    }

    public boolean isEmpty() {
        return this.channel.size() == 0L;
    }

    public void truncate(long size) {
        this.channel.truncate(size);
    }

    public void reset() {
        this.truncate(0L);
        this.sync();
    }

    public long position() {
        return this.channel.position();
    }

    public String getFilename() {
        return this.channel.getFilename();
    }

    private class IteratorEntries
    extends IteratorSlotted<JournalEntry> {
        JournalEntry slot = null;
        final long endPoint;
        long iterPosn;

        public IteratorEntries(long startPosition) {
            this.iterPosn = startPosition;
            this.endPoint = Journal.this.channel.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JournalEntry moveToNext() {
            Journal journal = Journal.this;
            synchronized (journal) {
                if (this.iterPosn >= this.endPoint) {
                    return null;
                }
                JournalEntry e = Journal.this._readJournal(this.iterPosn);
                this.iterPosn = e.getEndPosition();
                return e;
            }
        }

        protected boolean hasMore() {
            return this.iterPosn < this.endPoint;
        }
    }
}

