/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.InetSocketAddress;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestBasicConnectionManager
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).build();
    }

    @After
    public void cleanup() throws IOException {
        this.httpclient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasics() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        HttpHost target = new HttpHost(address.getHostName(), address.getPort());
        HttpGet get = new HttpGet("/random/1024");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)get);
        try {
            Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        finally {
            response.close();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testConnectionStillInUse() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        HttpHost target = new HttpHost(address.getHostName(), address.getPort());
        HttpGet get1 = new HttpGet("/random/1024");
        this.httpclient.execute(target, (HttpRequest)get1);
        HttpGet get2 = new HttpGet("/random/1024");
        this.httpclient.execute(target, (HttpRequest)get2);
    }
}

