/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.mapreduce.TestImportTsv;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestImportTSVWithVisibilityLabels
implements Configurable {
    protected static final Log LOG = LogFactory.getLog(TestImportTSVWithVisibilityLabels.class);
    protected static final String NAME = TestImportTsv.class.getSimpleName();
    protected static HBaseTestingUtility util = new HBaseTestingUtility();
    protected static final String DELETE_AFTER_LOAD_CONF = NAME + ".deleteAfterLoad";
    protected static final String FORCE_COMBINER_CONF = NAME + ".forceCombiner";
    private final String FAMILY = "FAM";
    private static final String TOPSECRET = "topsecret";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static User SUPERUSER;
    private static Configuration conf;

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        throw new IllegalArgumentException("setConf not supported");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        conf = util.getConfiguration();
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        conf.set("hbase.superuser", "admin," + User.getCurrent().getName());
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        util.startMiniCluster();
        util.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestImportTSVWithVisibilityLabels.createLabels();
        HBaseAdmin admin = new HBaseAdmin(util.getConfiguration());
        util.startMiniMapReduceCluster();
    }

    private static void createLabels() throws IOException, InterruptedException {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestImportTSVWithVisibilityLabels.SECRET, TestImportTSVWithVisibilityLabels.TOPSECRET, TestImportTSVWithVisibilityLabels.CONFIDENTIAL, TestImportTSVWithVisibilityLabels.PUBLIC, TestImportTSVWithVisibilityLabels.PRIVATE};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                    LOG.info((Object)"Added labels ");
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error in adding labels", t);
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.shutdownMiniMapReduceCluster();
        util.shutdownMiniCluster();
    }

    @Test
    public void testMROnTable() throws Exception {
        String tableName = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_CELL_VISIBILITY", "-Dimporttsv.separator=\u001b", tableName};
        String data = "KEY\u001bVALUE1\u001bVALUE2\u001bsecret&private\n";
        util.createTable(tableName, "FAM");
        TestImportTSVWithVisibilityLabels.doMROnTableTest(util, "FAM", data, args, 1);
        util.deleteTable(tableName);
    }

    @Test
    public void testMROnTableWithDeletes() throws Exception {
        String tableName = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_CELL_VISIBILITY", "-Dimporttsv.separator=\u001b", tableName};
        String data = "KEY\u001bVALUE1\u001bVALUE2\u001bsecret&private\n";
        util.createTable(tableName, "FAM");
        TestImportTSVWithVisibilityLabels.doMROnTableTest(util, "FAM", data, args, 1);
        this.issueDeleteAndVerifyData(tableName);
        util.deleteTable(tableName);
    }

    private void issueDeleteAndVerifyData(String tableName) throws IOException {
        LOG.debug((Object)"Validating table after delete.");
        HTable table = new HTable(conf, tableName);
        boolean verified = false;
        long pause = conf.getLong("hbase.client.pause", 5000L);
        int numRetries = conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                Delete d = new Delete(Bytes.toBytes((String)"KEY"));
                d.deleteFamily(Bytes.toBytes((String)"FAM"));
                d.setCellVisibility(new CellVisibility("private&secret"));
                table.delete(d);
                Scan scan = new Scan();
                scan.addFamily(Bytes.toBytes((String)"FAM"));
                scan.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE}));
                ResultScanner resScanner = table.getScanner(scan);
                Result[] next = resScanner.next(5);
                Assert.assertEquals((long)0L, (long)next.length);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        table.close();
        Assert.assertTrue((boolean)verified);
    }

    @Test
    public void testMROnTableWithBulkload() throws Exception {
        String tableName = "test-" + UUID.randomUUID();
        Path hfiles = new Path(util.getDataTestDirOnTestFS(tableName), "hfiles");
        String[] args = new String[]{"-Dimporttsv.bulk.output=" + hfiles.toString(), "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_CELL_VISIBILITY", "-Dimporttsv.separator=\u001b", tableName};
        String data = "KEY\u001bVALUE1\u001bVALUE2\u001bsecret&private\n";
        util.createTable(tableName, "FAM");
        TestImportTSVWithVisibilityLabels.doMROnTableTest(util, "FAM", data, args, 1);
        util.deleteTable(tableName);
    }

    @Test
    public void testBulkOutputWithTsvImporterTextMapper() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String FAMILY = "FAM";
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_CELL_VISIBILITY", "-Dimporttsv.separator=\u001b", "-Dimporttsv.bulk.output=" + bulkOutputPath.toString(), table};
        String data = "KEY\u001bVALUE4\u001bVALUE8\u001bsecret&private\n";
        TestImportTSVWithVisibilityLabels.doMROnTableTest(util, FAMILY, data, args, 4);
        util.deleteTable(table);
    }

    @Test
    public void testMRWithOutputFormat() throws Exception {
        String tableName = "test-" + UUID.randomUUID();
        Path hfiles = new Path(util.getDataTestDirOnTestFS(tableName), "hfiles");
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterMapper", "-Dimporttsv.bulk.output=" + hfiles.toString(), "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_CELL_VISIBILITY", "-Dimporttsv.separator=\u001b", tableName};
        String data = "KEY\u001bVALUE4\u001bVALUE8\u001bsecret&private\n";
        util.createTable(tableName, "FAM");
        TestImportTSVWithVisibilityLabels.doMROnTableTest(util, "FAM", data, args, 1);
        util.deleteTable(tableName);
    }

    protected static Tool doMROnTableTest(HBaseTestingUtility util, String family, String data, String[] args, int valueMultiplier) throws Exception {
        String table = args[args.length - 1];
        Configuration conf = new Configuration(util.getConfiguration());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = fs.makeQualified(new Path(util.getDataTestDirOnTestFS(table), "input.dat"));
        FSDataOutputStream op = fs.create(inputPath, true);
        if (data == null) {
            data = "KEY\u001bVALUE1\u001bVALUE2\n";
        }
        op.write(Bytes.toBytes((String)data));
        op.close();
        LOG.debug((Object)String.format("Wrote test data to file: %s", inputPath));
        if (conf.getBoolean(FORCE_COMBINER_CONF, true)) {
            LOG.debug((Object)"Forcing combiner.");
            conf.setInt("min.num.spills.for.combine", 1);
        }
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
        argv.add(inputPath.toString());
        ImportTsv tool = new ImportTsv();
        LOG.debug((Object)("Running ImportTsv with arguments: " + argv));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)tool, (String[])argv.toArray(args)));
        boolean createdHFiles = false;
        String outputPath = null;
        for (String arg : argv) {
            if (!arg.contains("importtsv.bulk.output")) continue;
            createdHFiles = true;
            outputPath = arg.split("=")[1];
            break;
        }
        LOG.debug((Object)("validating the table " + createdHFiles));
        if (createdHFiles) {
            TestImportTSVWithVisibilityLabels.validateHFiles(fs, outputPath, family);
        } else {
            TestImportTSVWithVisibilityLabels.validateTable(conf, table, family, valueMultiplier);
        }
        if (conf.getBoolean(DELETE_AFTER_LOAD_CONF, true)) {
            LOG.debug((Object)"Deleting test subdirectory");
            util.cleanupDataTestDirOnTestFS(table);
        }
        return tool;
    }

    private static void validateHFiles(FileSystem fs, String outputPath, String family) throws IOException {
        LOG.debug((Object)"Validating HFiles.");
        HashSet<String> configFamilies = new HashSet<String>();
        configFamilies.add(family);
        HashSet<String> foundFamilies = new HashSet<String>();
        for (FileStatus cfStatus : fs.listStatus(new Path(outputPath), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter())) {
            LOG.debug((Object)"The output path has files");
            String[] elements = cfStatus.getPath().toString().split("/");
            String cf = elements[elements.length - 1];
            foundFamilies.add(cf);
            Assert.assertTrue((String)String.format("HFile ouput contains a column family (%s) not present in input families (%s)", cf, configFamilies), (boolean)configFamilies.contains(cf));
            for (FileStatus hfile : fs.listStatus(cfStatus.getPath())) {
                Assert.assertTrue((String)String.format("HFile %s appears to contain no data.", hfile.getPath()), (hfile.getLen() > 0L ? 1 : 0) != 0);
            }
        }
    }

    private static void validateTable(Configuration conf, String tableName, String family, int valueMultiplier) throws IOException {
        LOG.debug((Object)"Validating table.");
        HTable table = new HTable(conf, tableName);
        boolean verified = false;
        long pause = conf.getLong("hbase.client.pause", 5000L);
        int numRetries = conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                Scan scan = new Scan();
                scan.addFamily(Bytes.toBytes((String)family));
                scan.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE}));
                ResultScanner resScanner = table.getScanner(scan);
                Result[] next = resScanner.next(5);
                Assert.assertEquals((long)1L, (long)next.length);
                for (Result res : resScanner) {
                    LOG.debug((Object)("Getting results " + res.size()));
                    Assert.assertTrue((res.size() == 2 ? 1 : 0) != 0);
                    List kvs = res.listCells();
                    Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)kvs.get(0)), (byte[])Bytes.toBytes((String)"KEY")));
                    Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)kvs.get(1)), (byte[])Bytes.toBytes((String)"KEY")));
                    Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)((Cell)kvs.get(0)), (byte[])Bytes.toBytes((String)("VALUE" + valueMultiplier))));
                    Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)((Cell)kvs.get(1)), (byte[])Bytes.toBytes((String)("VALUE" + 2 * valueMultiplier))));
                }
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        table.close();
        Assert.assertTrue((boolean)verified);
    }
}

