/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TimestampTestBase;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMultiVersions {
    private static final Log LOG = LogFactory.getLog(TestMultiVersions.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private HBaseAdmin admin;
    private static final int NUM_SLAVES = 3;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.admin = new HBaseAdmin(UTIL.getConfiguration());
    }

    @After
    public void after() throws IOException {
        this.admin.close();
    }

    @Test
    public void testTimestamps() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"testTimestamps"));
        HColumnDescriptor hcd = new HColumnDescriptor(TimestampTestBase.FAMILY_NAME);
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        HTable table = new HTable(UTIL.getConfiguration(), desc.getTableName());
        HBaseTestCase.HTableIncommon incommon = new HBaseTestCase.HTableIncommon(table);
        TimestampTestBase.doTestDelete(incommon, new HBaseTestCase.FlushCache(){

            @Override
            public void flushcache() throws IOException {
                UTIL.getHBaseCluster().flushcache();
            }
        });
        TimestampTestBase.doTestTimestampScanning(incommon, new HBaseTestCase.FlushCache(){

            @Override
            public void flushcache() throws IOException {
                UTIL.getMiniHBaseCluster().flushcache();
            }
        });
        table.close();
    }

    @Test
    public void testGetRowVersions() throws Exception {
        String tableName = "testGetRowVersions";
        byte[] contents = Bytes.toBytes((String)"contents");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        long timestamp1 = 100L;
        long timestamp2 = 200L;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"testGetRowVersions"));
        HColumnDescriptor hcd = new HColumnDescriptor(contents);
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        Put put = new Put(row, 100L);
        put.add(contents, contents, value1);
        HTable table = new HTable(UTIL.getConfiguration(), "testGetRowVersions");
        table.put(put);
        table.close();
        UTIL.shutdownMiniHBaseCluster();
        LOG.debug((Object)"HBase cluster shut down -- restarting");
        UTIL.startMiniHBaseCluster(1, 3);
        table = new HTable(new Configuration(UTIL.getConfiguration()), "testGetRowVersions");
        put = new Put(row, 200L);
        put.add(contents, contents, value2);
        table.put(put);
        Get get = new Get(row);
        Result r = table.get(get);
        Assert.assertNotNull((Object)r);
        Assert.assertFalse((boolean)r.isEmpty());
        Assert.assertTrue((r.size() == 1 ? 1 : 0) != 0);
        byte[] value = r.getValue(contents, contents);
        Assert.assertTrue((value.length != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])value2));
        get = new Get(row);
        get.setMaxVersions();
        r = table.get(get);
        Assert.assertTrue((r.size() == 2 ? 1 : 0) != 0);
        value = r.getValue(contents, contents);
        Assert.assertTrue((value.length != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])value2));
        NavigableMap map = r.getMap();
        NavigableMap familyMap = (NavigableMap)map.get(contents);
        NavigableMap versionMap = (NavigableMap)familyMap.get(contents);
        Assert.assertTrue((versionMap.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value1, (byte[])((byte[])versionMap.get(100L))));
        Assert.assertTrue((boolean)Bytes.equals((byte[])value2, (byte[])((byte[])versionMap.get(200L))));
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanMultipleVersions() throws Exception {
        int i;
        byte[] tableName = Bytes.toBytes((String)"testScanMultipleVersions");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        byte[][] rows = new byte[][]{Bytes.toBytes((String)"row_0200"), Bytes.toBytes((String)"row_0800")};
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"row_0500")};
        long[] timestamp = new long[]{100L, 1000L};
        this.admin.createTable(desc, (byte[][])splitRows);
        HTable table = new HTable(UTIL.getConfiguration(), tableName);
        NavigableMap locations = table.getRegionLocations();
        Assert.assertEquals((long)2L, (long)locations.size());
        int index = 0;
        for (Map.Entry e : locations.entrySet()) {
            HRegionInfo hri = (HRegionInfo)e.getKey();
            if (index == 0) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])hri.getStartKey()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitRows[0]));
            } else if (index == 1) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])splitRows[0], (byte[])hri.getStartKey()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])HConstants.EMPTY_END_ROW));
            }
            ++index;
        }
        for (i = 0; i < locations.size(); ++i) {
            for (int j = 0; j < timestamp.length; ++j) {
                Put put = new Put(rows[i], timestamp[j]);
                put.add(HConstants.CATALOG_FAMILY, null, timestamp[j], Bytes.toBytes((long)timestamp[j]));
                table.put(put);
            }
        }
        for (i = 0; i < rows.length; ++i) {
            for (int j = 0; j < timestamp.length; ++j) {
                Get get = new Get(rows[i]);
                get.addFamily(HConstants.CATALOG_FAMILY);
                get.setTimeStamp(timestamp[j]);
                Result result = table.get(get);
                int cellCount = 0;
                for (Cell kv : result.listCells()) {
                    ++cellCount;
                }
                Assert.assertTrue((cellCount == 1 ? 1 : 0) != 0);
            }
            table.close();
        }
        int count = 0;
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        ResultScanner s = table.getScanner(scan);
        try {
            Result rr = null;
            while ((rr = s.next()) != null) {
                System.out.println(rr.toString());
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeRange(1000L, Long.MAX_VALUE);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeStamp(1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeRange(100L, 1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeStamp(100L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        }
        finally {
            s.close();
        }
    }
}

