/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.ws.http.HTTPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.util.ReflectionUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class RESTApiClusterManager
extends Configured
implements ClusterManager {
    private static final String REST_API_CLUSTER_MANAGER_HOSTNAME = "hbase.it.clustermanager.restapi.hostname";
    private static final String REST_API_CLUSTER_MANAGER_USERNAME = "hbase.it.clustermanager.restapi.username";
    private static final String REST_API_CLUSTER_MANAGER_PASSWORD = "hbase.it.clustermanager.restapi.password";
    private static final String REST_API_CLUSTER_MANAGER_CLUSTER_NAME = "hbase.it.clustermanager.restapi.clustername";
    private static final String DEFAULT_SERVER_HOSTNAME = "http://localhost:7180";
    private static final String DEFAULT_SERVER_USERNAME = "admin";
    private static final String DEFAULT_SERVER_PASSWORD = "admin";
    private static final String DEFAULT_CLUSTER_NAME = "Cluster 1";
    private String serverHostname;
    private String serverUsername;
    private String serverPassword;
    private String clusterName;
    private static final String API_VERSION = "v6";
    private Client client = Client.create();
    private ClusterManager hBaseClusterManager = (ClusterManager)ReflectionUtils.newInstance(HBaseClusterManager.class, (Configuration)new IntegrationTestingUtility().getConfiguration());
    private static final Log LOG = LogFactory.getLog(RESTApiClusterManager.class);
    private static Map<ClusterManager.ServiceType, Service> roleServiceType = new HashMap<ClusterManager.ServiceType, Service>();

    RESTApiClusterManager() {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.serverHostname = conf.get(REST_API_CLUSTER_MANAGER_HOSTNAME, DEFAULT_SERVER_HOSTNAME);
        this.serverUsername = conf.get(REST_API_CLUSTER_MANAGER_USERNAME, "admin");
        this.serverPassword = conf.get(REST_API_CLUSTER_MANAGER_PASSWORD, "admin");
        this.clusterName = conf.get(REST_API_CLUSTER_MANAGER_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.serverUsername, this.serverPassword));
    }

    @Override
    public void start(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.performClusterManagerCommand(service, hostname, RoleCommand.START);
    }

    @Override
    public void stop(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.performClusterManagerCommand(service, hostname, RoleCommand.STOP);
    }

    @Override
    public void restart(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.performClusterManagerCommand(service, hostname, RoleCommand.RESTART);
    }

    @Override
    public boolean isRunning(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String serviceName = this.getServiceName(roleServiceType.get((Object)service));
        String hostId = this.getHostId(hostname);
        String roleState = this.getRoleState(serviceName, service.toString(), hostId);
        String healthSummary = this.getHealthSummary(serviceName, service.toString(), hostId);
        boolean isRunning = false;
        if ("STARTED".equals(roleState) && "GOOD".equals(healthSummary)) {
            isRunning = true;
        }
        return isRunning;
    }

    @Override
    public void kill(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.kill(service, hostname, port);
    }

    @Override
    public void suspend(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.kill(service, hostname, port);
    }

    @Override
    public void resume(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.kill(service, hostname, port);
    }

    private void performClusterManagerCommand(ClusterManager.ServiceType role, String hostname, RoleCommand command) throws IOException {
        LOG.info((Object)("Performing " + (Object)((Object)command) + " command against " + (Object)((Object)role) + " on " + hostname + "..."));
        String serviceName = this.getServiceName(roleServiceType.get((Object)role));
        String hostId = this.getHostId(hostname);
        String roleName = this.getRoleName(serviceName, role.toString(), hostId);
        this.doRoleCommand(serviceName, roleName, command);
    }

    private void doRoleCommand(String serviceName, String roleName, RoleCommand roleCommand) {
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").path(serviceName).path("roleCommands").path(roleCommand.toString()).build(new Object[0]);
        String body = "{ \"items\": [ \"" + roleName + "\" ] }";
        LOG.info((Object)("Executing POST against " + uri + " with body " + body + "..."));
        ClientResponse response = (ClientResponse)this.client.resource(uri).type("application/json").post(ClientResponse.class, (Object)body);
        int statusCode = response.getStatus();
        if (statusCode != Response.Status.OK.getStatusCode()) {
            throw new HTTPException(statusCode);
        }
    }

    private String getHealthSummary(String serviceName, String roleType, String hostId) throws IOException {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "healthSummary");
    }

    private String getHostId(String hostname) throws IOException {
        String hostId = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("hosts").build(new Object[0]);
        JsonNode hosts = this.getJsonNodeFromURIGet(uri);
        if (hosts != null) {
            for (JsonNode host : hosts) {
                if (!host.get("hostname").getTextValue().equals(hostname)) continue;
                hostId = host.get("hostId").getTextValue();
                break;
            }
        } else {
            hostId = null;
        }
        return hostId;
    }

    private JsonNode getJsonNodeFromURIGet(URI uri) throws IOException {
        LOG.info((Object)("Executing GET against " + uri + "..."));
        ClientResponse response = (ClientResponse)this.client.resource(uri).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
        int statusCode = response.getStatus();
        if (statusCode != Response.Status.OK.getStatusCode()) {
            throw new HTTPException(statusCode);
        }
        return new ObjectMapper().readTree((String)response.getEntity(String.class)).get("items");
    }

    private String getRoleName(String serviceName, String roleType, String hostId) throws IOException {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "name");
    }

    private String getRolePropertyValue(String serviceName, String roleType, String hostId, String property) throws IOException {
        String roleValue = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").path(serviceName).path("roles").build(new Object[0]);
        JsonNode roles = this.getJsonNodeFromURIGet(uri);
        if (roles != null) {
            for (JsonNode role : roles) {
                if (!role.get("hostRef").get("hostId").getTextValue().equals(hostId) || !role.get("type").getTextValue().toLowerCase().equals(roleType.toLowerCase())) continue;
                roleValue = role.get(property).getTextValue();
                break;
            }
        }
        return roleValue;
    }

    private String getRoleState(String serviceName, String roleType, String hostId) throws IOException {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "roleState");
    }

    private String getServiceName(Service service) throws IOException {
        String serviceName = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").build(new Object[0]);
        JsonNode services = this.getJsonNodeFromURIGet(uri);
        if (services != null) {
            for (JsonNode serviceEntry : services) {
                if (!serviceEntry.get("type").getTextValue().equals(service.toString())) continue;
                serviceName = serviceEntry.get("name").getTextValue();
                break;
            }
        }
        return serviceName;
    }

    static {
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_NAMENODE, Service.HDFS);
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_DATANODE, Service.HDFS);
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_JOBTRACKER, Service.MAPREDUCE);
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_TASKTRACKER, Service.MAPREDUCE);
        roleServiceType.put(ClusterManager.ServiceType.HBASE_MASTER, Service.HBASE);
        roleServiceType.put(ClusterManager.ServiceType.HBASE_REGIONSERVER, Service.HBASE);
    }

    private static enum Service {
        HBASE,
        HDFS,
        MAPREDUCE;

    }

    private static enum RoleCommand {
        START,
        STOP,
        RESTART;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

