/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

public class AccumulatingReducer
extends MapReduceBase
implements Reducer<Text, Text, Text, Text> {
    static final String VALUE_TYPE_LONG = "l:";
    static final String VALUE_TYPE_FLOAT = "f:";
    static final String VALUE_TYPE_STRING = "s:";
    private static final Log LOG = LogFactory.getLog(AccumulatingReducer.class);
    protected String hostName;

    public AccumulatingReducer() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.hostName = "localhost";
        }
        LOG.info((Object)("Starting AccumulatingReducer on " + this.hostName));
    }

    public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String field = key.toString();
        reporter.setStatus("starting " + field + " ::host = " + this.hostName);
        if (field.startsWith(VALUE_TYPE_STRING)) {
            StringBuffer sSum = new StringBuffer();
            while (values.hasNext()) {
                sSum.append(values.next().toString()).append(";");
            }
            output.collect((Object)key, (Object)new Text(sSum.toString()));
            reporter.setStatus("finished " + field + " ::host = " + this.hostName);
            return;
        }
        if (field.startsWith(VALUE_TYPE_FLOAT)) {
            float fSum = 0.0f;
            while (values.hasNext()) {
                fSum += Float.parseFloat(values.next().toString());
            }
            output.collect((Object)key, (Object)new Text(String.valueOf(fSum)));
            reporter.setStatus("finished " + field + " ::host = " + this.hostName);
            return;
        }
        if (field.startsWith(VALUE_TYPE_LONG)) {
            long lSum = 0L;
            while (values.hasNext()) {
                lSum += Long.parseLong(values.next().toString());
            }
            output.collect((Object)key, (Object)new Text(String.valueOf(lSum)));
        }
        reporter.setStatus("finished " + field + " ::host = " + this.hostName);
    }
}

