/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlParser {
    private final HttpServletRequest request;
    private final Map<String, String> zeroDim = new HashMap<String, String>();
    private final Map<String, Map<Integer, String>> oneDim = new HashMap<String, Map<Integer, String>>();
    private final Map<String, Map<Integer, Map<Integer, String>>> twoDim = new HashMap<String, Map<Integer, Map<Integer, String>>>();

    public ControlParser(HttpServletRequest request) {
        this.request = request;
        this.parse();
    }

    private void parse() {
        Map controls = this.request.getParameterMap();
        for (Map.Entry control : controls.entrySet()) {
            HashMap<Integer, String> list;
            Map<Integer, Object> values;
            String controlName = ((String)control.getKey()).trim().toLowerCase();
            int firstIndex = ControlParser.getFirstIndex(controlName);
            if (firstIndex == -1) {
                this.zeroDim.put(controlName, ((String[])control.getValue())[0]);
                continue;
            }
            String strippedControlName = controlName.substring(0, controlName.indexOf(91));
            int secondIndex = ControlParser.getSecondIndex(controlName);
            if (secondIndex == -1) {
                values = this.oneDim.get(strippedControlName);
                if (values == null) {
                    values = new HashMap<Integer, String>();
                    this.oneDim.put(strippedControlName, values);
                }
                values.put(firstIndex, ((String[])control.getValue())[0]);
                continue;
            }
            values = this.twoDim.get(strippedControlName);
            if (values == null) {
                values = new HashMap<Integer, String>();
                this.twoDim.put(strippedControlName, values);
            }
            if ((list = (HashMap<Integer, String>)values.get(firstIndex)) == null) {
                list = new HashMap<Integer, String>();
                values.put(firstIndex, list);
            }
            list.put(secondIndex, ((String[])control.getValue())[0]);
        }
    }

    private static int getFirstIndex(String controlName) {
        int result = -1;
        int open = controlName.indexOf(91);
        int close = controlName.indexOf(93);
        if (open == -1 || close == -1 || close < open) {
            return result;
        }
        String indexStr = controlName.substring(open + 1, close);
        try {
            result = Integer.parseInt(indexStr);
            if (result < 0) {
                result = -1;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    private static int getSecondIndex(String controlName) {
        int result = -1;
        int open = controlName.indexOf("][");
        int close = controlName.lastIndexOf(93);
        if (open == -1 || close == -1 || close < open) {
            return result;
        }
        String indexStr = controlName.substring(open + 2, close);
        try {
            result = Integer.parseInt(indexStr);
            if (result < 0) {
                result = -1;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    private static List<String> convertToList(String controlName, Map<Integer, String> map) {
        if (map == null) {
            return null;
        }
        int count = map.size();
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String value = map.get(i);
            if (value == null) {
                throw new CmisInvalidArgumentException(controlName + " has gaps!");
            }
            result.add(value);
        }
        return result;
    }

    public String getValue(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return this.zeroDim.get(controlName.toLowerCase());
    }

    public List<String> getValues(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return ControlParser.convertToList(controlName, this.oneDim.get(controlName.toLowerCase()));
    }

    public List<String> getValues(String controlName, int index) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        Map<Integer, Map<Integer, String>> map = this.twoDim.get(controlName.toLowerCase());
        if (map == null) {
            return null;
        }
        return ControlParser.convertToList(controlName, map.get(index));
    }

    public Map<Integer, String> getOneDimMap(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return this.oneDim.get(controlName.toLowerCase());
    }

    public Map<Integer, Map<Integer, String>> getTwoDimMap(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return this.twoDim.get(controlName.toLowerCase());
    }
}

