/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class PolicyService {
    private PolicyService() {
    }

    public static void getAppliedPolicies(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filter;
        String objectId = HttpUtils.getStringParameter(request, "id");
        List policies = service.getAppliedPolicies(repositoryId, objectId, filter = HttpUtils.getStringParameter(request, "filter"), null);
        if (policies == null) {
            throw new CmisRuntimeException("Policies are null!");
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream());
        feed.startFeed(true);
        feed.writeFeedElements(objectInfo.getId(), objectInfo.getCreatedBy(), objectInfo.getName(), objectInfo.getLastModificationDate(), null, null);
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "policies", objectInfo.getId()), null);
        AtomEntry entry = new AtomEntry(feed.getWriter());
        for (ObjectData policy : policies) {
            if (policy == null) continue;
            PolicyService.writePolicyEntry(service, entry, objectInfo.getId(), policy, repositoryId, baseUrl);
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void applyPolicy(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = HttpUtils.getStringParameter(request, "id");
        AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream());
        service.applyPolicy(repositoryId, parser.getId(), objectId, null);
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, parser.getId());
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData policy = objectInfo.getObject();
        if (policy == null) {
            throw new CmisRuntimeException("Policy is null!");
        }
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        UrlBuilder location = AtomPubUtils.compileUrlBuilder(baseUrl, "policies", objectId);
        location.addParameter("policyId", (Object)policy.getId());
        response.setStatus(201);
        response.setContentType("application/atom+xml;type=entry");
        response.setHeader("Content-Location", location.toString());
        response.setHeader("Location", location.toString());
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        PolicyService.writePolicyEntry(service, entry, objectId, policy, repositoryId, baseUrl);
        entry.endDocument();
    }

    public static void removePolicy(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) {
        String objectId = HttpUtils.getStringParameter(request, "id");
        String policyId = HttpUtils.getStringParameter(request, "policyId");
        service.removePolicy(repositoryId, policyId, objectId, null);
        response.setStatus(204);
    }

    private static void writePolicyEntry(CmisService service, AtomEntry entry, String objectId, ObjectData policy, String repositoryId, UrlBuilder baseUrl) throws Exception {
        CmisObjectType resultJaxb = Converter.convert((ObjectData)policy);
        if (resultJaxb == null) {
            return;
        }
        ObjectInfo info = service.getObjectInfo(repositoryId, policy.getId());
        if (info == null) {
            throw new CmisRuntimeException("Object Info not found!");
        }
        entry.startEntry(false);
        entry.writeObject(policy, info, null, null, null, null);
        UrlBuilder selfLink = AtomPubUtils.compileUrlBuilder(baseUrl, "policies", objectId);
        selfLink.addParameter("policyId", (Object)info.getId());
        entry.writeSelfLink(selfLink.toString(), null);
        entry.endEntry();
    }
}

