/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.service.GCInspectorMXBean;
import org.apache.cassandra.utils.StatusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCInspector
implements NotificationListener,
GCInspectorMXBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.service:type=GCInspector";
    private static final Logger logger = LoggerFactory.getLogger(GCInspector.class);
    static final long MIN_LOG_DURATION = 200L;
    static final long MIN_LOG_DURATION_TPSTATS = 1000L;
    final AtomicReference<State> state = new AtomicReference<State>(new State());

    public GCInspector() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void register() throws Exception {
        GCInspector inspector = new GCInspector();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
        for (ObjectName name : server.queryNames(gcName, null)) {
            server.addNotificationListener(name, inspector, null, null);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (type.equals("com.sun.management.gc.notification")) {
            State prev;
            CompositeData cd = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(cd);
            long duration = info.getGcInfo().getDuration();
            StringBuilder sb = new StringBuilder();
            sb.append(info.getGcName()).append(" GC in ").append(duration).append("ms.  ");
            long bytes = 0L;
            ArrayList<String> keys = new ArrayList<String>(info.getGcInfo().getMemoryUsageBeforeGc().keySet());
            Collections.sort(keys);
            for (String key : keys) {
                MemoryUsage before = info.getGcInfo().getMemoryUsageBeforeGc().get(key);
                MemoryUsage after = info.getGcInfo().getMemoryUsageAfterGc().get(key);
                if (after == null || after.getUsed() == before.getUsed()) continue;
                sb.append(key).append(": ").append(before.getUsed());
                sb.append(" -> ");
                sb.append(after.getUsed());
                if (!key.equals(keys.get(keys.size() - 1))) {
                    sb.append("; ");
                }
                bytes += before.getUsed() - after.getUsed();
            }
            while (!this.state.compareAndSet(prev = this.state.get(), new State(duration, bytes, prev))) {
            }
            String st = sb.toString();
            if (duration > 200L) {
                logger.info(st);
            } else if (logger.isDebugEnabled()) {
                logger.debug(st);
            }
            if (duration > 1000L) {
                StatusLogger.log();
            }
            if (info.getGcName().equals("ConcurrentMarkSweep")) {
                SSTableDeletingTask.rescheduleFailedTasks();
            }
        }
    }

    public State getTotalSinceLastCheck() {
        return this.state.getAndSet(new State());
    }

    @Override
    public double[] getAndResetStats() {
        State state = this.getTotalSinceLastCheck();
        double[] r = new double[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - state.startNanos), state.maxRealTimeElapsed, state.totalRealTimeElapsed, state.sumSquaresRealTimeElapsed, state.totalBytesReclaimed, state.count};
        return r;
    }

    static final class State {
        final double maxRealTimeElapsed;
        final double totalRealTimeElapsed;
        final double sumSquaresRealTimeElapsed;
        final double totalBytesReclaimed;
        final double count;
        final long startNanos;

        State(double extraElapsed, double extraBytes, State prev) {
            this.totalRealTimeElapsed = prev.totalRealTimeElapsed + extraElapsed;
            this.totalBytesReclaimed = prev.totalBytesReclaimed + extraBytes;
            this.sumSquaresRealTimeElapsed = prev.sumSquaresRealTimeElapsed + extraElapsed * extraElapsed;
            this.startNanos = prev.startNanos;
            this.count = prev.count + 1.0;
            this.maxRealTimeElapsed = Math.max(prev.maxRealTimeElapsed, extraElapsed);
        }

        State() {
            this.totalBytesReclaimed = 0.0;
            this.totalRealTimeElapsed = 0.0;
            this.sumSquaresRealTimeElapsed = 0.0;
            this.maxRealTimeElapsed = 0.0;
            this.count = 0.0;
            this.startNanos = System.nanoTime();
        }
    }
}

