/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.cassandra.cache.RefCountedMemory;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Downsampling;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.SSTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryBuilder.class);
    private final ArrayList<Long> positions;
    private final ArrayList<DecoratedKey> keys;
    private final int minIndexInterval;
    private final int samplingLevel;
    private final int[] startPoints;
    private long keysWritten = 0L;
    private long indexIntervalMatches = 0L;
    private long offheapSize = 0L;

    public IndexSummaryBuilder(long expectedKeys, int minIndexInterval, int samplingLevel) {
        this.samplingLevel = samplingLevel;
        this.startPoints = Downsampling.getStartPoints(128, samplingLevel);
        long maxExpectedEntries = expectedKeys / (long)minIndexInterval;
        if (maxExpectedEntries > Integer.MAX_VALUE) {
            int effectiveMinInterval = (int)Math.ceil(2.147483647E9 / (double)expectedKeys);
            maxExpectedEntries = expectedKeys / (long)effectiveMinInterval;
            assert (maxExpectedEntries <= Integer.MAX_VALUE) : maxExpectedEntries;
            logger.warn("min_index_interval of {} is too low for {} expected keys; using interval of {} instead", new Object[]{minIndexInterval, expectedKeys, effectiveMinInterval});
            this.minIndexInterval = effectiveMinInterval;
        } else {
            this.minIndexInterval = minIndexInterval;
        }
        maxExpectedEntries = maxExpectedEntries * (long)samplingLevel / 128L;
        this.positions = new ArrayList((int)maxExpectedEntries);
        this.keys = new ArrayList((int)maxExpectedEntries);
    }

    public DecoratedKey getMaxReadableKey(long position, int offset) {
        int i = Collections.binarySearch(this.positions, position);
        i = i < 0 ? ((i = -1 - i) == this.positions.size() ? (i -= 2) : --i) : --i;
        if ((i -= offset) <= 0) {
            return null;
        }
        return this.keys.get(i);
    }

    public IndexSummaryBuilder maybeAddEntry(DecoratedKey decoratedKey, long indexPosition) {
        if (this.keysWritten % (long)this.minIndexInterval == 0L) {
            boolean shouldSkip = false;
            for (int start : this.startPoints) {
                if ((this.indexIntervalMatches - (long)start) % 128L != 0L) continue;
                shouldSkip = true;
                break;
            }
            if (!shouldSkip) {
                this.keys.add(SSTable.getMinimalKey(decoratedKey));
                this.offheapSize += (long)decoratedKey.getKey().remaining();
                this.positions.add(indexPosition);
                this.offheapSize += (long)TypeSizes.NATIVE.sizeof(indexPosition);
            }
            ++this.indexIntervalMatches;
        }
        ++this.keysWritten;
        return this;
    }

    public IndexSummary build(IPartitioner partitioner) {
        return this.build(partitioner, null);
    }

    public IndexSummary build(IPartitioner partitioner, DecoratedKey exclusiveUpperBound) {
        assert (this.keys.size() > 0);
        assert (this.keys.size() == this.positions.size());
        int length = exclusiveUpperBound == null ? this.keys.size() : Collections.binarySearch(this.keys, exclusiveUpperBound);
        assert (length > 0);
        long offheapSize = this.offheapSize;
        if (length < this.keys.size()) {
            for (int i = length; i < this.keys.size(); ++i) {
                offheapSize -= (long)(this.keys.get(i).getKey().remaining() + TypeSizes.NATIVE.sizeof(this.positions.get(i)));
            }
        }
        RefCountedMemory memory = new RefCountedMemory(offheapSize + (long)(length * 4));
        int idxPosition = 0;
        int keyPosition = length * 4;
        for (int i = 0; i < length; ++i) {
            memory.setInt(idxPosition, keyPosition);
            idxPosition += TypeSizes.NATIVE.sizeof(keyPosition);
            ByteBuffer keyBytes = this.keys.get(i).getKey();
            memory.setBytes(keyPosition, keyBytes);
            long actualIndexPosition = this.positions.get(i);
            memory.setLong(keyPosition += keyBytes.remaining(), actualIndexPosition);
            keyPosition += TypeSizes.NATIVE.sizeof(actualIndexPosition);
        }
        assert ((long)keyPosition == offheapSize + (long)(length * 4));
        int sizeAtFullSampling = (int)Math.ceil((double)this.keysWritten / (double)this.minIndexInterval);
        return new IndexSummary(partitioner, memory, length, sizeAtFullSampling, this.minIndexInterval, this.samplingLevel);
    }

    public static int entriesAtSamplingLevel(int samplingLevel, int maxSummarySize) {
        return (int)Math.ceil((double)(samplingLevel * maxSummarySize) / 128.0);
    }

    public static int calculateSamplingLevel(int currentSamplingLevel, int currentNumEntries, long targetNumEntries, int minIndexInterval, int maxIndexInterval) {
        int effectiveMinSamplingLevel = Math.max(1, (int)Math.ceil((double)(128 * minIndexInterval) / (double)maxIndexInterval));
        int newSamplingLevel = (int)(targetNumEntries * (long)currentSamplingLevel) / currentNumEntries;
        return Math.min(128, Math.max(effectiveMinSamplingLevel, newSamplingLevel));
    }

    public static IndexSummary downsample(IndexSummary existing, int newSamplingLevel, int minIndexInterval, IPartitioner partitioner) {
        int currentSamplingLevel = existing.getSamplingLevel();
        assert (currentSamplingLevel > newSamplingLevel);
        assert (minIndexInterval == existing.getMinIndexInterval());
        int[] startPoints = Downsampling.getStartPoints(currentSamplingLevel, newSamplingLevel);
        int removedKeyCount = 0;
        long newOffHeapSize = existing.getOffHeapSize();
        int[] arr$ = startPoints;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int start;
            for (int j = start = arr$[i$]; j < existing.size(); j += currentSamplingLevel) {
                ++removedKeyCount;
                newOffHeapSize -= (long)existing.getEntry(j).length;
            }
        }
        int newKeyCount = existing.size() - removedKeyCount;
        RefCountedMemory memory = new RefCountedMemory(newOffHeapSize - (long)(removedKeyCount * 4));
        int idxPosition = 0;
        int keyPosition = newKeyCount * 4;
        block2: for (int oldSummaryIndex = 0; oldSummaryIndex < existing.size(); ++oldSummaryIndex) {
            for (int start : startPoints) {
                if ((oldSummaryIndex - start) % currentSamplingLevel == 0) continue block2;
            }
            memory.setInt(idxPosition, keyPosition);
            idxPosition += TypeSizes.NATIVE.sizeof(keyPosition);
            byte[] entry = existing.getEntry(oldSummaryIndex);
            memory.setBytes(keyPosition, entry, 0, entry.length);
            keyPosition += entry.length;
        }
        return new IndexSummary(partitioner, memory, newKeyCount, existing.getMaxNumberOfEntries(), minIndexInterval, newSamplingLevel);
    }
}

