/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.service.FileCacheService;

public abstract class PoolingSegmentedFile
extends SegmentedFile {
    final FileCacheService.CacheKey cacheKey = new FileCacheService.CacheKey();

    protected PoolingSegmentedFile(String path, long length) {
        super(path, length);
    }

    protected PoolingSegmentedFile(String path, long length, long onDiskLength) {
        super(path, length, onDiskLength);
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = FileCacheService.instance.get(this.cacheKey);
        if (reader == null) {
            reader = this.createReader(this.path);
        }
        reader.seek(position);
        return reader;
    }

    protected abstract RandomAccessReader createReader(String var1);

    public void recycle(RandomAccessReader reader) {
        FileCacheService.instance.put(this.cacheKey, reader);
    }

    @Override
    public void cleanup() {
        FileCacheService.instance.invalidate(this.cacheKey, this.path);
    }
}

