/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferCounterCell;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractSSTableSimpleWriter
implements Closeable {
    protected final File directory;
    protected final CFMetaData metadata;
    protected DecoratedKey currentKey;
    protected ColumnFamily columnFamily;
    protected ByteBuffer currentSuperColumn;
    protected final CounterId counterid = CounterId.generate();
    protected static AtomicInteger generation = new AtomicInteger(0);

    public AbstractSSTableSimpleWriter(File directory, CFMetaData metadata, IPartitioner partitioner) {
        this.metadata = metadata;
        this.directory = directory;
        DatabaseDescriptor.setPartitioner(partitioner);
    }

    protected SSTableWriter getWriter() {
        return new SSTableWriter(AbstractSSTableSimpleWriter.makeFilename(this.directory, this.metadata.ksName, this.metadata.cfName), 0L, 0L, this.metadata, DatabaseDescriptor.getPartitioner(), new MetadataCollector(this.metadata.comparator));
    }

    protected static String makeFilename(File directory, String keyspace, final String columnFamily) {
        final HashSet existing = new HashSet();
        directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (desc == null) {
                    return false;
                }
                if (desc.cfname.equals(columnFamily)) {
                    existing.add(desc);
                }
                return false;
            }
        });
        int maxGen = generation.getAndIncrement();
        for (Descriptor desc : existing) {
            while (desc.generation > maxGen) {
                maxGen = generation.getAndIncrement();
            }
        }
        return new Descriptor(directory, keyspace, columnFamily, maxGen + 1, Descriptor.Type.TEMP).filenameFor(Component.DATA);
    }

    public void newRow(ByteBuffer key) throws IOException {
        if (this.currentKey != null && !this.columnFamily.isEmpty()) {
            this.writeRow(this.currentKey, this.columnFamily);
        }
        this.currentKey = DatabaseDescriptor.getPartitioner().decorateKey(key);
        this.columnFamily = this.getColumnFamily();
    }

    public void newSuperColumn(ByteBuffer name) {
        if (!this.columnFamily.metadata().isSuper()) {
            throw new IllegalStateException("Cannot add a super column to a standard column family");
        }
        this.currentSuperColumn = name;
    }

    protected void addColumn(Cell cell) throws IOException {
        if (this.columnFamily.metadata().isSuper()) {
            if (this.currentSuperColumn == null) {
                throw new IllegalStateException("Trying to add a cell to a super column family, but no super cell has been started.");
            }
            cell = cell.withUpdatedName(this.columnFamily.getComparator().makeCellName(this.currentSuperColumn, cell.name().toByteBuffer()));
        }
        this.columnFamily.addColumn(cell);
    }

    public void addColumn(ByteBuffer name, ByteBuffer value, long timestamp) throws IOException {
        this.addColumn(new BufferCell(this.metadata.comparator.cellFromByteBuffer(name), value, timestamp));
    }

    public void addExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int ttl, long expirationTimestampMS) throws IOException {
        this.addColumn(new BufferExpiringCell(this.metadata.comparator.cellFromByteBuffer(name), value, timestamp, ttl, (int)(expirationTimestampMS / 1000L)));
    }

    public void addCounterColumn(ByteBuffer name, long value) throws IOException {
        this.addColumn(new BufferCounterCell(this.metadata.comparator.cellFromByteBuffer(name), CounterContext.instance().createGlobal(this.counterid, 1L, value), System.currentTimeMillis()));
    }

    ColumnFamily currentColumnFamily() {
        return this.columnFamily;
    }

    DecoratedKey currentKey() {
        return this.currentKey;
    }

    protected abstract void writeRow(DecoratedKey var1, ColumnFamily var2) throws IOException;

    protected abstract ColumnFamily getColumnFamily() throws IOException;
}

