/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundDenseCellNameType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;

public class CompositesIndexOnCollectionValue
extends CompositesIndex {
    public static CellNameType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int prefixSize = columnDef.position();
        ArrayList types = new ArrayList(prefixSize + 2);
        types.add(SecondaryIndex.keyComparator);
        for (int i = 0; i < prefixSize; ++i) {
            types.add(baseMetadata.comparator.subtype(i));
        }
        types.add(((CollectionType)columnDef.type).nameComparator());
        return new CompoundDenseCellNameType(types);
    }

    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        return ((CollectionType)this.columnDef.type).valueComparator();
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        return cell.value();
    }

    @Override
    protected Composite makeIndexColumnPrefix(ByteBuffer rowKey, Composite cellName) {
        CBuilder builder = this.getIndexComparator().prefixBuilder();
        builder.add(rowKey);
        for (int i = 0; i < Math.min(this.columnDef.position(), cellName.size()); ++i) {
            builder.add(cellName.get(i));
        }
        if (cellName.size() >= this.columnDef.position() + 1) {
            builder.add(cellName.get(this.columnDef.position() + 1));
        }
        return builder.build();
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Cell indexEntry) {
        int prefixSize = this.columnDef.position();
        CellName name = indexEntry.name();
        CBuilder builder = this.baseCfs.getComparator().builder();
        for (int i = 0; i < prefixSize; ++i) {
            builder.add(name.get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, name, indexEntry.timestamp(), name.get(0), builder.build(), name.get(prefixSize + 1));
    }

    @Override
    public boolean supportsOperator(Operator operator) {
        return operator == Operator.CONTAINS;
    }

    @Override
    public boolean indexes(CellName name) {
        AbstractType<?> comp = this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
        return name.size() > this.columnDef.position() && comp.compare(name.get(this.columnDef.position()), this.columnDef.name.bytes) == 0;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        CellName name = data.getComparator().create(entry.indexedEntryPrefix, this.columnDef, entry.indexedEntryCollectionKey);
        Cell cell = data.getColumn(name);
        return cell == null || !cell.isLive(now) || ((CollectionType)this.columnDef.type).valueComparator().compare(entry.indexValue.getKey(), cell.value()) != 0;
    }
}

