/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.utils.Pair;

public class PendingFile {
    public static final PendingFileSerializer serializer = new PendingFileSerializer();
    public final SSTableReader sstable;
    public final Descriptor desc;
    public final String component;
    public final List<Pair<Long, Long>> sections;
    public final OperationType type;
    public final long size;
    public final long estimatedKeys;
    public final CompressionInfo compressionInfo;
    public long progress;

    public PendingFile(Descriptor desc, PendingFile pf) {
        this(null, desc, pf.component, pf.sections, pf.type, pf.estimatedKeys, pf.compressionInfo);
    }

    public PendingFile(SSTableReader sstable, Descriptor desc, String component, List<Pair<Long, Long>> sections, OperationType type) {
        this(sstable, desc, component, sections, type, 0L, null);
    }

    public PendingFile(SSTableReader sstable, Descriptor desc, String component, List<Pair<Long, Long>> sections, OperationType type, long estimatedKeys, CompressionInfo compressionInfo) {
        this.sstable = sstable;
        this.desc = desc;
        this.component = component;
        this.sections = sections;
        this.type = type;
        long tempSize = 0L;
        if (compressionInfo == null) {
            for (Pair<Long, Long> section : sections) {
                tempSize += (Long)section.right - (Long)section.left;
            }
        } else {
            for (CompressionMetadata.Chunk chunk : compressionInfo.chunks) {
                tempSize += (long)(chunk.length + 4);
            }
        }
        this.size = tempSize;
        this.estimatedKeys = estimatedKeys;
        this.compressionInfo = compressionInfo;
    }

    public String getFilename() {
        return this.desc.filenameFor(this.component);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PendingFile)) {
            return false;
        }
        PendingFile rhs = (PendingFile)o;
        return this.getFilename().equals(rhs.getFilename());
    }

    public int hashCode() {
        return this.getFilename().hashCode();
    }

    public String toString() {
        return this.getFilename() + " sections=" + this.sections.size() + " progress=" + this.progress + "/" + this.size + " - " + this.progress * 100L / this.size + "%";
    }

    public static class PendingFileSerializer
    implements IVersionedSerializer<PendingFile> {
        @Override
        public void serialize(PendingFile sc, DataOutput dos, int version) throws IOException {
            if (sc == null) {
                dos.writeUTF("");
                return;
            }
            dos.writeUTF(sc.desc.filenameFor(sc.component));
            dos.writeUTF(sc.component);
            dos.writeInt(sc.sections.size());
            for (Pair<Long, Long> section : sc.sections) {
                dos.writeLong((Long)section.left);
                dos.writeLong((Long)section.right);
            }
            dos.writeUTF(sc.type.name());
            dos.writeLong(sc.estimatedKeys);
            if (version > 4) {
                CompressionInfo.serializer.serialize(sc.compressionInfo, dos, version);
            }
        }

        @Override
        public PendingFile deserialize(DataInput dis, int version) throws IOException {
            String filename = dis.readUTF();
            if (filename.isEmpty()) {
                return null;
            }
            Descriptor desc = Descriptor.fromFilename(filename);
            String component = dis.readUTF();
            int count = dis.readInt();
            ArrayList<Pair<Long, Long>> sections = new ArrayList<Pair<Long, Long>>(count);
            for (int i = 0; i < count; ++i) {
                sections.add(Pair.create(dis.readLong(), dis.readLong()));
            }
            OperationType type = OperationType.RESTORE_REPLICA_COUNT;
            type = OperationType.valueOf(dis.readUTF());
            long estimatedKeys = dis.readLong();
            CompressionInfo info = null;
            if (version > 4) {
                info = CompressionInfo.serializer.deserialize(dis, version);
            }
            return new PendingFile(null, desc, component, sections, type, estimatedKeys, info);
        }

        @Override
        public long serializedSize(PendingFile pf, int version) {
            if (pf == null) {
                return TypeSizes.NATIVE.sizeof("");
            }
            long size = TypeSizes.NATIVE.sizeof(pf.desc.filenameFor(pf.component));
            size += (long)TypeSizes.NATIVE.sizeof(pf.component);
            size += (long)TypeSizes.NATIVE.sizeof(pf.sections.size());
            for (Pair<Long, Long> section : pf.sections) {
                size += (long)(TypeSizes.NATIVE.sizeof((Long)section.left) + TypeSizes.NATIVE.sizeof((Long)section.right));
            }
            size += (long)TypeSizes.NATIVE.sizeof(pf.type.name());
            size += (long)TypeSizes.NATIVE.sizeof(pf.estimatedKeys);
            if (version > 4) {
                size += CompressionInfo.serializer.serializedSize(pf.compressionInfo, version);
            }
            return size;
        }
    }
}

