/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommandSerializer;
import org.apache.cassandra.db.SliceFromReadCommandSerializer;
import org.apache.cassandra.io.IVersionedSerializer;

class ReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    private static final Map<Byte, IVersionedSerializer<ReadCommand>> CMD_SERIALIZER_MAP = new HashMap<Byte, IVersionedSerializer<ReadCommand>>();

    ReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand command, DataOutput dos, int version) throws IOException {
        dos.writeByte(command.commandType);
        CMD_SERIALIZER_MAP.get(command.commandType).serialize(command, dos, version);
    }

    @Override
    public ReadCommand deserialize(DataInput dis, int version) throws IOException {
        byte msgType = dis.readByte();
        return CMD_SERIALIZER_MAP.get(msgType).deserialize(dis, version);
    }

    @Override
    public long serializedSize(ReadCommand command, int version) {
        return 1L + CMD_SERIALIZER_MAP.get(command.commandType).serializedSize(command, version);
    }

    static {
        CMD_SERIALIZER_MAP.put((byte)1, new SliceByNamesReadCommandSerializer());
        CMD_SERIALIZER_MAP.put((byte)2, new SliceFromReadCommandSerializer());
    }
}

