/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.service.StorageService;

class HeaderSerializer
implements IVersionedSerializer<Header> {
    HeaderSerializer() {
    }

    @Override
    public void serialize(Header t, DataOutput dos, int version) throws IOException {
        CompactEndpointSerializationHelper.serialize(t.getFrom(), dos);
        dos.writeInt(t.getVerb().ordinal());
        dos.writeInt(t.details_.size());
        for (String key : t.details_.keySet()) {
            dos.writeUTF(key);
            byte[] value = t.details_.get(key);
            dos.writeInt(value.length);
            dos.write(value);
        }
    }

    @Override
    public Header deserialize(DataInput dis, int version) throws IOException {
        InetAddress from = CompactEndpointSerializationHelper.deserialize(dis);
        int verbOrdinal = dis.readInt();
        int size = dis.readInt();
        Hashtable<String, byte[]> details = new Hashtable<String, byte[]>(size);
        for (int i = 0; i < size; ++i) {
            String key = dis.readUTF();
            int length = dis.readInt();
            byte[] bytes = new byte[length];
            dis.readFully(bytes);
            details.put(key, bytes);
        }
        return new Header(from, StorageService.VERBS[verbOrdinal], details);
    }

    @Override
    public long serializedSize(Header header, int version) {
        throw new UnsupportedOperationException();
    }
}

