/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.compaction.LeveledCompactionTask;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveledCompactionStrategy
extends AbstractCompactionStrategy
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(LeveledCompactionStrategy.class);
    private final LeveledManifest manifest;
    private final String SSTABLE_SIZE_OPTION = "sstable_size_in_mb";
    private final int maxSSTableSizeInMB;
    private final AtomicReference<LeveledCompactionTask> task = new AtomicReference();

    public LeveledCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        super(cfs, options);
        int configuredMaxSSTableSize = 5;
        if (options != null) {
            String value;
            String string = value = options.containsKey("sstable_size_in_mb") ? options.get("sstable_size_in_mb") : null;
            if (null != value) {
                try {
                    configuredMaxSSTableSize = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    logger.warn(String.format("%s is not a parsable int (base10) for %s using default value", value, "sstable_size_in_mb"));
                }
            }
        }
        this.maxSSTableSizeInMB = configuredMaxSSTableSize;
        cfs.getDataTracker().subscribe(this);
        logger.debug("{} subscribed to the data tracker.", (Object)this);
        this.manifest = LeveledManifest.create(cfs, this.maxSSTableSizeInMB);
        logger.debug("Created {}", (Object)this.manifest);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.cfs.getDataTracker().unsubscribe(this);
    }

    public int getLevelSize(int i) {
        return this.manifest.getLevelSize(i);
    }

    @Override
    public AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        if (this.cfs.isCompactionDisabled()) {
            return null;
        }
        return this.getMaximalTask(gcBefore);
    }

    @Override
    public AbstractCompactionTask getMaximalTask(int gcBefore) {
        LeveledCompactionTask currentTask = this.task.get();
        if (currentTask != null && !currentTask.isDone()) {
            logger.debug("Compaction still in progress for {}", (Object)this);
            return null;
        }
        Collection<SSTableReader> sstables = this.manifest.getCompactionCandidates();
        if (sstables.isEmpty()) {
            logger.debug("No compaction necessary for {}", (Object)this);
            return null;
        }
        LeveledCompactionTask newTask = new LeveledCompactionTask(this.cfs, sstables, gcBefore, this.maxSSTableSizeInMB);
        return this.task.compareAndSet(currentTask, newTask) ? newTask : null;
    }

    @Override
    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        throw new UnsupportedOperationException("LevelDB compaction strategy does not allow user-specified compactions");
    }

    @Override
    public int getEstimatedRemainingTasks() {
        return this.manifest.getEstimatedTasks();
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
            this.manifest.add(flushedNotification.added);
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
            switch (listChangedNotification.compactionType) {
                case CLEANUP: 
                case SCRUB: 
                case UPGRADE_SSTABLES: {
                    this.manifest.replace(listChangedNotification.removed, listChangedNotification.added);
                    break;
                }
                default: {
                    this.manifest.promote(listChangedNotification.removed, listChangedNotification.added);
                }
            }
        }
    }

    @Override
    public long getMaxSSTableSize() {
        return (long)this.maxSSTableSizeInMB * 1024L * 1024L;
    }

    @Override
    public boolean isKeyExistenceExpensive(Set<? extends SSTable> sstablesToIgnore) {
        ImmutableSet L0 = ImmutableSet.copyOf(this.manifest.getLevel(0));
        return Sets.difference((Set)L0, sstablesToIgnore).size() + this.manifest.getLevelCount() > 20;
    }

    @Override
    public List<ICompactionScanner> getScanners(Collection<SSTableReader> sstables, Range<Token> range) throws IOException {
        ArrayListMultimap byLevel = ArrayListMultimap.create();
        for (SSTableReader sstable : sstables) {
            byLevel.get((Object)this.manifest.levelOf(sstable)).add(sstable);
        }
        ArrayList<ICompactionScanner> scanners = new ArrayList<ICompactionScanner>(sstables.size());
        for (Integer level : byLevel.keySet()) {
            if (level == 0) {
                for (SSTableReader sstable : byLevel.get((Object)level)) {
                    scanners.add(sstable.getDirectScanner(range));
                }
                continue;
            }
            scanners.add(new LeveledScanner(byLevel.get((Object)level), range));
        }
        return scanners;
    }

    public String toString() {
        return String.format("LCS@%d(%s)", this.hashCode(), this.cfs.columnFamily);
    }

    private static class LeveledScanner
    extends AbstractIterator<IColumnIterator>
    implements ICompactionScanner {
        private final Range<Token> range;
        private final List<SSTableReader> sstables;
        private final Iterator<SSTableReader> sstableIterator;
        private final long totalLength;
        private SSTableScanner currentScanner;
        private long positionOffset;

        public LeveledScanner(Collection<SSTableReader> sstables, Range<Token> range) {
            this.range = range;
            this.sstables = new ArrayList<SSTableReader>(sstables);
            Collections.sort(this.sstables, SSTable.sstableComparator);
            this.sstableIterator = this.sstables.iterator();
            long length = 0L;
            for (SSTableReader sstable : sstables) {
                length += sstable.uncompressedLength();
            }
            this.totalLength = length;
        }

        protected IColumnIterator computeNext() {
            try {
                if (this.currentScanner != null) {
                    if (this.currentScanner.hasNext()) {
                        return this.currentScanner.next();
                    }
                    this.positionOffset += this.currentScanner.getLengthInBytes();
                    this.currentScanner.close();
                    this.currentScanner = null;
                    return this.computeNext();
                }
                if (!this.sstableIterator.hasNext()) {
                    return (IColumnIterator)this.endOfData();
                }
                this.currentScanner = this.sstableIterator.next().getDirectScanner(this.range);
                return this.computeNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.currentScanner != null) {
                this.currentScanner.close();
            }
        }

        @Override
        public long getLengthInBytes() {
            return this.totalLength;
        }

        @Override
        public long getCurrentPosition() {
            return this.positionOffset + (this.currentScanner == null ? 0L : this.currentScanner.getCurrentPosition());
        }

        @Override
        public String getBackingFiles() {
            return Joiner.on((String)", ").join(this.sstables);
        }
    }
}

