/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CFDefinition
implements Iterable<Name> {
    public static final AbstractType<?> definitionType = UTF8Type.instance;
    private static final String DEFAULT_KEY_ALIAS = "key";
    private static final String DEFAULT_COLUMN_ALIAS = "column";
    private static final String DEFAULT_VALUE_ALIAS = "value";
    public final CFMetaData cfm;
    public final Name key;
    public final LinkedHashMap<ColumnIdentifier, Name> columns = new LinkedHashMap();
    public final Name value;
    public final Map<ColumnIdentifier, Name> metadata = new TreeMap<ColumnIdentifier, Name>();
    public final boolean isComposite;
    public final boolean isCompact;

    public CFDefinition(CFMetaData cfm) {
        this.cfm = cfm;
        this.key = new Name(CFDefinition.getKeyId(cfm), Name.Kind.KEY_ALIAS, cfm.getKeyValidator());
        if (cfm.comparator instanceof CompositeType) {
            this.isComposite = true;
            CompositeType composite = (CompositeType)cfm.comparator;
            if (cfm.getColumn_metadata().isEmpty()) {
                this.isCompact = true;
                for (int i = 0; i < composite.types.size(); ++i) {
                    ColumnIdentifier id = CFDefinition.getColumnId(cfm, i);
                    this.columns.put(id, new Name(id, Name.Kind.COLUMN_ALIAS, i, composite.types.get(i)));
                }
                this.value = new Name(CFDefinition.getValueId(cfm), Name.Kind.VALUE_ALIAS, cfm.getDefaultValidator());
            } else {
                this.isCompact = false;
                this.value = null;
                assert (cfm.getValueAlias() == null);
                for (int i = 0; i < composite.types.size() - 1; ++i) {
                    ColumnIdentifier id = CFDefinition.getColumnId(cfm, i);
                    this.columns.put(id, new Name(id, Name.Kind.COLUMN_ALIAS, i, composite.types.get(i)));
                }
                for (Map.Entry<ByteBuffer, ColumnDefinition> def : cfm.getColumn_metadata().entrySet()) {
                    ColumnIdentifier id = new ColumnIdentifier(def.getKey(), cfm.getColumnDefinitionComparator(def.getValue()));
                    this.metadata.put(id, new Name(id, Name.Kind.COLUMN_METADATA, def.getValue().getValidator()));
                }
            }
        } else {
            this.isComposite = false;
            if (cfm.getColumn_metadata().isEmpty()) {
                this.isCompact = true;
                ColumnIdentifier id = CFDefinition.getColumnId(cfm, 0);
                Name name = new Name(id, Name.Kind.COLUMN_ALIAS, 0, cfm.comparator);
                this.columns.put(id, name);
                this.value = new Name(CFDefinition.getValueId(cfm), Name.Kind.VALUE_ALIAS, cfm.getDefaultValidator());
            } else {
                this.isCompact = false;
                this.value = null;
                assert (cfm.getValueAlias() == null);
                assert (cfm.getColumnAliases() == null || cfm.getColumnAliases().isEmpty());
                for (Map.Entry<ByteBuffer, ColumnDefinition> def : cfm.getColumn_metadata().entrySet()) {
                    ColumnIdentifier id = new ColumnIdentifier(def.getKey(), cfm.getColumnDefinitionComparator(def.getValue()));
                    this.metadata.put(id, new Name(id, Name.Kind.COLUMN_METADATA, def.getValue().getValidator()));
                }
            }
        }
        assert (this.value == null || this.metadata.isEmpty());
    }

    private static ColumnIdentifier getKeyId(CFMetaData cfm) {
        return cfm.getKeyAlias() == null ? new ColumnIdentifier(DEFAULT_KEY_ALIAS, false) : new ColumnIdentifier(cfm.getKeyAlias(), definitionType);
    }

    private static ColumnIdentifier getColumnId(CFMetaData cfm, int i) {
        List<ByteBuffer> definedNames = cfm.getColumnAliases();
        return definedNames == null || i >= definedNames.size() ? new ColumnIdentifier(DEFAULT_COLUMN_ALIAS + (i + 1), false) : new ColumnIdentifier(cfm.getColumnAliases().get(i), definitionType);
    }

    private static ColumnIdentifier getValueId(CFMetaData cfm) {
        return cfm.getValueAlias() == null ? new ColumnIdentifier(DEFAULT_VALUE_ALIAS, false) : new ColumnIdentifier(cfm.getValueAlias(), definitionType);
    }

    public Name get(ColumnIdentifier name) {
        if (name.equals(this.key.name)) {
            return this.key;
        }
        if (this.value != null && name.equals(this.value.name)) {
            return this.value;
        }
        Name def = this.columns.get(name);
        if (def != null) {
            return def;
        }
        return this.metadata.get(name);
    }

    @Override
    public Iterator<Name> iterator() {
        return new AbstractIterator<Name>(){
            private boolean keyDone;
            private final Iterator<Name> columnIter;
            private boolean valueDone;
            private final Iterator<Name> metadataIter;
            {
                this.columnIter = CFDefinition.this.columns.values().iterator();
                this.metadataIter = CFDefinition.this.metadata.values().iterator();
            }

            protected Name computeNext() {
                if (!this.keyDone) {
                    this.keyDone = true;
                    return CFDefinition.this.key;
                }
                if (this.columnIter.hasNext()) {
                    return this.columnIter.next();
                }
                if (CFDefinition.this.value != null && !this.valueDone) {
                    this.valueDone = true;
                    return CFDefinition.this.value;
                }
                if (this.metadataIter.hasNext()) {
                    return this.metadataIter.next();
                }
                return (Name)this.endOfData();
            }
        };
    }

    public ColumnNameBuilder getColumnNameBuilder() {
        return this.isComposite ? new CompositeType.Builder((CompositeType)this.cfm.comparator) : new NonCompositeBuilder(this.cfm.comparator);
    }

    public AbstractType<?> getNameComparatorForResultSet(Name name) {
        if (!this.isCompact && !this.isComposite) {
            return this.cfm.comparator;
        }
        return definitionType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.name);
        for (Name name : this.columns.values()) {
            sb.append(", ").append(name.name);
        }
        sb.append(" => ");
        if (this.value != null) {
            sb.append(this.value.name);
        }
        if (!this.metadata.isEmpty()) {
            sb.append("{");
            for (Name name : this.metadata.values()) {
                sb.append(" ").append(name.name);
            }
            sb.append(" }");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class NonCompositeBuilder
    implements ColumnNameBuilder {
        private final AbstractType<?> type;
        private ByteBuffer columnName;

        private NonCompositeBuilder(AbstractType<?> type) {
            this.type = type;
        }

        @Override
        public NonCompositeBuilder add(ByteBuffer bb) {
            if (this.columnName != null) {
                throw new IllegalStateException("Column name is already constructed");
            }
            this.columnName = bb;
            return this;
        }

        @Override
        public NonCompositeBuilder add(Term t, Relation.Type op, List<ByteBuffer> variables) throws InvalidRequestException {
            if (this.columnName != null) {
                throw new IllegalStateException("Column name is already constructed");
            }
            this.columnName = t.getByteBuffer(this.type, variables);
            return this;
        }

        @Override
        public int componentCount() {
            return this.columnName == null ? 0 : 1;
        }

        @Override
        public ByteBuffer build() {
            return this.columnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.columnName;
        }

        @Override
        public ByteBuffer buildAsEndOfRange() {
            throw new IllegalStateException();
        }

        @Override
        public NonCompositeBuilder copy() {
            NonCompositeBuilder newBuilder = new NonCompositeBuilder(this.type);
            newBuilder.columnName = this.columnName;
            return newBuilder;
        }
    }

    public static class Name {
        public final Kind kind;
        public final ColumnIdentifier name;
        public final int position;
        public final AbstractType<?> type;

        private Name(ColumnIdentifier name, Kind kind, AbstractType<?> type) {
            this(name, kind, -1, type);
        }

        private Name(ColumnIdentifier name, Kind kind, int position, AbstractType<?> type) {
            this.kind = kind;
            this.name = name;
            this.position = position;
            this.type = type;
        }

        public String toString() {
            return this.name.toString();
        }

        public static enum Kind {
            KEY_ALIAS,
            COLUMN_ALIAS,
            VALUE_ALIAS,
            COLUMN_METADATA;

        }
    }
}

