/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.metafacades.emf.uml22.AssociationEnd;
import org.andromda.metafacades.emf.uml22.AssociationEndImpl;
import org.andromda.metafacades.emf.uml22.Attribute;
import org.andromda.metafacades.emf.uml22.AttributeImpl;
import org.andromda.metafacades.emf.uml22.AttributeLink;
import org.andromda.metafacades.emf.uml22.AttributeLinkImpl;
import org.andromda.metafacades.emf.uml22.LinkEnd;
import org.andromda.metafacades.emf.uml22.LinkEndImpl;
import org.andromda.metafacades.emf.uml22.LinkInstance;
import org.andromda.metafacades.emf.uml22.LinkInstanceImpl;
import org.andromda.metafacades.emf.uml22.ObjectInstance;
import org.andromda.metafacades.emf.uml22.ObjectInstanceImpl;
import org.andromda.metafacades.emf.uml22.TagDefinition;
import org.andromda.metafacades.emf.uml22.TagDefinitionImpl;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.resource.UMLResource;

public class UmlUtilities {
    private static final Logger LOGGER = Logger.getLogger(UmlUtilities.class);
    private static List<Package> models = new ArrayList<Package>();
    protected static final Transformer ELEMENT_TRANSFORMER = new Transformer(){

        public Object transform(Object element) {
            Object transformedObject;
            if (element instanceof Property) {
                Property property = (Property)element;
                transformedObject = property instanceof AssociationEnd || property instanceof Attribute ? property : (property.getAssociation() == null ? new AttributeImpl(property) : new AssociationEndImpl(property));
                if (LOGGER.isDebugEnabled() && property.getName() != null && !property.getName().startsWith("andromda")) {
                    LOGGER.debug((Object)("UMLUtilities.transform " + property.getName() + " " + property.getType().getName() + " " + property + " " + transformedObject));
                }
            } else {
                InstanceSpecification instanceSpecification;
                Slot slot;
                transformedObject = element instanceof Slot ? ((slot = (Slot)element) instanceof LinkEnd || slot instanceof AttributeLink ? slot : (this.transform(slot.getDefiningFeature()) instanceof Attribute ? new AttributeLinkImpl(slot) : new LinkEndImpl(slot))) : (element instanceof InstanceSpecification ? ((instanceSpecification = (InstanceSpecification)element) instanceof LinkInstance || instanceSpecification instanceof ObjectInstance || instanceSpecification instanceof EnumerationLiteral ? instanceSpecification : (!instanceSpecification.getClassifiers().isEmpty() && instanceSpecification.getClassifiers().iterator().next() instanceof Class ? new ObjectInstanceImpl(instanceSpecification) : new LinkInstanceImpl(instanceSpecification))) : element);
            }
            return transformedObject;
        }
    };
    private static final Map<String, List<EObject>> ALL_META_OBJECTS_CACHE = Collections.synchronizedMap(new HashMap());
    @Deprecated
    private static final String TAGGED_VALUES_STEREOTYPE = "AndroMdaTags";

    public static List<Package> getModels() {
        return models;
    }

    public static void setModels(List<Package> resources) {
        models = Collections.synchronizedList(resources);
    }

    public static void addModel(Package resource) {
        models.add(resource);
    }

    public static void removeModel(Package resource) {
        models.remove(resource);
    }

    public static List<? extends EObject> getAllMetaObjectsInstanceOf(java.lang.Class metaClass, List<Package> models) {
        if (metaClass == null) {
            return new ArrayList();
        }
        List<EObject> metaObjects = ALL_META_OBJECTS_CACHE.get(metaClass.getCanonicalName());
        if (metaObjects == null) {
            metaObjects = new ArrayList<EObject>();
            for (Package model : models) {
                if (model == null) continue;
                TreeIterator it = model.eAllContents();
                while (it.hasNext()) {
                    EObject metaObject = (EObject)it.next();
                    if (!metaClass.isInstance(metaObject)) continue;
                    metaObjects.add(metaObject);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("getAllMetaObjectsInstanceOf class: " + metaClass.getCanonicalName() + " " + metaClass.getClass() + " Found: " + metaObject.getClass()));
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getAllMetaObjectsInstanceOf class: " + metaClass.getCanonicalName() + ' ' + metaClass.getClass() + " Found: " + metaObjects.size()));
        }
        ALL_META_OBJECTS_CACHE.put(metaClass.getCanonicalName(), metaObjects);
        return metaObjects;
    }

    private static List getAllMetaObjectsInstanceOf(java.lang.Class metaClass, Package model) {
        if (metaClass == null) {
            return new ArrayList();
        }
        ArrayList<EObject> metaObjects = new ArrayList<EObject>();
        if (model != null) {
            TreeIterator it = model.eAllContents();
            while (it.hasNext()) {
                EObject metaObject = (EObject)it.next();
                if (!metaClass.isInstance(metaObject)) continue;
                metaObjects.add(metaObject);
            }
        }
        return metaObjects;
    }

    public static void clearAllMetaObjectsCache() {
        ALL_META_OBJECTS_CACHE.clear();
    }

    public static String getComment(Element element) {
        if (element == null) {
            return null;
        }
        StringBuilder commentString = new StringBuilder();
        EList comments = element.getOwnedComments();
        for (Comment comment : comments) {
            if (commentString.length() > 0) {
                commentString.append("\n\n");
            }
            commentString.append(comment.getBody());
        }
        return UmlUtilities.cleanText(commentString.toString());
    }

    public static String cleanText(String text) {
        if (StringUtils.isBlank((String)text)) {
            return text;
        }
        text = text.replaceAll("[\\t\\n]*", "");
        text = text.replaceAll("\\s+", " ");
        return text;
    }

    public static List<Property> getOwnedProperty(Classifier classifier, boolean follow, boolean isAssociation) {
        if (classifier == null) {
            return new ArrayList<Property>();
        }
        LinkedHashMap<String, Property> attributeMap = new LinkedHashMap<String, Property>();
        ArrayList members = new ArrayList(classifier.getOwnedMembers());
        if (follow) {
            members.addAll(classifier.getInheritedMembers());
        }
        for (NamedElement nextCandidate : members) {
            if (!(nextCandidate instanceof Property)) continue;
            Property property = (Property)nextCandidate;
            if (isAssociation && property.getAssociation() != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Association found for " + classifier.getName() + ": " + property.getName()));
                }
                attributeMap.put(property.getName(), property);
                continue;
            }
            if (isAssociation || property.getAssociation() != null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Attribute found for " + classifier.getName() + ": " + property.getName()));
            }
            attributeMap.put(property.getName(), property);
        }
        return new ArrayList<Property>(attributeMap.values());
    }

    public static List<Property> getAttributes(Classifier classifier, boolean follow) {
        List<Property> attributeList = UmlUtilities.getOwnedProperty(classifier, follow, false);
        CollectionUtils.transform(attributeList, (Transformer)ELEMENT_TRANSFORMER);
        if (LOGGER.isDebugEnabled()) {
            for (Property property : attributeList) {
                if (classifier.getQualifiedName().startsWith("andromda")) continue;
                LOGGER.debug((Object)("UMLUtilities.getAttributes " + classifier.getQualifiedName() + " " + property.getName() + " " + property.getType().getName()));
            }
        }
        return attributeList;
    }

    public static boolean isAssociationEndAttachedToType(Classifier classifier, Property property, boolean follow) {
        boolean attachedToType = false;
        if (property.getAssociation() != null) {
            attachedToType = classifier.equals(property.getType());
            if (follow && !attachedToType) {
                for (Classifier parent : classifier.getGenerals()) {
                    attachedToType = UmlUtilities.isAssociationEndAttachedToType(parent, property, follow);
                }
            }
            if (LOGGER.isDebugEnabled() && attachedToType) {
                LOGGER.debug((Object)("isAssociationEndAttachedToType " + classifier.getQualifiedName() + ' ' + property + ' ' + property.getQualifiedName() + ' ' + property.getAssociation() + ' ' + property.getAssociationEnd() + ' ' + attachedToType));
            }
        }
        return attachedToType;
    }

    public static List<Property> getAssociationEnds(Classifier classifier, boolean follow) {
        LinkedHashSet<Property> associationEnds = new LinkedHashSet<Property>();
        if (classifier == null) {
            return Collections.emptyList();
        }
        associationEnds.addAll(UmlUtilities.getOwnedProperty(classifier, follow, true));
        CollectionUtils.transform(associationEnds, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return UmlUtilities.getOppositeProperty((Property)input);
            }
        });
        Package modelPackage = UmlUtilities.findModel((Element)classifier);
        List allProperties = UmlUtilities.getAllMetaObjectsInstanceOf(Property.class, modelPackage);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getAssociationEnds " + classifier.getQualifiedName() + ": getAllMetaObjectsInstanceOf=" + allProperties.size()));
        }
        for (Property property : allProperties) {
            if (property.getAssociation() == null || !UmlUtilities.isAssociationEndAttachedToType(classifier, property, follow)) continue;
            associationEnds.add(property);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("getAssociationEnds " + classifier.getQualifiedName() + ": addedAssociation " + property + ' ' + property.getType() + ' ' + property.getAssociation() + " AssociationEnd=" + property.getAssociationEnd() + " OwnedEnds=" + property.getAssociation().getOwnedEnds() + " Qualifiers=" + property.getQualifiers() + " Navigable=" + property.isNavigable()));
        }
        CollectionUtils.transform(associationEnds, (Transformer)ELEMENT_TRANSFORMER);
        return new ArrayList<Property>(associationEnds);
    }

    public static boolean isSameSignature(Operation first, Operation second) {
        boolean sameSignature = true;
        if (UmlUtilities.isEqual(first.getName(), second.getName())) {
            EList firstParameters = first.getOwnedParameters();
            EList secondParameters = second.getOwnedParameters();
            if (firstParameters.size() == secondParameters.size()) {
                for (int i = 0; i < firstParameters.size() && sameSignature; ++i) {
                    Parameter firstParameter = (Parameter)firstParameters.get(i);
                    Parameter secondParameter = (Parameter)secondParameters.get(i);
                    sameSignature = UmlUtilities.isEqual(firstParameter.getType(), secondParameter.getType());
                }
            } else {
                sameSignature = false;
            }
        } else {
            sameSignature = false;
        }
        return sameSignature;
    }

    private static boolean isEqual(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public static List<Classifier> getSpecializations(Classifier classifier) {
        ArrayList<Classifier> specials = new ArrayList<Classifier>();
        if (classifier == null) {
            return specials;
        }
        TreeIterator iterator = EcoreUtil.getRootContainer((EObject)classifier).eAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (!(object instanceof Generalization)) continue;
            Generalization generalization = (Generalization)object;
            if (generalization.getGeneral().equals(classifier)) {
                specials.add(generalization.getSpecific());
            }
            iterator.prune();
        }
        return specials;
    }

    public static List<String> getStereotypeNames(Element element) {
        ArrayList<String> names = new ArrayList<String>();
        if (element == null) {
            return names;
        }
        EList stereotypes = element.getAppliedStereotypes();
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                names.add(stereotype.getName());
            }
        }
        return names;
    }

    public static boolean containsStereotype(Element element, String stereotypeName) {
        boolean hasStereotype;
        if (element == null || StringUtils.isBlank((String)stereotypeName)) {
            return false;
        }
        EList stereotypes = element.getAppliedStereotypes();
        boolean bl = hasStereotype = StringUtils.isNotBlank((String)stereotypeName) && stereotypes != null && !stereotypes.isEmpty();
        if (hasStereotype) {
            class StereotypeFilter
            implements Predicate {
                final /* synthetic */ String val$stereotypeName;

                StereotypeFilter(String string) {
                    this.val$stereotypeName = string;
                }

                public boolean evaluate(Object object) {
                    Stereotype stereotype = (Stereotype)object;
                    String name = StringUtils.trimToEmpty((String)stereotype.getName());
                    boolean valid = this.val$stereotypeName.equalsIgnoreCase(name);
                    for (Classifier itStereo : stereotype.allParents()) {
                        valid = valid || StringUtils.trimToEmpty((String)itStereo.getName()).equalsIgnoreCase(this.val$stereotypeName);
                    }
                    return valid;
                }
            }
            boolean bl2 = hasStereotype = CollectionUtils.find((Collection)stereotypes, (Predicate)new StereotypeFilter(stereotypeName)) != null;
        }
        if (LOGGER.isDebugEnabled() && hasStereotype) {
            if (element instanceof NamedElement) {
                LOGGER.debug((Object)(((NamedElement)element).getQualifiedName() + " has stereotype <<" + stereotypeName + ">> : " + hasStereotype));
            } else {
                LOGGER.debug((Object)(element.toString() + " has stereotype <<" + stereotypeName + ">> : " + hasStereotype));
            }
        }
        return hasStereotype;
    }

    public static Collection<TagDefinition> getTaggedValue(Element element) {
        ArrayList<TagDefinition> tags = new ArrayList<TagDefinition>();
        if (element == null) {
            return tags;
        }
        String elementName = "";
        elementName = element instanceof NamedElement ? ((NamedElement)element).getName() : element.toString();
        EList stereotypes = element.getAppliedStereotypes();
        for (Stereotype stereo : stereotypes) {
            if (TAGGED_VALUES_STEREOTYPE.equals(stereo.getName())) {
                List tagNames = (List)element.getValue(stereo, "TagName");
                List tagValues = (List)element.getValue(stereo, "TagValue");
                for (int ctr = 0; ctr < tagValues.size(); ++ctr) {
                    tags.add(new TagDefinitionImpl(tagNames.get(ctr).toString(), tagValues.get(ctr)));
                }
                continue;
            }
            if (element.hasValue(stereo, "value")) {
                Object value = element.getValue(stereo, "value");
                tags.add(new TagDefinitionImpl(stereo.getName(), value));
                continue;
            }
            for (Property tagProperty : UmlUtilities.getAttributes((Classifier)stereo, true)) {
                String tagName = tagProperty.getName();
                if (tagName.startsWith("base$") || !element.hasValue(stereo, tagName)) continue;
                Object tagValue = element.getValue(stereo, tagName);
                if (tagValue instanceof Collection) {
                    Collection tagValues = (Collection)tagValue;
                    if (tagValues.isEmpty()) continue;
                    Collection tagValuesInString = CollectionUtils.collect((Collection)tagValues, (Transformer)new Transformer(){

                        public Object transform(Object object) {
                            return UmlUtilities.getTagValueAsString(object);
                        }
                    });
                    TagDefinitionImpl tagDefinition = new TagDefinitionImpl(tagName, tagValuesInString);
                    tags.add(tagDefinition);
                    continue;
                }
                String tagString = UmlUtilities.getTagValueAsString(tagValue);
                if (StringUtils.isBlank((String)tagString) || "default".equalsIgnoreCase(tagString)) continue;
                TagDefinitionImpl tagDefinition = new TagDefinitionImpl(tagName, tagString);
                tags.add(tagDefinition);
            }
        }
        if (LOGGER.isDebugEnabled() && !tags.isEmpty()) {
            LOGGER.debug((Object)("Found " + tags.size() + " tagged values for " + elementName));
        }
        return tags;
    }

    static String getTagValueAsString(Object tagValue) {
        String valueAsString = null;
        if (tagValue != null) {
            valueAsString = tagValue.toString();
            if (tagValue instanceof ValueSpecification) {
                ValueSpecification literal = (ValueSpecification)tagValue;
                valueAsString = literal.stringValue();
            } else if (tagValue instanceof NamedElement) {
                NamedElement instance = (NamedElement)tagValue;
                valueAsString = instance.getName();
            }
        }
        return valueAsString;
    }

    public static Stereotype findAppliedStereotype(Element element, String name) {
        EList stereotypes;
        if (element == null || StringUtils.isBlank((String)name)) {
            return null;
        }
        Stereotype foundStereotype = element.getAppliedStereotype(name);
        if (foundStereotype == null && (stereotypes = element.getAppliedStereotypes()) != null) {
            for (Stereotype stereotype : stereotypes) {
                if (!stereotype.getName().equals(name)) continue;
                foundStereotype = stereotype;
                break;
            }
        }
        return foundStereotype;
    }

    public static Stereotype findApplicableStereotype(Element element, String name) {
        EList stereotypes;
        if (element == null || StringUtils.isBlank((String)name)) {
            return null;
        }
        Stereotype foundStereotype = element.getApplicableStereotype(name);
        if (foundStereotype == null && (stereotypes = element.getApplicableStereotypes()) != null) {
            for (Stereotype stereotype : stereotypes) {
                if (!stereotype.getName().equals(name)) continue;
                foundStereotype = stereotype;
                break;
            }
        }
        return foundStereotype;
    }

    static String getSerialVersionUID(ClassifierFacade classifier) {
        ExceptionUtils.checkNull((String)"classifer", (Object)classifier);
        String serialVersionString = (String)classifier.findTaggedValue(UMLProfile.TAGGEDVALUE_SERIALVERSION_UID);
        return StringUtils.trimToNull((String)serialVersionString);
    }

    public static Property getOppositeProperty(Property associationEnd) {
        Association association;
        if (associationEnd == null) {
            return null;
        }
        Property opposite = associationEnd.getOpposite();
        if (opposite == null && (association = associationEnd.getAssociation()) != null) {
            EList ends = association.getMemberEnds();
            for (Property end : ends) {
                if (end == null || associationEnd.equals(end)) continue;
                opposite = end;
                break;
            }
        }
        return opposite;
    }

    public static AssociationEnd getOppositeAssociationEnd(Property associationEnd) {
        if (associationEnd == null) {
            return null;
        }
        return new AssociationEndImpl(UmlUtilities.getOppositeProperty(associationEnd));
    }

    public static Object findByPredicate(ResourceSet resourceSet, Predicate pred) {
        Object modelElement = null;
        if (resourceSet == null || pred == null) {
            return modelElement;
        }
        for (Resource resource : resourceSet.getResources()) {
            Package model = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            if (model != null) {
                TreeIterator elementIterator = model.eAllContents();
                while (elementIterator.hasNext() && modelElement == null) {
                    Object object = elementIterator.next();
                    if (!pred.evaluate(object)) continue;
                    modelElement = object;
                }
            }
            if (modelElement == null) continue;
            break;
        }
        return modelElement;
    }

    public static Package findModel(UMLResource resource) {
        if (resource == null) {
            return null;
        }
        Package model = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEObject());
        if (model == null) {
            LOGGER.error((Object)("getModel was null: " + resource));
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Model found: " + model));
        }
        return model;
    }

    public static Package findModel(Element element) {
        if (element == null) {
            return null;
        }
        Model modelPackage = element.getModel();
        if (modelPackage == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)("getModel was null: " + element + " OWNER: " + element.getOwner()));
            }
            Element classifierOwner = element.getOwner();
            Element owner = null;
            while (classifierOwner != null) {
                owner = classifierOwner;
                classifierOwner = owner.getOwner();
            }
            modelPackage = (Package)owner;
        }
        return modelPackage;
    }

    public static String getPackageName(NamedElement metaObject, String separator, boolean modelName) {
        if (metaObject == null || StringUtils.isBlank((String)separator)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String usedSeparator = modelName ? "::" : separator;
        for (Namespace namespace = metaObject.getNamespace(); namespace != null; namespace = namespace.getNamespace()) {
            if (!(namespace instanceof Package) || namespace instanceof Model || namespace instanceof Profile) continue;
            if (buffer.length() != 0) {
                buffer.insert(0, usedSeparator);
            }
            buffer.insert(0, namespace.getName());
        }
        String packageName = buffer.toString();
        if (modelName && StringUtils.isNotBlank((String)packageName)) {
            packageName = StringUtils.replace((String)packageName, (String)separator, (String)"::");
        }
        return packageName;
    }

    public static String getPackageName(Element metaObject, String separator, boolean modelName) {
        if (metaObject == null || StringUtils.isBlank((String)separator)) {
            return null;
        }
        String packageName = metaObject instanceof NamedElement ? UmlUtilities.getPackageName((NamedElement)metaObject, separator, modelName) : (metaObject.getOwner() == null ? "" : UmlUtilities.getPackageName(metaObject.getOwner(), separator, modelName));
        return packageName;
    }

    public static String getFullyQualifiedName(Element metaObject, String separator, boolean modelName) {
        if (metaObject == null || StringUtils.isBlank((String)separator) || !(metaObject instanceof NamedElement)) {
            return "";
        }
        NamedElement element = (NamedElement)metaObject;
        String name = element.getName();
        String ownerName = null;
        for (Element owner = element.getOwner(); owner != null; owner = owner.getOwner()) {
            if (!(owner instanceof NamedElement) || owner instanceof Model || owner instanceof Profile) continue;
            ownerName = ((NamedElement)owner).getName();
            name = ownerName + separator + name;
        }
        return name;
    }

    public static Object findByName(ResourceSet rs, final String name) {
        if (rs == null || StringUtils.isBlank((String)name)) {
            return null;
        }
        Object modelElement = null;
        if (StringUtils.isNotBlank((String)name)) {
            modelElement = UmlUtilities.findByPredicate(rs, new Predicate(){

                public boolean evaluate(Object object) {
                    if (object instanceof NamedElement) {
                        return StringUtils.trimToEmpty((String)((NamedElement)object).getName()).equals(name);
                    }
                    return false;
                }
            });
        }
        return modelElement;
    }

    public static Object findByFullyQualifiedName(ResourceSet resourceSet, final String fullyQualifiedName, final String separator, final boolean modelName) {
        if (resourceSet == null || StringUtils.isBlank((String)fullyQualifiedName) || StringUtils.isBlank((String)separator)) {
            return null;
        }
        Object modelElement = UmlUtilities.findByPredicate(resourceSet, new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof NamedElement) {
                    NamedElement element = (NamedElement)object;
                    StringBuilder fullName = new StringBuilder(UmlUtilities.getPackageName(element, separator, modelName));
                    String name = element.getName();
                    if (StringUtils.isNotBlank((String)name)) {
                        String namespaceSeparator = "::";
                        if (!modelName) {
                            namespaceSeparator = separator;
                        }
                        fullName.append(namespaceSeparator);
                        fullName.append(name);
                    }
                    return fullName.toString().equals(fullyQualifiedName);
                }
                return false;
            }
        });
        return modelElement;
    }

    public static int parseLowerMultiplicity(ValueSpecification multValue, ClassifierFacade type, String defaultMultiplicity) {
        int value = 1;
        if (multValue == null) {
            if (type.isWrappedPrimitive()) {
                value = 0;
            } else if (!type.isPrimitive()) {
                value = StringUtils.isNotBlank((String)defaultMultiplicity) && defaultMultiplicity.charAt(0) == '0' ? 0 : 1;
            }
        } else {
            value = UmlUtilities.parseMultiplicity(multValue, Integer.parseInt(defaultMultiplicity));
        }
        return value;
    }

    public static int parseMultiplicity(ValueSpecification multValue, int defaultValue) {
        int value = defaultValue;
        if (multValue != null) {
            if (multValue instanceof LiteralInteger) {
                LiteralInteger litInt = (LiteralInteger)multValue;
                value = litInt.getValue();
            } else if (multValue instanceof LiteralUnlimitedNatural) {
                LiteralUnlimitedNatural litInt = (LiteralUnlimitedNatural)multValue;
                value = litInt.getValue();
            } else if (multValue instanceof LiteralString) {
                LiteralString litStr = (LiteralString)multValue;
                String multString = litStr.getValue();
                value = "*".equals(multString) ? -1 : Integer.parseInt(multString);
            } else {
                OpaqueExpression expression;
                EList bodies;
                String multString = multValue.toString();
                String forValue = "";
                Element element = multValue.getOwner();
                if (element instanceof Property) {
                    Property property = (Property)element;
                    forValue = " in property " + property.getQualifiedName();
                }
                if (multValue instanceof OpaqueExpression && (bodies = (expression = (OpaqueExpression)multValue).getBodies()) != null && !bodies.isEmpty()) {
                    multString = (String)bodies.get(0);
                }
                LOGGER.error((Object)("Invalid multiplicity value" + forValue + ", using default " + defaultValue + ": " + multString));
            }
        }
        return value;
    }

    public static boolean doesTagValueNameMatch(String requestedName, String tagValueName) {
        if (StringUtils.isBlank((String)requestedName) || StringUtils.isBlank((String)tagValueName)) {
            return false;
        }
        boolean result = requestedName.equals(tagValueName);
        if (!result) {
            if (requestedName.charAt(0) == '@') {
                String rsmName = requestedName.substring(1);
                result = (rsmName = rsmName.replace('.', '_')).equals(tagValueName);
                if (!result) {
                    String emfName = EMFNormalizer.getEMFName(requestedName);
                    result = emfName.equals(tagValueName);
                }
                if (!result) {
                    rsmName = '_' + StringUtils.remove((String)requestedName.substring(1), (char)'.');
                    result = rsmName.equals(tagValueName);
                }
            } else {
                String emfName = '_' + StringUtils.remove((String)requestedName, (char)'_');
                result = emfName.equals(tagValueName);
            }
        }
        return result;
    }

    private static class PropertyComparator
    implements Comparator<Property> {
        private static final long serialVersionUID = 1L;

        private PropertyComparator() {
        }

        @Override
        public int compare(Property property1, Property property2) {
            return property1.getName().compareTo(property2.getName());
        }
    }

    private static class EMFNormalizer
    extends UML2Util {
        private EMFNormalizer() {
        }

        public static String getEMFName(String name) {
            return EMFNormalizer.getValidJavaIdentifier((String)name);
        }
    }
}

