/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Filters;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.PackageFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.resource.UMLResource;

public class UMLModelAccessFacade
implements ModelAccessFacade {
    private static final Logger LOGGER = Logger.getLogger(UMLModelAccessFacade.class);
    protected Filters modelPackages = new Filters();
    private static final String MODEL_ELEMENT = "modelElement";
    private List<UMLResource> model;

    public void setModel(Object modelIn) {
        ExceptionUtils.checkNull((String)"model", (Object)modelIn);
        ExceptionUtils.checkAssignable(List.class, (String)MODEL_ELEMENT, modelIn.getClass());
        if (this.model != null) {
            this.model.clear();
        }
        this.model = new ArrayList<UMLResource>();
        for (UMLResource modelResource : (ArrayList)modelIn) {
            if (this.model.contains(modelResource)) continue;
            this.model.add(modelResource);
        }
        UmlUtilities.clearAllMetaObjectsCache();
        EntityMetafacadeUtils.clearForeignKeyConstraintNameCache();
    }

    public Object getModel() {
        return this.model;
    }

    public String getName(Object modelElement) {
        ExceptionUtils.checkNull((String)MODEL_ELEMENT, (Object)modelElement);
        ExceptionUtils.checkAssignable(ModelElementFacade.class, (String)MODEL_ELEMENT, modelElement.getClass());
        return ((ModelElementFacade)modelElement).getName();
    }

    public String getPackageName(Object modelElement) {
        String name;
        ExceptionUtils.checkNull((String)MODEL_ELEMENT, (Object)modelElement);
        ExceptionUtils.checkAssignable(ModelElementFacade.class, (String)MODEL_ELEMENT, modelElement.getClass());
        ModelElementFacade modelElementFacade = (ModelElementFacade)modelElement;
        StringBuilder packageName = new StringBuilder(modelElementFacade.getPackageName(true));
        if (modelElement instanceof PackageFacade && StringUtils.isNotBlank((String)(name = modelElementFacade.getName()))) {
            packageName.append("::");
            packageName.append(name);
        }
        return packageName.toString();
    }

    public void setPackageFilter(Filters modelPackagesIn) {
        this.modelPackages = modelPackagesIn;
    }

    public Collection<String> getStereotypeNames(Object modelElement) {
        ExceptionUtils.checkNull((String)MODEL_ELEMENT, (Object)modelElement);
        Collection<String> stereotypeNames = Collections.emptyList();
        if (modelElement instanceof Element) {
            Element element = (Element)modelElement;
            stereotypeNames = UmlUtilities.getStereotypeNames(element);
        } else if (modelElement instanceof ModelElementFacade) {
            stereotypeNames = ((ModelElementFacade)modelElement).getStereotypeNames();
        }
        return stereotypeNames;
    }

    public Collection<MetafacadeBase> findByStereotype(String name) {
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        for (UMLResource modelResource : this.model) {
            TreeIterator iterator = UmlUtilities.findModel(modelResource).eAllContents();
            while (iterator.hasNext()) {
                NamedElement element;
                EObject object = (EObject)iterator.next();
                if (!(object instanceof NamedElement) || !UmlUtilities.containsStereotype((Element)(element = (NamedElement)object), name)) continue;
                elements.add(element);
            }
        }
        int elementSize = elements.size();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Finding stereotype <<" + name + ">> in elements " + elements.size()));
        }
        this.filterElements(elements);
        if (LOGGER.isDebugEnabled() && elements.size() < elementSize) {
            LOGGER.debug((Object)("Filtered out " + (elementSize - elements.size()) + " elements"));
        }
        return MetafacadeFactory.getInstance().createMetafacades(elements);
    }

    public Collection<MetafacadeBase> getModelElements() {
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        for (UMLResource modelResource : this.model) {
            TreeIterator iterator = UmlUtilities.findModel(modelResource).eAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!(object instanceof NamedElement)) continue;
                elements.add((NamedElement)object);
            }
        }
        this.filterElements(elements);
        CollectionUtils.transform(elements, (Transformer)UmlUtilities.ELEMENT_TRANSFORMER);
        Collection metafacades = elements.isEmpty() ? new ArrayList() : MetafacadeFactory.getInstance().createMetafacades(elements);
        return metafacades;
    }

    private void filterElements(Collection<NamedElement> metafacades) {
        if (this.modelPackages != null && !this.modelPackages.isEmpty()) {
            CollectionUtils.filter(metafacades, (Predicate)new Predicate(){

                public boolean evaluate(Object element) {
                    boolean valid = false;
                    if (element instanceof NamedElement) {
                        String name;
                        NamedElement modelElement = (NamedElement)element;
                        StringBuilder packageName = new StringBuilder(UmlUtilities.getPackageName(modelElement, "::", true));
                        if (element instanceof Package && StringUtils.isNotBlank((String)(name = modelElement.getName()))) {
                            packageName.append("::");
                            packageName.append(name);
                        }
                        valid = UMLModelAccessFacade.this.modelPackages.isApply(packageName.toString());
                    }
                    return valid;
                }
            });
        }
    }
}

