/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.andromda.metafacades.emf.uml22.ServiceLogic;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.Destination;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.Role;
import org.andromda.metafacades.uml.Service;
import org.andromda.metafacades.uml.ServiceOperation;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class ServiceLogicImpl
extends ServiceLogic {
    private static final long serialVersionUID = 34L;

    public ServiceLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Collection<DependencyFacade> handleGetServiceReferences() {
        return new FilteredCollection(this.getSourceDependencies()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                ModelElementFacade targetElement = ((DependencyFacade)object).getTargetElement();
                return targetElement != null && Service.class.isAssignableFrom(targetElement.getClass());
            }
        };
    }

    @Override
    protected Collection<DependencyFacade> handleGetEntityReferences() {
        return new FilteredCollection(this.getSourceDependencies()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                ModelElementFacade targetElement = ((DependencyFacade)object).getTargetElement();
                return targetElement != null && Entity.class.isAssignableFrom(targetElement.getClass());
            }
        };
    }

    @Override
    public Collection<DependencyFacade> handleGetAllServiceReferences() {
        final ArrayList<DependencyFacade> result = new ArrayList<DependencyFacade>();
        result.addAll(this.getServiceReferences());
        CollectionUtils.forAllDo(this.getAllGeneralizations(), (Closure)new Closure(){

            public void execute(Object object) {
                Service service = (Service)object;
                result.addAll(service.getServiceReferences());
            }
        });
        return result;
    }

    @Override
    protected Collection<Role> handleGetRoles() {
        ArrayList<DependencyFacade> roles = new ArrayList<DependencyFacade>(this.getTargetDependencies());
        CollectionUtils.filter(roles, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                DependencyFacade dependency = (DependencyFacade)object;
                return dependency != null && dependency.getSourceElement() instanceof Role;
            }
        });
        CollectionUtils.transform(roles, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((DependencyFacade)object).getSourceElement();
            }
        });
        final LinkedHashSet<DependencyFacade> allRoles = new LinkedHashSet<DependencyFacade>(roles);
        CollectionUtils.forAllDo(roles, (Closure)new Closure(){

            public void execute(Object object) {
                allRoles.addAll(((Role)object).getAllSpecializations());
            }
        });
        return allRoles;
    }

    @Override
    protected Collection<Role> handleGetAllRoles() {
        final LinkedHashSet<Role> roles = new LinkedHashSet<Role>(this.getRoles());
        CollectionUtils.forAllDo(this.getOperations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof ServiceOperation) {
                    roles.addAll(((ServiceOperation)object).getRoles());
                }
            }
        });
        return roles;
    }

    @Override
    protected Collection<Destination> handleGetMessagingDestinations() {
        final LinkedHashSet<Destination> destinations = new LinkedHashSet<Destination>();
        CollectionUtils.forAllDo(this.getOperations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof ServiceOperation) {
                    ServiceOperation operation = (ServiceOperation)object;
                    if (operation.isIncomingMessageOperation()) {
                        destinations.add(operation.getIncomingDestination());
                    } else if (operation.isOutgoingMessageOperation()) {
                        destinations.add(operation.getOutgoingDestination());
                    }
                }
            }
        });
        return destinations;
    }

    @Override
    protected Collection<DependencyFacade> handleGetAllEntityReferences() {
        final LinkedHashSet<DependencyFacade> result = new LinkedHashSet<DependencyFacade>();
        result.addAll(this.getEntityReferences());
        CollectionUtils.forAllDo(this.getAllGeneralizations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Service) {
                    Service service = (Service)object;
                    result.addAll(service.getEntityReferences());
                }
            }
        });
        return result;
    }

    @Override
    protected Collection<Destination> handleGetAllMessagingDestinations() {
        final LinkedHashSet<Destination> result = new LinkedHashSet<Destination>();
        result.addAll(this.getMessagingDestinations());
        CollectionUtils.forAllDo(this.getAllGeneralizations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Service) {
                    Service service = (Service)object;
                    result.addAll(service.getMessagingDestinations());
                }
            }
        });
        return result;
    }
}

