/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import org.andromda.metafacades.emf.uml22.ParameterFacadeLogic;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLMetafacadeUtils;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterEffectKind;
import org.eclipse.uml2.uml.Type;

public class ParameterFacadeLogicImpl
extends ParameterFacadeLogic {
    private static final long serialVersionUID = 34L;

    public ParameterFacadeLogicImpl(Parameter metaObjectIn, String context) {
        super(metaObjectIn, context);
    }

    @Override
    protected String handleGetDefaultValue() {
        String defaultValue = this.metaObject.getDefault();
        if (StringUtils.isNotBlank((String)defaultValue) && !this.handleIsMany()) {
            String typeName = this.metaObject.getType().getName();
            if ("String".equals(typeName) && defaultValue.indexOf(34) < 0) {
                defaultValue = '\"' + defaultValue + '\"';
            } else if (("char".equals(typeName) || "Character".equals(typeName)) && defaultValue.indexOf(39) < 0) {
                defaultValue = "'" + defaultValue.charAt(0) + '\'';
            }
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        return defaultValue;
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("parameterNameMask"));
        String name = NameMasker.mask((String)super.handleGetName(), (String)nameMask);
        if (this.handleIsMany() && this.isPluralizeParameterNames()) {
            name = StringUtilsHelper.pluralize((String)name);
        }
        return name;
    }

    private boolean isPluralizeParameterNames() {
        Object value = this.getConfiguredProperty("pluralizeParameterNames");
        return value != null && Boolean.valueOf(String.valueOf(value)) != false;
    }

    @Override
    protected boolean handleIsMany() {
        return this.getUpper() > 1 || this.getUpper() == -1 || this.getType() != null && (this.getType().isArrayType() || this.getType().isCollectionType());
    }

    @Override
    public String handleGetEffect() {
        ParameterEffectKind effect = this.metaObject.getEffect();
        if (effect == null) {
            return "NONE";
        }
        return effect.getLiteral();
    }

    @Override
    public boolean handleIsException() {
        return this.metaObject.isException();
    }

    @Override
    protected boolean handleIsOrdered() {
        return this.metaObject.isOrdered();
    }

    @Override
    protected boolean handleIsUnique() {
        return this.metaObject.isUnique();
    }

    @Override
    protected boolean handleIsReturn() {
        return this.metaObject.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL);
    }

    @Override
    protected boolean handleIsRequired() {
        return !this.hasStereotype(UMLProfile.STEREOTYPE_NULLABLE) && this.getLower() >= 1;
    }

    @Override
    protected String handleGetGetterName() {
        return UMLMetafacadeUtils.getGetterPrefix((ClassifierFacade)this.getType(), (int)this.getLower()) + StringUtils.capitalize((String)this.handleGetName());
    }

    @Override
    protected String handleGetSetterName() {
        return "set" + StringUtils.capitalize((String)this.handleGetName());
    }

    @Override
    protected boolean handleIsReadable() {
        return this.isInParameter() || this.isInoutParameter();
    }

    @Override
    protected boolean handleIsWritable() {
        return this.isOutParameter() || this.isInoutParameter();
    }

    @Override
    protected boolean handleIsDefaultValuePresent() {
        return StringUtils.isNotBlank((String)this.getDefaultValue());
    }

    @Override
    protected boolean handleIsInParameter() {
        return this.metaObject.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL);
    }

    @Override
    protected boolean handleIsOutParameter() {
        return this.metaObject.getDirection().equals((Object)ParameterDirectionKind.OUT_LITERAL);
    }

    @Override
    protected boolean handleIsInoutParameter() {
        return this.metaObject.getDirection().equals((Object)ParameterDirectionKind.INOUT_LITERAL);
    }

    protected Operation handleGetOperation() {
        Element owner = this.metaObject.getOwner();
        if (owner instanceof Operation) {
            return (Operation)owner;
        }
        return null;
    }

    protected Activity handleGetEvent() {
        Element owner = this.metaObject.getOwner();
        if (owner instanceof Activity) {
            return (Activity)owner;
        }
        return null;
    }

    protected Type handleGetType() {
        return this.metaObject.getType();
    }

    private String getTemplatingType() {
        String type = null;
        if (BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getConfiguredProperty("enableTemplating"))) && this.getType() != null) {
            type = this.getType().getFullyQualifiedName();
            if (this.getType().isPrimitive()) {
                type = this.getType().getWrapperName();
            }
        }
        return type;
    }

    @Override
    protected String handleGetGetterSetterTypeName() {
        String name = null;
        if (this.getUpper() > 1 || this.getUpper() == -1) {
            TypeMappings mappings = this.getLanguageMappings();
            name = this.handleIsUnique() ? (this.handleIsOrdered() ? mappings.getTo(UMLProfile.ORDERED_SET_TYPE_NAME) : mappings.getTo(UMLProfile.SET_TYPE_NAME)) : (this.handleIsOrdered() ? mappings.getTo(UMLProfile.LIST_TYPE_NAME) : mappings.getTo(UMLProfile.COLLECTION_TYPE_NAME));
            String type = this.getTemplatingType();
            if (type != null) {
                name = name + '<' + type + '>';
            }
        }
        if (name == null && this.getType() != null) {
            name = this.getType().getFullyQualifiedName();
            if (this.getType().isBooleanType()) {
                if (this.getType().isPrimitive() && this.getLower() < 1) {
                    name = StringUtils.capitalize((String)name);
                } else if (!this.getType().isPrimitive() && this.getLower() > 0) {
                    name = StringUtils.uncapitalize((String)name);
                }
            }
        }
        return name;
    }

    @Override
    protected String handleGetGetterSetterTypeNameImpl() {
        String nameImpl = null;
        if (this.getUpper() > 1 || this.getUpper() == -1) {
            TypeMappings mappings = this.getLanguageMappings();
            nameImpl = this.handleIsUnique() ? (this.handleIsOrdered() ? mappings.getTo(UMLProfile.ORDERED_SET_IMPL_TYPE_NAME) : mappings.getTo(UMLProfile.SET_IMPL_TYPE_NAME)) : (this.handleIsOrdered() ? mappings.getTo(UMLProfile.LIST_IMPL_TYPE_NAME) : mappings.getTo(UMLProfile.COLLECTION_IMPL_TYPE_NAME));
            String type = this.getTemplatingType();
            if (type != null) {
                nameImpl = nameImpl + '<' + type + '>';
            }
        }
        if (nameImpl == null) {
            nameImpl = this.getGetterSetterTypeName();
        }
        return nameImpl;
    }

    public Object getValidationOwner() {
        OperationFacade owner = this.getOperation();
        if (owner == null) {
            owner = this.getEvent();
        }
        return owner;
    }

    @Override
    protected int handleGetUpper() {
        return UmlUtilities.parseMultiplicity(this.metaObject.getUpperValue(), 1);
    }

    private int getDefaultMultiplicity() {
        Object value = this.getConfiguredProperty("defaultMultiplicity");
        return value != null ? Integer.valueOf(String.valueOf(value)) : 1;
    }

    @Override
    protected int handleGetLower() {
        return UmlUtilities.parseLowerMultiplicity(this.metaObject.getLowerValue(), this.getType(), ObjectUtils.toString((Object)this.getConfiguredProperty("defaultMultiplicity")));
    }
}

