/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.metafacades.emf.uml22.ModelFacadeLogic;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.metafacades.uml.ActionStateFacade;
import org.andromda.metafacades.uml.ActivityGraphFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.FinalStateFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml.UseCaseFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.resource.UMLResource;

public class ModelFacadeLogicImpl
extends ModelFacadeLogic {
    private static final long serialVersionUID = -7114972076481221838L;
    private static final Logger LOGGER = Logger.getLogger(ModelFacadeLogicImpl.class);

    public ModelFacadeLogicImpl(UMLResource metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected UseCaseFacade handleFindUseCaseWithTaggedValueOrHyperlink(String tag, String value) {
        UseCaseFacade useCaseWithTaggedValue = null;
        Collection<UseCaseFacade> useCases = this.getAllUseCases();
        Iterator<UseCaseFacade> useCaseIterator = useCases.iterator();
        while (useCaseIterator.hasNext() && useCaseWithTaggedValue == null) {
            UseCaseFacade useCase = useCaseIterator.next();
            if (useCase.findTaggedValue(tag, true) == null) {
                Object taggedValue = useCase.findTaggedValue(UMLProfile.TAGGEDVALUE_MODEL_HYPERLINK);
                if (taggedValue == null) continue;
                useCaseWithTaggedValue = useCase;
                continue;
            }
            useCaseWithTaggedValue = useCase;
        }
        return useCaseWithTaggedValue;
    }

    @Override
    protected ClassifierFacade handleFindClassWithTaggedValueOrHyperlink(String tag, String value) {
        ClassifierFacade classWithTaggedValue = null;
        Collection<ClassifierFacade> classes = this.getAllClasses();
        Iterator<ClassifierFacade> classIterator = classes.iterator();
        while (classIterator.hasNext() && classWithTaggedValue == null) {
            ClassifierFacade clazz = classIterator.next();
            if (clazz.findTaggedValue(tag, true) == null) {
                Object taggedValue = clazz.findTaggedValue(UMLProfile.TAGGEDVALUE_MODEL_HYPERLINK);
                if (taggedValue == null) continue;
                classWithTaggedValue = clazz;
                continue;
            }
            classWithTaggedValue = clazz;
        }
        return classWithTaggedValue;
    }

    @Override
    protected ActivityGraphFacade handleFindActivityGraphByName(String name) {
        return this.findActivityGraphByNameAndStereotype(name, null);
    }

    @Override
    protected ActivityGraphFacade handleFindActivityGraphByNameAndStereotype(String name, String stereotypeName) {
        ActivityGraphFacade agfFound = null;
        List<? extends EObject> agfCollection = UmlUtilities.getAllMetaObjectsInstanceOf(StateMachine.class, UmlUtilities.getModels());
        Iterator<? extends EObject> it = agfCollection.iterator();
        while (it.hasNext() && agfFound == null) {
            ActivityGraphFacade agf = (ActivityGraphFacade)this.shieldedElement(it.next());
            if (!agf.getName().equals(name) || stereotypeName != null && !agf.hasStereotype(stereotypeName)) continue;
            agfFound = agf;
        }
        return agfFound;
    }

    @Override
    protected UseCaseFacade handleFindUseCaseByName(String name) {
        return this.findUseCaseWithNameAndStereotype(name, null);
    }

    @Override
    protected UseCaseFacade handleFindUseCaseWithNameAndStereotype(String name, String stereotypeName) {
        UseCaseFacade ucfFound = null;
        Collection<UseCaseFacade> ucCollections = this.getAllUseCases();
        Iterator<UseCaseFacade> it = ucCollections.iterator();
        while (it.hasNext() && ucfFound == null) {
            UseCaseFacade ucf = it.next();
            if (!ucf.getName().equals(name) || stereotypeName != null && !ucf.hasStereotype(stereotypeName)) continue;
            ucfFound = ucf;
        }
        return ucfFound;
    }

    @Override
    protected Collection<FinalStateFacade> handleFindFinalStatesWithNameOrHyperlink(final UseCaseFacade useCase) {
        List<? extends EObject> fsCollection = UmlUtilities.getAllMetaObjectsInstanceOf(FinalState.class, UmlUtilities.getModels());
        CollectionUtils.filter(fsCollection, (Predicate)new Predicate(){

            public boolean evaluate(Object candidate) {
                FinalState finalState = (FinalState)candidate;
                return finalState != null && StringUtils.isNotBlank((String)finalState.getName()) && finalState.getName().equals(useCase.getName());
            }
        });
        return this.shieldedElements(fsCollection);
    }

    @Override
    protected Collection<ActionStateFacade> handleGetAllActionStatesWithStereotype(final ActivityGraphFacade activityGraph, final String stereotypeName) {
        Collection<ActionStateFacade> asCollection = this.getAllActionStates();
        CollectionUtils.filter(asCollection, (Predicate)new Predicate(){

            public boolean evaluate(Object candidate) {
                ActionStateFacade asf = (ActionStateFacade)candidate;
                return asf.hasStereotype(stereotypeName) && asf.getPartition().getActivityGraph().equals(activityGraph);
            }
        });
        return asCollection;
    }

    protected Package handleGetRootPackage() {
        Package model = UmlUtilities.findModel(this.metaObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Root package " + model));
        }
        return model;
    }

    @Override
    protected List<Actor> handleGetAllActors() {
        return UmlUtilities.getAllMetaObjectsInstanceOf(Actor.class, UmlUtilities.getModels());
    }

    @Override
    protected List<UseCase> handleGetAllUseCases() {
        return UmlUtilities.getAllMetaObjectsInstanceOf(UseCase.class, UmlUtilities.getModels());
    }

    @Override
    protected Collection<ActionStateFacade> handleGetAllActionStates() {
        List<? extends EObject> allActionStates = UmlUtilities.getAllMetaObjectsInstanceOf(State.class, UmlUtilities.getModels());
        CollectionUtils.filter(allActionStates, (Predicate)new Predicate(){

            public boolean evaluate(Object candidate) {
                return !(candidate instanceof FinalState);
            }
        });
        return allActionStates;
    }

    @Override
    protected Collection handleGetAllObjectFlowStates() {
        return Collections.emptyList();
    }

    @Override
    protected List<ClassifierFacade> handleGetAllClasses() {
        ArrayList<ClassifierFacade> facades = new ArrayList<ClassifierFacade>();
        List<? extends EObject> classes = UmlUtilities.getAllMetaObjectsInstanceOf(Class.class, UmlUtilities.getModels());
        for (Class clazz : classes) {
            MetafacadeBase metafacade = this.shieldedElement(clazz);
            if (!(metafacade instanceof ClassifierFacade)) continue;
            facades.add((ClassifierFacade)metafacade);
        }
        return facades;
    }

    @Override
    protected List<Transition> handleGetAllTransitions() {
        return UmlUtilities.getAllMetaObjectsInstanceOf(Transition.class, UmlUtilities.getModels());
    }
}

