/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.Collection;
import org.andromda.metafacades.emf.uml22.EnumerationFacadeLogic;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;

public class EnumerationFacadeLogicImpl
extends EnumerationFacadeLogic {
    private static final long serialVersionUID = 3610615632915162579L;

    public EnumerationFacadeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("enumerationNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected Collection<? extends ModelElementFacade> handleGetLiterals() {
        Object literals = this.metaObject instanceof Enumeration ? ((Enumeration)this.metaObject).getOwnedLiterals() : CollectionUtils.collect(this.getAttributes(), (Transformer)UmlUtilities.ELEMENT_TRANSFORMER);
        CollectionUtils.filter((Collection)literals, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof EnumerationLiteral || object instanceof AttributeFacade && !((AttributeFacade)object).isEnumerationMember();
            }
        });
        return literals;
    }

    @Override
    protected Collection<AttributeFacade> handleGetMemberVariables() {
        Object variables = this.metaObject instanceof Enumeration ? ((Enumeration)this.metaObject).getOwnedAttributes() : CollectionUtils.collect(this.getAttributes(), (Transformer)UmlUtilities.ELEMENT_TRANSFORMER);
        CollectionUtils.filter((Collection)variables, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof AttributeFacade && ((AttributeFacade)object).isEnumerationMember();
            }
        });
        return variables;
    }

    @Override
    protected String handleGetFromOperationSignature() {
        StringBuilder signature = new StringBuilder(this.getFromOperationName());
        ClassifierFacade type = this.getLiteralType();
        if (type != null) {
            signature.append('(');
            signature.append(type.getFullyQualifiedName());
            signature.append(" value)");
        }
        return signature.toString();
    }

    @Override
    protected boolean handleIsTypeSafe() {
        return BooleanUtils.toBoolean((String)String.valueOf(this.getConfiguredProperty("typeSafeEnumsEnabled")));
    }

    @Override
    protected String handleGetFromOperationName() {
        StringBuilder name = new StringBuilder("from");
        ClassifierFacade type = this.getLiteralType();
        if (type != null) {
            name.append(StringUtils.capitalize((String)type.getName()));
        }
        return name.toString();
    }

    @Override
    protected Object handleGetLiteralType() {
        Object type = null;
        Collection<AttributeFacade> literals = this.getLiterals();
        if (literals != null && !literals.isEmpty()) {
            ModelElementFacade literal = (ModelElementFacade)literals.iterator().next();
            if (literal instanceof AttributeFacade) {
                type = ((AttributeFacade)literal).getType();
            } else {
                type = UmlUtilities.findByFullyQualifiedName(((NamedElement)this.metaObject).eResource().getResourceSet(), "datatype::String", "::", true);
                if (type == null) {
                    type = UmlUtilities.findByFullyQualifiedName(((NamedElement)this.metaObject).eResource().getResourceSet(), "UML2::String", "::", true);
                }
                if (type == null) {
                    type = UmlUtilities.findByFullyQualifiedName(((NamedElement)this.metaObject).eResource().getResourceSet(), "PrimitiveTypes::String", "::", true);
                }
                if (type == null) {
                    type = UmlUtilities.findByFullyQualifiedName(((NamedElement)this.metaObject).eResource().getResourceSet(), "UMLPrimitiveTypes::String", "::", true);
                }
                if (type == null) {
                    type = UmlUtilities.findByFullyQualifiedName(((NamedElement)this.metaObject).eResource().getResourceSet(), "UMLTypes::String", "::", true);
                }
                if (type == null) {
                    type = UmlUtilities.findByFullyQualifiedName(((NamedElement)this.metaObject).eResource().getResourceSet(), "String", "::", true);
                }
            }
        }
        return type;
    }
}

