/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import org.andromda.metafacades.emf.uml22.EntityAttributeLogic;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.EnumerationFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityAttributeLogicImpl
extends EntityAttributeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger LOGGER = Logger.getLogger(EntityAttributeLogicImpl.class);

    public EntityAttributeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("entityPropertyNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected String handleGetColumnLength() {
        return (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN_LENGTH);
    }

    @Override
    protected String handleGetColumnName() {
        Short maxSqlNameLength = Short.valueOf((String)this.getConfiguredProperty("maxSqlNameLength"));
        String columnNamePrefix = this.isConfiguredProperty("columnNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("columnNamePrefix")) : null;
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue((String)columnNamePrefix, (ModelElementFacade)this, (String)UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN, (Short)maxSqlNameLength, (Object)this.getConfiguredProperty("sqlNameSeparator"));
    }

    @Override
    protected TypeMappings handleGetJdbcMappings() {
        return this.getMappingsProperty("jdbcMappingsUri");
    }

    @Override
    protected String handleGetJdbcType() {
        ClassifierFacade type;
        String value = null;
        if (this.getJdbcMappings() != null && (type = this.getType()) != null) {
            String typeName = type.getFullyQualifiedName(true);
            value = this.getJdbcMappings().getTo(typeName);
        }
        return value;
    }

    @Override
    protected TypeMappings handleGetSqlMappings() {
        return this.getMappingsProperty("sqlMappingsUri");
    }

    @Override
    protected String handleGetSqlType() {
        ClassifierFacade type;
        String value = null;
        if (this.getSqlMappings() != null && (type = this.getType()) != null) {
            ClassifierFacade literalType;
            String typeName = type.getFullyQualifiedName(true);
            if (type.isEnumeration() && (literalType = ((EnumerationFacade)type).getLiteralType()) != null) {
                typeName = literalType.getFullyQualifiedName(true);
            }
            value = this.getSqlMappings().getTo(typeName);
            String columnLength = this.getColumnLength();
            if (StringUtils.isNotBlank((String)columnLength)) {
                value = EntityMetafacadeUtils.constructSqlTypeName((String)value, (String)columnLength);
            }
        }
        return value;
    }

    @Override
    protected boolean handleIsIdentifier() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_IDENTIFIER);
    }

    @Override
    protected String handleGetColumnIndex() {
        String index = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN_INDEX);
        return index == null ? null : StringUtils.trimToEmpty((String)index);
    }

    private TypeMappings getMappingsProperty(String propertyName) {
        Object property = this.getConfiguredProperty(propertyName);
        TypeMappings mappings = null;
        if (property instanceof String) {
            String uri = (String)property;
            try {
                mappings = TypeMappings.getInstance((String)uri);
                this.setProperty(propertyName, mappings);
            }
            catch (Throwable th) {
                String errMsg = "Error getting '" + propertyName + "' --> '" + uri + '\'';
                LOGGER.error((Object)errMsg, th);
            }
        } else {
            mappings = (TypeMappings)property;
        }
        return mappings;
    }

    @Override
    protected boolean handleIsTransient() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_TRANSIENT);
    }

    @Override
    protected String handleGetUniqueGroup() {
        String group = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN_UNIQUE_GROUP);
        return group == null ? null : StringUtils.trimToEmpty((String)group);
    }
}

