/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.cartridges.hibernate.metafacades.HibernateFinderMethodLogic;
import org.andromda.cartridges.hibernate.metafacades.HibernateMetafacadeUtils;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.apache.commons.lang.StringUtils;

public class HibernateFinderMethodLogicImpl
extends HibernateFinderMethodLogic {
    private static final long serialVersionUID = 34L;
    private String translatedQuery = null;
    private static final String USE_NAMED_PARAMETERS = "hibernateQueryUseNamedParameters";
    private static final String HIBERNATE_USE_QUERY_CACHE = "hibernateUseQueryCache";

    public HibernateFinderMethodLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetQuery() {
        Object value;
        String queryString = this.getTranslatedQuery();
        if (StringUtils.isEmpty((String)queryString) && (queryString = (String)(value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_QUERY))) != null) {
            queryString = queryString.replaceAll("[$\\s]+", " ");
        }
        if (StringUtils.isEmpty((String)queryString)) {
            String variableName = StringUtils.uncapitalize((String)this.getOwner().getName());
            queryString = "from " + this.getOwner().getFullyQualifiedName() + " as " + variableName;
            Collection<ParameterFacade> arguments = this.getArguments();
            if (arguments != null && !arguments.isEmpty()) {
                queryString = queryString + " where";
                Iterator<ParameterFacade> argumentIt = arguments.iterator();
                while (argumentIt.hasNext()) {
                    ParameterFacade argument = argumentIt.next();
                    String parameter = "?";
                    if (this.isUseNamedParameters()) {
                        parameter = ':' + argument.getName();
                    }
                    queryString = queryString + ' ' + variableName + '.' + argument.getName() + " = " + parameter;
                    if (!argumentIt.hasNext()) continue;
                    queryString = queryString + " and";
                }
            }
        }
        return queryString;
    }

    private String getTranslatedQuery() {
        if (StringUtils.isBlank((String)this.translatedQuery)) {
            this.translatedQuery = super.getQuery("query.Hibernate-QL");
        }
        return this.translatedQuery;
    }

    @Override
    protected boolean handleIsUseNamedParameters() {
        boolean useNamedParameters = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(USE_NAMED_PARAMETERS))) != false || StringUtils.isNotBlank((String)this.getTranslatedQuery());
        return HibernateMetafacadeUtils.getUseNamedParameters((OperationFacade)this, useNamedParameters);
    }

    @Override
    protected boolean handleIsUseQueryCache() {
        boolean useQueryCache = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(HIBERNATE_USE_QUERY_CACHE)));
        if (useQueryCache) {
            useQueryCache = Boolean.valueOf(String.valueOf(this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_USE_QUERY_CACHE)));
        }
        return useQueryCache;
    }
}

