/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.FileLockList;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.locking.OpLockDetails;

public abstract class FileState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long NoTimeout = -1L;
    public static final long DefTimeout = 120000L;
    public static final long RenameTimeout = 60000L;
    public static final long DeleteTimeout = 15000L;
    public static final int UnknownFileId = -1;
    public static final int FILE_LOADWAIT = 0;
    public static final int FILE_LOADING = 1;
    public static final int FILE_AVAILABLE = 2;
    public static final int FILE_UPDATED = 3;
    public static final int FILE_SAVEWAIT = 4;
    public static final int FILE_SAVING = 5;
    public static final int FILE_SAVED = 6;
    public static final int FILE_DELETED = 7;
    public static final int FILE_RENAMED = 8;
    public static final int FILE_DELETEONCLOSE = 9;
    private static final String[] _fileStates = new String[]{"LoadWait", "Loading", "Available", "Updated", "SaveWait", "Saving", "Saved", "Deleted", "Renamed", "DeleteOnClose"};
    public static final String FileInformation = "FileInfo";
    public static final String StreamsList = "StreamsList";
    public static final int ReasonNone = 0;
    public static final int ReasonFileCreated = 1;
    public static final int ReasonFolderCreated = 2;
    public static final int ReasonFileDeleted = 3;
    public static final int ReasonFolderDeleted = 4;
    private String m_path;
    private long m_tmo;
    private int m_fileStatus;
    private int m_openCount;
    private int m_sharedAccess = 7;
    private int m_pid = -1;
    private FileLockList m_lockList;
    private OpLockDetails m_oplock;
    private long m_retainUntil = -1L;
    private long m_accessDate;
    private long m_modifyDate;
    private long m_changeDate;
    private long m_fileSize = -1L;
    private long m_allocSize;

    public FileState() {
    }

    public FileState(String fname, boolean caseSensitive) {
        this.setPath(fname, caseSensitive);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.m_fileStatus = -1;
    }

    public FileState(String fname, int status, boolean caseSensitive) {
        this.setPath(fname, caseSensitive);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.m_fileStatus = status;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final boolean fileExists() {
        return this.m_fileStatus == 1 || this.m_fileStatus == 2;
    }

    public final int getFileStatus() {
        return this.m_fileStatus;
    }

    public final boolean isDirectory() {
        return this.m_fileStatus == 2;
    }

    public int getOpenCount() {
        return this.m_openCount;
    }

    public abstract int getFileId();

    public final int getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public abstract int getDataStatus();

    public final boolean hasActiveLocks() {
        return this.m_lockList != null && this.m_lockList.numberOfLocks() > 0;
    }

    public final FileLockList getLockList() {
        return this.m_lockList;
    }

    public final boolean isPermanentState() {
        return this.m_tmo == -1L;
    }

    public final boolean hasActiveRetentionPeriod() {
        if (this.m_retainUntil == -1L) {
            return false;
        }
        return System.currentTimeMillis() < this.m_retainUntil;
    }

    public final long getRetentionExpiryDateTime() {
        return this.m_retainUntil;
    }

    public final boolean exists() {
        return this.m_fileStatus == 1 || this.m_fileStatus == 2;
    }

    public final boolean allowsOpen(FileOpenParams params) {
        if (this.getOpenCount() == 0) {
            return true;
        }
        if (this.getSharedAccess() == 3 && params.getAccessMode() == 3) {
            return true;
        }
        if ((this.getSharedAccess() & 1) != 0 && params.isReadOnlyAccess()) {
            return true;
        }
        return (this.getSharedAccess() & 2) != 0 && params.isWriteOnlyAccess();
    }

    public synchronized int incrementOpenCount() {
        return ++this.m_openCount;
    }

    public synchronized int decrementOpenCount() {
        if (this.m_openCount > 0) {
            --this.m_openCount;
        }
        return this.m_openCount;
    }

    public final boolean hasExpired(long curTime) {
        if (this.m_tmo == -1L) {
            return false;
        }
        return curTime > this.m_tmo;
    }

    public final long getSecondsToExpire(long curTime) {
        if (this.m_tmo == -1L) {
            return -1L;
        }
        return (this.m_tmo - curTime) / 1000L;
    }

    public final String getStatusAsString() {
        int dataSts = this.getDataStatus();
        if (dataSts >= 0 && dataSts < _fileStates.length) {
            return _fileStates[dataSts];
        }
        return "Unknown";
    }

    public void setFileStatus(int status) {
        this.setFileStatus(status, 0);
    }

    public void setFileStatus(int status, int reason) {
        this.m_fileStatus = status;
    }

    public abstract void setFileId(int var1);

    public void setExpiryTime(long expire) {
        this.m_tmo = expire;
    }

    public void setRetentionExpiryDateTime(long expires) {
        this.m_retainUntil = expires;
    }

    public void setSharedAccess(int mode) {
        if (this.getOpenCount() == 0) {
            this.m_sharedAccess = mode;
        }
    }

    public abstract void setDataStatus(int var1);

    public final void addAttribute(String name, Object attr) {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(true);
        if (stateAttrs != null) {
            stateAttrs.put(name, attr);
        }
    }

    public final Object findAttribute(String name) {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(true);
        Object attrObj = null;
        if (stateAttrs != null) {
            attrObj = stateAttrs.get(name);
        }
        return attrObj;
    }

    public final int numberOfAttributes() {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(false);
        if (stateAttrs != null) {
            return stateAttrs.size();
        }
        return 0;
    }

    public final Object removeAttribute(String name) {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(true);
        Object attrObj = null;
        if (stateAttrs != null) {
            attrObj = stateAttrs.remove(name);
        }
        return attrObj;
    }

    public final void removeAllAttributes() {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(false);
        if (stateAttrs != null) {
            stateAttrs.clear();
        }
    }

    protected abstract HashMap<String, Object> getAttributeMap(boolean var1);

    public final void setPath(String path, boolean caseSensitive) {
        this.m_path = FileState.normalizePath(path, caseSensitive);
    }

    public final void setPathInternal(String path) {
        this.m_path = path;
    }

    public void setProcessId(int pid) {
        if (this.getOpenCount() == 0) {
            this.m_pid = pid;
        }
    }

    public final int numberOfLocks() {
        if (this.m_lockList != null) {
            return this.m_lockList.numberOfLocks();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(FileLock lock) throws LockConflictException {
        Serializable serializable;
        if (this.m_lockList == null) {
            serializable = this;
            synchronized (serializable) {
                if (this.m_lockList == null) {
                    this.m_lockList = new FileLockList();
                }
            }
        }
        serializable = this.m_lockList;
        synchronized (serializable) {
            if (!this.m_lockList.allowsLock(lock)) {
                throw new LockConflictException();
            }
            this.m_lockList.addLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(FileLock lock) throws NotLockedException {
        if (this.m_lockList == null) {
            throw new NotLockedException();
        }
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            if (this.m_lockList.removeLock(lock) == null) {
                throw new NotLockedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canReadFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean readOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            readOK = this.m_lockList.canReadFile(offset, len, pid);
        }
        return readOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWriteFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean writeOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            writeOK = this.m_lockList.canWriteFile(offset, len, pid);
        }
        return writeOK;
    }

    public boolean hasOpLock() {
        return this.m_oplock != null;
    }

    public OpLockDetails getOpLock() {
        return this.m_oplock;
    }

    public synchronized void setOpLock(OpLockDetails oplock) throws ExistingOpLockException {
        if (this.m_oplock != null) {
            throw new ExistingOpLockException();
        }
        this.m_oplock = oplock;
    }

    public synchronized void clearOpLock() {
        this.m_oplock = null;
    }

    public boolean hasPseudoFiles() {
        PseudoFileList pseudoList = this.getPseudoFileList(false);
        if (pseudoList != null) {
            return pseudoList.numberOfFiles() > 0;
        }
        return false;
    }

    public PseudoFileList getPseudoFileList() {
        return this.getPseudoFileList(false);
    }

    protected abstract PseudoFileList getPseudoFileList(boolean var1);

    public final void addPseudoFile(PseudoFile pfile) {
        PseudoFileList pseudoList = this.getPseudoFileList(true);
        if (pseudoList != null) {
            pseudoList.addFile(pfile);
        }
    }

    public final boolean hasAccessDateTime() {
        return this.m_accessDate != 0L;
    }

    public final long getAccessDateTime() {
        return this.m_accessDate;
    }

    public void updateAccessDateTime() {
        this.m_accessDate = System.currentTimeMillis();
    }

    public final boolean hasChangeDateTime() {
        return this.m_changeDate != 0L;
    }

    public final long getChangeDateTime() {
        return this.m_changeDate;
    }

    public void updateChangeDateTime() {
        this.updateChangeDateTime(System.currentTimeMillis());
    }

    public void updateChangeDateTime(long changeTime) {
        this.m_changeDate = changeTime;
    }

    public final boolean hasModifyDateTime() {
        return this.m_modifyDate != 0L;
    }

    public final long getModifyDateTime() {
        return this.m_modifyDate;
    }

    public void updateModifyDateTime() {
        long timeNow = System.currentTimeMillis();
        this.updateModifyDateTime(timeNow);
        this.m_accessDate = timeNow;
    }

    public void updateModifyDateTime(long modTime) {
        this.m_modifyDate = modTime;
    }

    public final boolean hasFilesystemObject() {
        return this.getFilesystemObject() != null;
    }

    public abstract Object getFilesystemObject();

    public abstract void setFilesystemObject(Object var1);

    public abstract boolean isCopyState();

    public final boolean hasFileSize() {
        return this.m_fileSize != -1L;
    }

    public final long getFileSize() {
        return this.m_fileSize;
    }

    public void setFileSize(long fileSize) {
        this.m_fileSize = fileSize;
    }

    public final boolean hasAllocationSize() {
        return this.m_allocSize > 0L;
    }

    public final long getAllocationSize() {
        return this.m_allocSize;
    }

    public void setAllocationSize(long allocSize) {
        this.m_allocSize = allocSize;
    }

    public void setOpenCount(int count) {
        this.m_openCount = count;
    }

    public boolean hasDataUpdateInProgress() {
        return false;
    }

    public static final String normalizePath(String path) {
        return FileState.normalizePath(path, true);
    }

    public static final String normalizePath(String path, boolean caseSensitive) {
        String normPath = path;
        if (caseSensitive) {
            int pos;
            if (path.length() > 3 && (pos = path.lastIndexOf(92)) != -1) {
                String pathPart = FileState.upperCaseAToZ(path.substring(0, pos));
                String namePart = path.substring(pos);
                normPath = pathPart + namePart;
            }
        } else {
            normPath = FileState.upperCaseAToZ(path);
        }
        return normPath;
    }

    protected static final String upperCaseAToZ(String path) {
        StringBuilder pathStr = new StringBuilder(path);
        for (int i = 0; i < pathStr.length(); ++i) {
            char curChar = pathStr.charAt(i);
            if (!Character.isLowerCase(curChar)) continue;
            pathStr.setCharAt(i, Character.toUpperCase(curChar));
        }
        return pathStr.toString();
    }

    public final void DumpAttributes() {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(false);
        if (stateAttrs != null) {
            for (String name : stateAttrs.keySet()) {
                Object attrib = stateAttrs.get(name);
                Debug.println("++    " + name + " : " + attrib);
            }
        } else {
            Debug.println("++    No Attributes");
        }
    }

    public static final String getChangeReasonString(int reason) {
        String reasonStr = null;
        switch (reason) {
            case 0: {
                reasonStr = "None";
                break;
            }
            case 1: {
                reasonStr = "FileCreated";
                break;
            }
            case 2: {
                reasonStr = "FolderCreated";
                break;
            }
            case 3: {
                reasonStr = "FileDeleted";
                break;
            }
            case 4: {
                reasonStr = "FolderDeleted";
                break;
            }
            default: {
                reasonStr = "Unknown";
            }
        }
        return reasonStr;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append(FileStatus.asString(this.getFileStatus()));
        str.append(":Opn=");
        str.append(this.getOpenCount());
        if (this.getOpenCount() > 0) {
            str.append("(shr=0x");
            str.append(Integer.toHexString(this.getSharedAccess()));
            str.append(",pid=");
            str.append(this.getProcessId());
            str.append(")");
        }
        str.append(",Fid=");
        str.append(this.getFileId());
        str.append(",Expire=");
        str.append(this.getSecondsToExpire(System.currentTimeMillis()));
        str.append(",Sts=");
        str.append(_fileStates[this.getDataStatus()]);
        str.append(",Locks=");
        str.append(this.numberOfLocks());
        if (this.hasOpLock()) {
            str.append(",OpLock=");
            str.append(this.getOpLock());
        }
        str.append("]");
        return str.toString();
    }
}

