/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import nl.knaw.dans.common.dbflib.CorruptedTableException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.InvalidFieldLengthException;
import nl.knaw.dans.common.dbflib.InvalidFieldTypeException;
import nl.knaw.dans.common.dbflib.Type;
import nl.knaw.dans.common.dbflib.Util;
import nl.knaw.dans.common.dbflib.Version;

class DbfHeader {
    static final int OFFSET_VERSION = 0;
    static final int OFFSET_MODIFIED_DATE = 1;
    static final int OFFSET_RECORD_COUNT = 4;
    static final int OFFSET_HEADER_LENGTH = 8;
    static final int OFFSET_RECORD_LENGTH = 10;
    static final int OFFSET_RESERVED_1 = 12;
    static final int OFFSET_INCOMPLETE_TRANSATION = 14;
    static final int OFFSET_ENCRYPTION_FLAG = 15;
    static final int OFFSET_FREE_RECORD_THREAD = 16;
    static final int OFFSET_RESERVED_2 = 20;
    static final int OFFSET_MDX_FLAG = 28;
    static final int OFFSET_LANGUAGE_DRIVER = 29;
    static final int OFFSET_RESERVED_3 = 30;
    static final int OFFSET_FIELD_DESCRIPTORS = 32;
    static final int FD_OFFSET_NAME = 0;
    static final int FD_OFFSET_TYPE = 11;
    static final int FD_OFFSET_DATA_ADDRESS = 12;
    static final int FD_OFFSET_LENGTH = 16;
    static final int FD_OFFSET_DECIMAL_COUNT = 17;
    static final int FD_OFFSET_RESERVED_MULTIUSER_1 = 18;
    static final int FD_OFFSET_WORK_AREA_ID = 20;
    static final int FD_OFFSET_RESERVED_MULTIUSER_2 = 21;
    static final int FD_OFFSET_SET_FIELDS_FLAG = 23;
    static final int FD_OFFSET_RESERVED = 24;
    static final int FD_OFFSET_INDEX_FIELD_FLAG = 31;
    static final int FD_OFFSET_NEXT_FIELD = 32;
    private static final int LENGTH_FIELD_DESCRIPTOR = 32;
    private static final int LENGTH_FIELD_NAME = 11;
    private static final int LENGTH_FIELD_DATA_ADDRESS = 4;
    private static final int LENGTH_FIELD_DESCR_AFTER_DECIMAL_COUNT = 14;
    private static final int LENGTH_TABLE_HEADER_AFTER_RECORD_COUNT = 20;
    private static final int LENGTH_TABLE_INFO_BLOCK = 32;
    private static final int LENGTH_DELETE_FLAG = 1;
    private static final int OFFSET_WORK_AREA_ID = 20;
    private static final int LENGTH_RESERVED_1 = 2;
    private static final int LENGTH_RESERVED_2 = 8;
    private static final int LENGTH_RESERVED_3 = 2;
    private static final int MAX_LENGTH_FLOAT_FIELD = 20;
    private static final int MAX_LENGTH_LOGICAL_FIELD = 1;
    private static final int MAX_LENGTH_DATE_FIELD = 8;
    private static final byte FIELD_DESCRIPTOR_ARRAY_TERMINATOR = 13;
    private Version version;
    private int versionByte;
    private int recordCount;
    private List<Field> fields = new ArrayList<Field>();
    private short headerLength;
    private short recordLength;
    private Date lastModifiedDate;
    private boolean hasMemo;

    DbfHeader() {
    }

    void readAll(DataInput dataInput) throws IOException, CorruptedTableException {
        this.readVersionByte(dataInput);
        this.readModifiedDate(dataInput);
        this.readRecordCount(dataInput);
        this.readHeaderLength(dataInput);
        this.version = Version.getVersion(this.versionByte, this.headerLength % 32);
        this.readRecordLength(dataInput);
        dataInput.skipBytes(20);
        this.readFieldDescriptors(dataInput, this.getFieldCount());
    }

    Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    int getLength() {
        return this.headerLength;
    }

    int getRecordLength() {
        return this.recordLength;
    }

    void setHasMemo(boolean hasMemo) {
        this.hasMemo = hasMemo;
    }

    private void calculateRecordLength() {
        for (Field field : this.fields) {
            this.recordLength = (short)(this.recordLength + field.getLength());
        }
        this.recordLength = (short)(this.recordLength + 1);
    }

    private void calculateHeaderLength() {
        this.headerLength = (short)(32 + 32 * this.fields.size() + this.version.getLengthHeaderTerminator());
    }

    private int getFieldCount() throws CorruptedTableException {
        int nrBytesFieldDescriptorArray = this.headerLength - 32 - this.version.getLengthHeaderTerminator();
        if (nrBytesFieldDescriptorArray % 32 != 0) {
            throw new CorruptedTableException("Number of field descriptions in file could not be calculated.");
        }
        return nrBytesFieldDescriptorArray / 32;
    }

    private void readHeaderLength(DataInput dataInput) throws IOException {
        this.headerLength = Util.changeEndianness((short)dataInput.readUnsignedShort());
    }

    private void readModifiedDate(DataInput dataInput) throws IOException {
        int year = dataInput.readByte() + 1900;
        if (year < 1980) {
            year += 100;
        }
        byte month = dataInput.readByte();
        byte day = dataInput.readByte();
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.lastModifiedDate = cal.getTime();
    }

    private void readRecordLength(DataInput dataInput) throws IOException {
        this.recordLength = Util.changeEndianness((short)dataInput.readUnsignedShort());
    }

    void readFieldDescriptors(DataInput dataInput, int fieldCount) throws IOException {
        for (int i = 0; i < fieldCount; ++i) {
            this.fields.add(this.readField(dataInput));
        }
    }

    private Field readField(DataInput dataInput) throws IOException {
        int length = 0;
        int decimalCount = 0;
        String name = Util.readString(dataInput, 11);
        char typeChar = (char)dataInput.readByte();
        dataInput.skipBytes(4);
        if (this.version == Version.CLIPPER_5 && typeChar == Type.CHARACTER.getCode()) {
            length = Util.changeEndiannessUnsignedShort(dataInput.readUnsignedShort());
        } else {
            length = dataInput.readUnsignedByte();
            decimalCount = dataInput.readUnsignedByte();
        }
        dataInput.skipBytes(14);
        return new Field(name, Type.getTypeByCode(typeChar), length, decimalCount);
    }

    void readVersionByte(DataInput dataInput) throws IOException {
        this.versionByte = dataInput.readUnsignedByte();
    }

    void readRecordCount(DataInput dataInput) throws IOException {
        this.recordCount = Util.changeEndianness(dataInput.readInt());
    }

    void writeAll(DataOutput dataOutput) throws IOException {
        this.writeVersion(dataOutput);
        this.writeModifiedDate(dataOutput);
        this.writeRecordCount(dataOutput);
        this.writeHeaderLength(dataOutput);
        this.writeRecordLength(dataOutput);
        this.writeZeros(dataOutput, 2);
        this.writeIncompleteTransaction(dataOutput);
        this.writeEncryptionFlag(dataOutput);
        this.writeFreeRecordThread(dataOutput);
        this.writeZeros(dataOutput, 8);
        this.writeMdxFlag(dataOutput);
        this.writeLanguageDriver(dataOutput);
        this.writeZeros(dataOutput, 2);
        this.writeFieldDescriptors(dataOutput);
    }

    void setFields(List<Field> fieldList) throws InvalidFieldTypeException, InvalidFieldLengthException {
        this.fields = fieldList;
        this.checkFieldValidity(this.fields);
        this.calculateRecordLength();
        this.calculateHeaderLength();
    }

    void checkFieldValidity(List<Field> fieldList) throws InvalidFieldTypeException, InvalidFieldLengthException {
        boolean invalidLength = false;
        for (Field field : fieldList) {
            if (!this.version.fieldTypes.contains((Object)field.getType())) {
                throw new InvalidFieldTypeException("Invalid field type ('" + field.getType().toString() + "') for this version ");
            }
            switch (field.getType()) {
                case CHARACTER: {
                    if (field.getLength() >= 1 && field.getLength() <= this.version.getMaxLengthCharField()) break;
                    invalidLength = true;
                    break;
                }
                case NUMBER: {
                    if (field.getLength() >= 1 && field.getLength() <= this.version.getMaxLengthNumberField()) break;
                    invalidLength = true;
                    break;
                }
                case FLOAT: {
                    if (field.getLength() >= 1 && field.getLength() <= 20) break;
                    invalidLength = true;
                    break;
                }
                case LOGICAL: {
                    if (field.getLength() >= 1 && field.getLength() <= 1) break;
                    invalidLength = true;
                    break;
                }
                case DATE: {
                    if (field.getLength() >= 1 && field.getLength() <= 8) break;
                    invalidLength = true;
                }
            }
            if (!invalidLength) continue;
            if (field.getLength() < 1) {
                throw new InvalidFieldLengthException("Field length less than one (field '" + field.getName() + "') ");
            }
            throw new InvalidFieldLengthException("Field length exceeds the allowed field length (field '" + field.getName() + "') ");
        }
    }

    void setVersion(Version version) {
        this.version = version;
    }

    void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    List<Field> getFields() {
        return Collections.unmodifiableList(new ArrayList<Field>(this.fields));
    }

    Version getVersion() {
        return this.version;
    }

    int getRecordCount() {
        return this.recordCount;
    }

    void writeEncryptionFlag(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(0);
    }

    void writeIncompleteTransaction(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(0);
    }

    void writeFieldDescriptor(DataOutput dataOutput, Field field) throws IOException {
        Util.writeString(dataOutput, field.getName(), 10);
        dataOutput.writeByte(0);
        dataOutput.writeByte(field.getType().getCode());
        dataOutput.writeInt(0);
        dataOutput.writeByte(field.getLength());
        dataOutput.writeByte(field.getDecimalCount());
        dataOutput.writeByte(0);
        dataOutput.writeByte(0);
        dataOutput.writeByte(1);
        for (int i = 0; i < 11; ++i) {
            dataOutput.writeByte(0);
        }
    }

    void writeFieldDescriptors(DataOutput dataOutput) throws IOException {
        for (Field field : this.fields) {
            this.writeFieldDescriptor(dataOutput, field);
        }
        dataOutput.writeByte(13);
    }

    void writeFreeRecordThread(DataOutput dataOutput) throws IOException {
        this.writeZeros(dataOutput, 4);
    }

    void writeHeaderLength(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(Util.changeEndianness(this.headerLength));
    }

    void writeLanguageDriver(DataOutput dataOutput) throws IOException {
        this.writeZeros(dataOutput, 1);
    }

    void writeMdxFlag(DataOutput dataOutput) throws IOException {
        this.writeZeros(dataOutput, 1);
    }

    void writeModifiedDate(DataOutput dataOutput) throws IOException {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1) - 1900;
        if (year >= 100) {
            year -= 100;
        }
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        dataOutput.writeByte(year);
        dataOutput.writeByte(month);
        dataOutput.writeByte(day);
        this.lastModifiedDate = Util.createDate(year, month, day);
    }

    void writeRecordCount(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(Util.changeEndianness(this.recordCount));
    }

    void writeRecordLength(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(Util.changeEndianness(this.recordLength));
    }

    void writeVersion(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(Version.getVersionByte(this.version, this.hasMemo));
    }

    void writeZeros(DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeByte(0);
        }
    }
}

