/*
 *  Mathlib : A C Library of Special Functions
 *  Copyright (C) 1998   Ross Ihaka
 *  Copyright (C) 2000-9 The R Development Core Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, a copy is available at
 *  http://www.r-project.org/Licenses/
 */
package jdistlib;

import static java.lang.Math.*;

public class Spearman {
	// From pspearman package
	private static final double[][] spearmanArray = {
		{0},
		{1.0},
		{1.0,2.0,0.0},
		{1.0,3.0,1.0,4.0,2.0,2.0},
		{1.0,4.0,3.0,6.0,7.0,6.0,4.0,10.0,6.0,10.0,6.0},
		{1.0,5.0,6.0,9.0,16.0,12.0,14.0,24.0,20.0,21.0,23.0,28.0,24.0,34.0,20.0,32.0,42.0,29.0},
		{1.0,6.0,10.0,14.0,29.0,26.0,35.0,46.0,55.0,54.0,74.0,70.0,84.0,90.0,78.0,90.0,129.0,106.0,123.0,134.0,147.0,98.0,168.0,
		130.0,175.0,144.0,168.0,144.0,184.0},
		{1.0,7.0,15.0,22.0,47.0,54.0,70.0,94.0,129.0,124.0,178.0,183.0,237.0,238.0,276.0,264.0,379.0,349.0,380.0,400.0,
		517.0,394.0,542.0,492.0,640.0,557.0,666.0,595.0,776.0,684.0,786.0,718.0,922.0,745.0,917.0,781.0,982.0,826.0,
		950.0,844.0,1066.0,845.0,936.0},
		{1.0,8.0,21.0,34.0,72.0,102.0,130.0,190.0,260.0,284.0,398.0,454.0,555.0,616.0,756.0,744.0,1022.0,1042.0,1159.0,
		1282.0,1555.0,1392.0,1719.0,1758.0,2009.0,2032.0,2282.0,2214.0,2676.0,2590.0,2878.0,2928.0,3397.0,3138.0,
		3647.0,3568.0,3921.0,3866.0,4311.0,4050.0,4852.0,4492.0,4816.0,4784.0,5505.0,4954.0,5638.0,5304.0,5890.0,
		5486.0,6188.0,5502.0,6436.0,5822.0,6233.0,6024.0,6697.0,5720.0,6672.0,6020.0,6688.0},
		{1.0,9.0,28.0,51.0,107.0,177.0,234.0,360.0,498.0,619.0,819.0,1040.0,1252.0,1528.0,1824.0,2010.0,2533.0,2837.0,
		3180.0,3676.0,4305.0,4493.0,5130.0,5672.0,6156.0,6909.0,7424.0,7830.0,8773.0,9392.0,9892.0,10678.0,
		11647.0,12141.0,13026.0,13918.0,14519.0,15611.0,16278.0,16780.0,18686.0,19280.0,19586.0,20795.0,
		22385.0,22896.0,23948.0,24970.0,26012.0,27096.0,28467.0,28427.0,30540.0,31272.0,31774.0,33264.0,
		34748.0,34499.0,36299.0,36596.0,38456.0,38926.0,39984.0,39386.0,42068.0,42848.0,42424.0,42925.0,
		45044.0,44584.0,46040.0,45496.0,46890.0,47036.0,47341.0,47646.0,48887.0,48840.0,48044.0,48540.0,
		50066.0,48970.0,49062.0},
		{1.0,10.0,36.0,74.0,156.0,288.0,409.0,644.0,930.0,1246.0,1636.0,2238.0,2714.0,3476.0,4198.0,5052.0,6027.0,
		7306.0,8207.0,9816.0,11384.0,12804.0,14193.0,16752.0,18079.0,20868.0,22580.0,25386.0,27333.0,31112.0,
		32448.0,36592.0,39140.0,43106.0,44778.0,50528.0,51964.0,57442.0,59348.0,65128.0,67870.0,74598.0,
		75264.0,82944.0,86123.0,93058.0,94220.0,103862.0,105313.0,114196.0,116213.0,125332.0,127623.0,
		138470.0,138317.0,150734.0,152353.0,162940.0,163331.0,176900.0,178020.0,190498.0,190152.0,
		203754.0,204867.0,220252.0,217045.0,232916.0,233434.0,248128.0,245488.0,262886.0,260963.0,
		277202.0,272844.0,292598.0,288389.0,306736.0,299406.0,319584.0,314926.0,333234.0,324357.0,
		345816.0,338295.0,360090.0,346910.0,369960.0,361215.0,381662.0,369447.0,391392.0,379327.0,
		402126.0,385304.0,411086.0,396552.0,418090.0,398919.0,425844.0,409927.0,429832.0,410407.0,
		435898.0,416495.0,440086.0,416895.0,440380.0,421188.0,442248.0,420480.0},
		{1.0,11.0,45.0,104.0,224.0,447.0,691.0,1106.0,1685.0,2364.0,3204.0,4515.0,5696.0,7489.0,9349.0,11674.0,
		13990.0,17637.0,20224.0,24754.0,29017.0,33942.0,38126.0,45884.0,50335.0,58769.0,65357.0,74938.0,
		81377.0,94494.0,100563.0,115222.0,124120.0,139785.0,147928.0,168875.0,176242.0,197443.0,208076.0,
		230894.0,241008.0,270313.0,277189.0,307769.0,320330.0,351886.0,361038.0,400464.0,408638.0,
		449017.0,461014.0,503127.0,512780.0,563815.0,569548.0,623258.0,634516.0,688442.0,695523.0,
		760903.0,765072.0,832427.0,838450.0,908396.0,912804.0,993883.0,992831.0,1073538.0,1078809.0,
		1163135.0,1162148.0,1259822.0,1252655.0,1351968.0,1347572.0,1452294.0,1445058.0,1556327.0,
		1540961.0,1657338.0,1646459.0,1766307.0,1745370.0,1876868.0,1851978.0,1988308.0,1960781.0,
		2097330.0,2067296.0,2215579.0,2177879.0,2328850.0,2287815.0,2442657.0,2395528.0,2561776.0,
		2508162.0,2671633.0,2614400.0,2786853.0,2724111.0,2903732.0,2827376.0,3010422.0,2933732.0,
		3119473.0,3037478.0,3223085.0,3135126.0,3323377.0,3235030.0,3430056.0,3323582.0,3523672.0,
		3411922.0,3617531.0,3501633.0,3703255.0,3579168.0,3784866.0,3661664.0,3867119.0,3727644.0,
		3931625.0,3796200.0,4005139.0,3857556.0,4061582.0,3907440.0,4113107.0,3962844.0,4167834.0,
		3998147.0,4200614.0,4032778.0,4239762.0,4065521.0,4259186.0,4085197.0,4278553.0,4100572.0,
		4294448.0,4103817.0,4298664.0},
		{1.0,12.0,55.0,142.0,317.0,670.0,1127.0,1844.0,2951.0,4310.0,6088.0,8708.0,11587.0,15418.0,20016.0,
		25570.0,31667.0,40242.0,48025.0,59284.0,71102.0,85026.0,98320.0,118542.0,134958.0,158040.0,
		180310.0,208308.0,233236.0,269916.0,297048.0,339972.0,375937.0,424608.0,462228.0,524942.0,
		566979.0,633746.0,686047.0,761310.0,817107.0,909744.0,964800.0,1065992.0,1138521.0,1245730.0,
		1315174.0,1447024.0,1522702.0,1659552.0,1747046.0,1896492.0,1986407.0,2162212.0,2245621.0,
		2432194.0,2543828.0,2734866.0,2835400.0,3068180.0,3170585.0,3408592.0,3525861.0,3783196.0,
		3899774.0,4192938.0,4299258.0,4601094.0,4745784.0,5055532.0,5174632.0,5545970.0,5670088.0,
		6038506.0,6178310.0,6571596.0,6716042.0,7147558.0,7271677.0,7721884.0,7885235.0,8347042.0,
		8470600.0,9005120.0,9138310.0,9663102.0,9812493.0,10365234.0,10513307.0,11113646.0,
		11225392.0,11857744.0,12012468.0,12646038.0,12754458.0,13463796.0,13591198.0,14278576.0,
		14405617.0,15142336.0,15259324.0,16048214.0,16105588.0,16923958.0,17044118.0,17841050.0,
		17903636.0,18787058.0,18865804.0,19721254.0,19775610.0,20702900.0,20735025.0,21691788.0,
		21664773.0,22651060.0,22689798.0,23657946.0,23606072.0,24659546.0,24622080.0,25656300.0,
		25566045.0,26655856.0,26571587.0,27668176.0,27518320.0,28640222.0,28543471.0,29643286.0,
		29443599.0,30642576.0,30443509.0,31602636.0,31333301.0,32564446.0,32319917.0,33500618.0,
		33174681.0,34415424.0,34109507.0,35342166.0,34909036.0,36237988.0,35822933.0,37056530.0,
		36584269.0,37873230.0,37432685.0,38680992.0,38114667.0,39450896.0,38887382.0,40181032.0,
		39504908.0,40854118.0,40263517.0,41495420.0,40769221.0,42111970.0,41404913.0,42672592.0,
		41853652.0,43194552.0,42396485.0,43667268.0,42778281.0,44063462.0,43233261.0,44466370.0,
		43461804.0,44788938.0,43834189.0,45048558.0,43998971.0,45259500.0,44258181.0,45412672.0,
		44326704.0,45515922.0,44472111.0,45598614.0,44405142.0},
		{1.0,13.0,66.0,189.0,442.0,978.0,1778.0,3001.0,5004.0,7621.0,11185.0,16296.0,22714.0,30687.0,41329.0,
		53890.0,69000.0,88312.0,109936.0,136282.0,168065.0,203992.0,243089.0,293640.0,346170.0,406445.0,
		476376.0,555090.0,638435.0,737981.0,840101.0,958754.0,1089297.0,1231500.0,1377986.0,1558499.0,
		1736395.0,1931682.0,2146913.0,2383583.0,2623346.0,2901673.0,3179333.0,3489007.0,3821032.0,
		4169325.0,4524641.0,4942522.0,5353035.0,5789483.0,6258394.0,6765738.0,7268994.0,7836509.0,
		8393474.0,9007679.0,9653784.0,10315483.0,10980922.0,11756111.0,12493529.0,13284027.0,
		14104701.0,15002446.0,15857273.0,16829150.0,17759467.0,18799871.0,19840147.0,20936584.0,
		21994402.0,23257727.0,24416130.0,25674050.0,26933190.0,28337570.0,29660744.0,31142288.0,
		32538704.0,34131234.0,35657364.0,37303229.0,38866238.0,40713556.0,42390411.0,44226231.0,
		46026210.0,48052422.0,49928436.0,52010628.0,53959720.0,56242541.0,58338267.0,60610281.0,
		62777150.0,65299148.0,67603742.0,70103053.0,72486017.0,75242909.0,77757239.0,80514530.0,
		83095790.0,86134914.0,88853220.0,91786159.0,94654998.0,97905224.0,100842450.0,104081709.0,
		107061609.0,110610554.0,113799356.0,117211215.0,120417930.0,124247914.0,127581181.0,
		131238022.0,134726882.0,138693952.0,142228858.0,146213039.0,149744398.0,154011822.0,
		157834377.0,161825434.0,165621673.0,170242454.0,174034077.0,178290125.0,182365752.0,
		186984277.0,191021135.0,195611361.0,199527113.0,204460431.0,208828302.0,213250340.0,
		217440443.0,222729462.0,226759859.0,231569284.0,236032454.0,241135132.0,245439431.0,
		250504769.0,254612331.0,259997865.0,264665913.0,269356997.0,273667172.0,279524301.0,
		283593012.0,288632518.0,293226622.0,298545201.0,302967996.0,308339632.0,312258438.0,
		317978518.0,322597197.0,327295672.0,331561587.0,337672699.0,341420019.0,346487453.0,
		351068351.0,356335035.0,360417294.0,365857944.0,369305338.0,375044914.0,379452513.0,
		383842057.0,387658144.0,393682784.0,396981304.0,401710452.0,405882413.0,410776076.0,
		414306115.0,419446656.0,422214081.0,427562490.0,431456290.0,435111738.0,438382275.0,
		443994124.0,446432305.0,450450697.0,453988014.0,458174232.0,461002239.0,465343459.0,
		467281490.0,471745412.0,474948799.0,477641982.0,480006472.0,484827139.0,486253544.0,
		489242049.0,492039840.0,494978045.0,496952466.0,500110514.0,501161877.0,504454988.0,
		506848516.0,508065797.0,509425844.0,513061847.0,513585323.0,515102059.0,516978459.0,
		518489286.0,519535434.0,521182527.0,521270191.0,523036325.0,524433229.0,524177317.0,
		524632679.0,526655128.0,526115720.0,525983713.0,527033785.0,526902688.0},
		{1.0,14.0,78.0,246.0,607.0,1398.0,2723.0,4778.0,8249.0,13116.0,19925.0,29744.0,42977.0,59494.0,82394.0,
		110038.0,144988.0,188338.0,241827.0,303424.0,383424.0,472472.0,578006.0,703844.0,851648.0,
		1010232.0,1209450.0,1423616.0,1672638.0,1948968.0,2270978.0,2605684.0,3021630.0,3440504.0,
		3931304.0,4458672.0,5075461.0,5675284.0,6426995.0,7165964.0,8036349.0,8914408.0,9962103.0,
		10955498.0,12213818.0,13374904.0,14782820.0,16160026.0,17829199.0,19328362.0,21255960.0,
		23012680.0,25165370.0,27156104.0,29620688.0,31791190.0,34644351.0,37086304.0,40166496.0,
		42954596.0,46470939.0,49423256.0,53357428.0,56696414.0,60980460.0,64632006.0,69395071.0,
		73329050.0,78653930.0,82935378.0,88586235.0,93363616.0,99685403.0,104635768.0,111515217.0,
		116974276.0,124425214.0,130284666.0,138328420.0,144583466.0,153390644.0,160051970.0,
		169396667.0,176626760.0,186854457.0,194316512.0,205262725.0,213380408.0,225159341.0,
		233639864.0,246107869.0,255271718.0,268795401.0,278227458.0,292535146.0,302629396.0,
		318072065.0,328557272.0,344727709.0,355956562.0,373398179.0,384885612.0,403210562.0,
		415622824.0,435161655.0,447652676.0,468425726.0,481703380.0,503678298.0,517550828.0,
		540225670.0,554885368.0,579618738.0,594150034.0,619660115.0,635544616.0,662512419.0,
		678357768.0,706929737.0,723397128.0,753272921.0,770668216.0,801318839.0,819270010.0,
		852679809.0,869971540.0,904129039.0,923710534.0,959146548.0,977983620.0,1015733723.0,
		1035167042.0,1074357293.0,1094896006.0,1134506034.0,1155283444.0,1198843691.0,
		1218536240.0,1262164158.0,1284902046.0,1329685208.0,1351189690.0,1399328856.0,
		1420675522.0,1470119887.0,1492937788.0,1542396790.0,1565421300.0,1619799389.0,
		1640729582.0,1694461356.0,1719650638.0,1774614738.0,1797158122.0,1856311266.0,
		1878180378.0,1938469061.0,1962938958.0,2022139752.0,2045968196.0,2111358815.0,
		2132040756.0,2196584624.0,2222493548.0,2287428235.0,2309480198.0,2380088834.0,
		2401110522.0,2471798762.0,2496002546.0,2564518188.0,2587603222.0,2664604978.0,
		2682692304.0,2757384075.0,2782008170.0,2857045326.0,2876898986.0,2957939999.0,
		2975776954.0,3056145115.0,3078496002.0,3156159871.0,3175928724.0,3263525385.0,
		3276477908.0,3360962613.0,3382751912.0,3465833975.0,3481027850.0,3571749127.0,
		3584194978.0,3673999368.0,3691289922.0,3776640628.0,3790212494.0,3887582735.0,
		3893712272.0,3985719650.0,4001970014.0,4091800490.0,4100049906.0,4199450612.0,
		4203209244.0,4300414700.0,4309954112.0,4401608453.0,4407365050.0,4512145601.0,
		4508069904.0,4605646320.0,4614221808.0,4709677147.0,4707664058.0,4813372529.0,
		4805490064.0,4908592591.0,4908603480.0,5003679733.0,4998400272.0,5107975635.0,
		5092349102.0,5194265531.0,5191369394.0,5289507506.0,5274566644.0,5384678058.0,
		5364098636.0,5469291271.0,5457357380.0,5552940649.0,5535155390.0,5648077592.0,
		5617102862.0,5720161421.0,5703803962.0,5802598697.0,5774153012.0,5884320975.0,
		5849017536.0,5953542186.0,5928097702.0,6022508658.0,5989707406.0,6101899315.0,
		6054659148.0,6156493730.0,6126608764.0,6221940927.0,6178217062.0,6285232986.0,
		6234671836.0,6336190338.0,6295878162.0,6385551002.0,6336755374.0,6445998622.0,
		6383574762.0,6479377408.0,6434506552.0,6523050060.0,6465019476.0,6566986368.0,
		6500314872.0,6595476897.0,6539582206.0,6622153512.0,6559510856.0,6660313955.0,
		6583022892.0,6669719910.0,6611763532.0,6691930320.0,6618812738.0,6711815053.0,
		6630235054.0,6716291184.0,6647688784.0,6719002762.0,6642826900.0,6732621476.0},
		{1.0,15.0,91.0,314.0,821.0,1964.0,4064.0,7450.0,13274.0,22012.0,34558.0,53017.0,78913.0,112511.0,
		159259.0,218617.0,294940.0,390960.0,513571.0,657686.0,845620.0,1061931.0,1326562.0,1637732.0,
		2019333.0,2435652.0,2959948.0,3536140.0,4224269.0,4984315.0,5897705.0,6859935.0,8055993.0,
		9291759.0,10771272.0,12339133.0,14235115.0,16114514.0,18454983.0,20801113.0,23624509.0,
		26457817.0,29903267.0,33237072.0,37418018.0,41391193.0,46244039.0,50982857.0,56811978.0,
		62189087.0,69003840.0,75363501.0,83221607.0,90529050.0,99642522.0,107893977.0,118531238.0,
		127960414.0,139814974.0,150644543.0,164379230.0,176232028.0,191762136.0,205309235.0,
		222689131.0,237722067.0,257289809.0,273850387.0,295990436.0,314328112.0,338416469.0,
		358958723.0,386210669.0,408101272.0,438119089.0,462569417.0,495565706.0,522115439.0,
		558351159.0,587027266.0,627245078.0,658338880.0,701435965.0,735512240.0,783377779.0,
		819089278.0,870831970.0,910180183.0,966324371.0,1008103323.0,1068689624.0,1113516790.0,
		1179901176.0,1227467627.0,1297783475.0,1349318647.0,1426405570.0,1479882939.0,
		1561872235.0,1620132247.0,1708414623.0,1769351892.0,1863629758.0,1928450037.0,
		2030528759.0,2098359655.0,2205679550.0,2278584648.0,2394917989.0,2469892113.0,
		2592196257.0,2673221920.0,2804662244.0,2887958020.0,3026543482.0,3115011081.0,
		3263868647.0,3355604011.0,3511041950.0,3608565122.0,3775818962.0,3875550292.0,
		4049988843.0,4156753481.0,4343340150.0,4451575520.0,4646880310.0,4762334583.0,
		4970109121.0,5087916997.0,5304103223.0,5428796514.0,5659851610.0,5786531837.0,
		6025387546.0,6159868275.0,6415447272.0,6550189957.0,6814594412.0,6958689314.0,
		7238124939.0,7383679466.0,7674071719.0,7826248041.0,8134714811.0,8288451347.0,
		8604901887.0,8767901206.0,9105196048.0,9265957663.0,9612351164.0,9785408356.0,
		10150054944.0,10321160592.0,10698848147.0,10876527827.0,11275299527.0,11455675025.0,
		11860967149.0,12050097426.0,12482099291.0,12665455179.0,13106598623.0,13304982115.0,
		13765836861.0,13958843845.0,14436312737.0,14635712499.0,15135886845.0,15337175737.0,
		15841507182.0,16052223903.0,16590832453.0,16789782242.0,17335173518.0,17552872268.0,
		18121267398.0,18329092569.0,18914763661.0,19127740286.0,19737706521.0,19953443178.0,
		20565973193.0,20788332665.0,21442477448.0,21646430671.0,22304614380.0,22533554512.0,
		23213019695.0,23425763316.0,24126522666.0,24342439335.0,25070602142.0,25287283572.0,
		26012172315.0,26233683051.0,27008953839.0,27206305998.0,27979592859.0,28206568521.0,
		29002085801.0,29205506557.0,30025792643.0,30228441941.0,31075111297.0,31279118346.0,
		32118367915.0,32326203785.0,33223011193.0,33395612758.0,34283447029.0,34494416526.0,
		35405572749.0,35582138322.0,36520407507.0,36692000248.0,37657997787.0,37832873419.0,
		38780462705.0,38955493528.0,39969878257.0,40102429061.0,41102804875.0,41276551571.0,
		42298083811.0,42426969841.0,43479086283.0,43602554780.0,44676705345.0,44804392501.0,
		45852131609.0,45976651212.0,47103934730.0,47170615223.0,48273255758.0,48390696476.0,
		49511716537.0,49576628032.0,50728599050.0,50782016067.0,51954719552.0,52013953823.0,
		53151351493.0,53201852748.0,54424719061.0,54407095722.0,55597916597.0,55641782807.0,
		56846281522.0,56823053478.0,58059184510.0,58022716794.0,59276945929.0,59246435087.0,
		60454150100.0,60409709941.0,61715801270.0,61594314010.0,62849980112.0,62798231987.0,
		64062095572.0,63936463087.0,65238781447.0,65090562869.0,66406054739.0,66263801622.0,
		67521717365.0,67366643680.0,68724907632.0,68482534966.0,69781277656.0,69618073383.0,
		70923685076.0,70670461286.0,72012628881.0,71735853483.0,73086254680.0,72823102711.0,
		74101489295.0,73817910671.0,75205654112.0,74825544307.0,76143131471.0,75851063378.0,
		77167452136.0,76776334641.0,78131998723.0,77717290424.0,79072603479.0,78671309652.0,
		79942962680.0,79521674720.0,80910350605.0,80382566474.0,81689025222.0,81254940134.0,
		82558978382.0,82022477794.0,83358753501.0,82796126610.0,84123913986.0,83581992058.0,
		84822468394.0,84252665409.0,85613888252.0,84930183871.0,86199592880.0,85622137792.0,
		86876577732.0,86191400487.0,87479816718.0,86770483515.0,88050166046.0,87357493920.0,
		88535810883.0,87816843112.0,89118205549.0,88288305308.0,89487144698.0,88767060264.0,
		89949916406.0,89116332248.0,90332283693.0,89473674505.0,90671984629.0,89836212727.0,
		90930743738.0,90071722296.0,91285999557.0,90311298401.0,91414251734.0,90558056794.0,
		91643816468.0,90673498729.0,91789417741.0,90790806911.0,91889701075.0,90920370715.0,
		91904772153.0,90915018394.0,92014579912.0},
		{1.0,16.0,105.0,394.0,1094.0,2718.0,5932.0,11386.0,20919.0,36088.0,58550.0,92370.0,141287.0,207594.0,
		299968.0,423200.0,583307.0,790886.0,1059144.0,1387862.0,1810503.0,2322882.0,2950929.0,
		3706526.0,4639185.0,5703580.0,7016065.0,8528040.0,10322501.0,12367396.0,14816218.0,
		17516144.0,20760761.0,24328846.0,28502897.0,33097816.0,38539890.0,44291728.0,51133636.0,
		58448908.0,66943579.0,75947786.0,86533849.0,97495574.0,110439277.0,123837572.0,139338234.0,
		155458490.0,174321561.0,193312268.0,215663251.0,238437406.0,264774864.0,291366906.0,
		322476988.0,353377632.0,389761762.0,425846044.0,467613567.0,509285210.0,558100725.0,
		605340660.0,661169323.0,715781622.0,779374750.0,841027234.0,913762453.0,983285646.0,
		1065829955.0,1144447942.0,1236715960.0,1325060242.0,1429998461.0,1527622508.0,
		1644564876.0,1754484392.0,1884766212.0,2006174210.0,2151527535.0,2285389626.0,
		2447054206.0,2594986588.0,2772272448.0,2935278572.0,3132647346.0,3309478176.0,
		3525472196.0,3720868734.0,3957621599.0,4169368162.0,4428587363.0,4658777596.0,
		4942973400.0,5192608774.0,5499617063.0,5771096752.0,6107170412.0,6397989304.0,
		6760982311.0,7077104524.0,7470269089.0,7808779892.0,8233162690.0,8597177228.0,
		9057024717.0,9446117930.0,9937627688.0,10357057514.0,10888277817.0,11332714732.0,
		11900796777.0,12377951444.0,12988860573.0,13495020976.0,14145488657.0,14686055206.0,
		15385179027.0,15956217056.0,16698110916.0,17308756674.0,18101937042.0,18744222128.0,
		19587157638.0,20269385900.0,21168878164.0,21887634858.0,22836199253.0,23600472462.0,
		24614029078.0,25410936608.0,26480359033.0,27328642696.0,28462188437.0,29350100108.0,
		30546642219.0,31480042802.0,32752072587.0,33731127104.0,35059305145.0,36095650734.0,
		37508793482.0,38578055976.0,40063976352.0,41197901598.0,42758415360.0,43939399378.0,
		45579961128.0,46812199726.0,48549428701.0,49834583856.0,51633889864.0,52991055054.0,
		54899746633.0,56285122112.0,58283153259.0,59748333912.0,61830324685.0,63354635104.0,
		65535528845.0,67107375980.0,69410850189.0,71044729746.0,73413765274.0,75136441464.0,
		77638470877.0,79378775050.0,81991313209.0,83830793112.0,86533742136.0,88437859908.0,
		91258820671.0,93206362468.0,96182531917.0,98199464834.0,101233034631.0,103358574262.0,
		106556042381.0,108682175678.0,112011385568.0,114251557650.0,117670526855.0,
		119986759222.0,123550821630.0,125894850308.0,129642704897.0,132064678874.0,
		135857507668.0,138412566978.0,142399270412.0,144923065326.0,149065617100.0,
		151722433944.0,155954369365.0,158694864044.0,163086558502.0,165833874108.0,
		170447099012.0,173283185742.0,177917753163.0,180903900628.0,185768340297.0,
		188679738670.0,193730810553.0,196797323884.0,201912453585.0,205072457022.0,
		210371180394.0,213511886848.0,219068297971.0,222294916920.0,227838786715.0,
		231240948410.0,237057331443.0,240331329510.0,246351666492.0,249797936800.0,
		255859380926.0,259416687788.0,265679099377.0,269161882928.0,275725302781.0,
		279303374910.0,285812803864.0,289588472664.0,296400137942.0,299977271742.0,
		307016343461.0,310800728148.0,317839881711.0,321732166094.0,328995943953.0,
		332759640430.0,340375829832.0,344229305954.0,351719131958.0,355803705538.0,
		363628810987.0,367444427756.0,375525645155.0,379553574144.0,387584996300.0,
		391729392580.0,400014138190.0,403958164000.0,412623075267.0,416666441874.0,
		425125367528.0,429438470090.0,438275156098.0,442205601588.0,451316409995.0,
		455483386210.0,464497562597.0,468785529418.0,478052897298.0,482061469672.0,
		491756693741.0,495874358752.0,505268380695.0,509672713484.0,519475279227.0,
		523389963874.0,533508732950.0,537681458928.0,547603847069.0,551905208674.0,
		562098744778.0,566042618414.0,576698909867.0,580736643872.0,590994175556.0,
		595339916288.0,606064492096.0,609797135016.0,620827051821.0,624847188372.0,
		635593287440.0,639770873570.0,650791066878.0,654487708640.0,666021759597.0,
		669801322058.0,680831180776.0,684957641784.0,696466034370.0,699849152650.0,
		711676847705.0,715394428822.0,726837143956.0,730684634778.0,742415470901.0,
		745675297858.0,757971264626.0,761321220812.0,772967330648.0,776683642714.0,
		788832927017.0,791699671568.0,804178811459.0,807371510978.0,819358835184.0,
		822697289190.0,835001842608.0,837631319170.0,850509214507.0,853229661612.0,
		865315411623.0,868459096916.0,881079304455.0,883203713976.0,896159220315.0,
		898639737836.0,911030323726.0,913640475422.0,926310751959.0,928122474728.0,
		941377479806.0,943309904000.0,955641361451.0,957997212258.0,970891549298.0,
		972084073046.0,985346339346.0,986913411110.0,999456156478.0,1001171728272.0,
		1013999646636.0,1014824111980.0,1028264592399.0,1029185178842.0,1041560135959.0,
		1042921410534.0,1055909246369.0,1055997882798.0,1069303870850.0,1069793011404.0,
		1082277427282.0,1082942500108.0,1095698908300.0,1095350489214.0,1108736831929.0,
		1108476103604.0,1120709408499.0,1120918328038.0,1133736736795.0,1132551221118.0,
		1145678876377.0,1144972030106.0,1157158773509.0,1156594449704.0,1169059156250.0,
		1167380877960.0,1180515701971.0,1178938173508.0,1190761329417.0,1189677417378.0,
		1202089786234.0,1199570336420.0,1212264372945.0,1210191976562.0,1221875422526.0,
		1219950256546.0,1231920796931.0,1228812111376.0,1241423292967.0,1238432125896.0,
		1249612770279.0,1247180498952.0,1258962635498.0,1254959554988.0,1267007043263.0,
		1263493342920.0,1274466811795.0,1271107169514.0,1282332324218.0,1277745389776.0,
		1289581947579.0,1285161935708.0,1295494520842.0,1291603521450.0,1302527077889.0,
		1297017672472.0,1308244139711.0,1303238254852.0,1313282490611.0,1308450269054.0,
		1318703665622.0,1312657622246.0,1323514727984.0,1317625639640.0,1326900171176.0,
		1321554269190.0,1331479574845.0,1324468737160.0,1334609317618.0,1328144967948.0,
		1337056160035.0,1330815859276.0,1339924725612.0,1332416835144.0,1342118858371.0,
		1334772586622.0,1342893005283.0,1336115564874.0,1344809800896.0,1336382618996.0,
		1345276736949.0,1337452510462.0,1345077232898.0},
		{1.0,17.0,120.0,487.0,1437.0,3711.0,8494.0,17074.0,32363.0,57912.0,97127.0,157528.0,247436.0,374142.0,
		552470.0,799280.0,1125869.0,1560789.0,2129552.0,2853427.0,3779842.0,4949337.0,6387969.0,
		8170844.0,10369539.0,12990453.0,16177087.0,19998138.0,24509803.0,29832430.0,36148759.0,
		43420042.0,51971161.0,61842204.0,73176245.0,86182455.0,101235851.0,118064690.0,137400395.0,
		159225801.0,183828480.0,211332592.0,242573610.0,276931353.0,315751180.0,358675185.0,
		406288427.0,458840587.0,517616819.0,581271639.0,652092539.0,729579745.0,814626085.0,
		906988061.0,1008992355.0,1118603399.0,1239334858.0,1369682482.0,1511074061.0,
		1663732913.0,1830818750.0,2008293976.0,2201811004.0,2409387558.0,2633459874.0,
		2872301708.0,3131463498.0,3405697092.0,3702910775.0,4018211879.0,4356207757.0,
		4714816489.0,5102404064.0,5508210357.0,5945239343.0,6406721035.0,6900470567.0,
		7418979276.0,7975302745.0,8556927526.0,9181339214.0,9834019912.0,10529105876.0,
		11256407147.0,12035709200.0,12843135821.0,13704884113.0,14603711799.0,15560407181.0,
		16552318205.0,17608629435.0,18702633470.0,19869531753.0,21074083344.0,22352357248.0,
		23675043817.0,25082304019.0,26529550564.0,28063927329.0,29647431889.0,31328374752.0,
		33052897201.0,34878775867.0,36757258917.0,38749638043.0,40787293997.0,42942567984.0,
		45154535258.0,47494432629.0,49888072249.0,52411524873.0,54993519159.0,57731071211.0,
		60516149751.0,63448444378.0,66454328736.0,69623987020.0,72843387016.0,76242118824.0,
		79706493960.0,83352913754.0,87069947851.0,90970295739.0,94934323100.0,99132020858.0,
		103377153855.0,107821591046.0,112370213386.0,117143496798.0,121961562458.0,
		127045290026.0,132194457093.0,137593993075.0,143086247778.0,148823468526.0,
		154622661494.0,160761549199.0,166937428837.0,173372417772.0,179952519881.0,
		186831686369.0,193732854460.0,201020119607.0,208361564204.0,216031944730.0,
		223824453157.0,231932396316.0,240087472454.0,248728835500.0,257373514992.0,
		266354977100.0,275522780560.0,285086218998.0,294623174229.0,304708352597.0,
		314815762373.0,325342207625.0,336034099373.0,347123284845.0,358215870160.0,
		369998670567.0,381712634789.0,393859719932.0,406244114267.0,419138170037.0,
		431922969658.0,445469269526.0,458980464739.0,473021728427.0,487265080872.0,
		502009831162.0,516671027500.0,532301511691.0,547745264024.0,563729400403.0,
		580021077269.0,596943922032.0,613637849785.0,631370608277.0,648961894630.0,
		667220813758.0,685714871809.0,704840505788.0,723743083123.0,743971748773.0,
		763849289728.0,784374137400.0,805292164913.0,826990106419.0,848270014935.0,
		870955112225.0,893323999969.0,916531037454.0,940013311161.0,964254968666.0,
		988095455934.0,1013681073621.0,1038701585293.0,1064490457153.0,1090767756309.0,
		1117999575185.0,1144524470274.0,1172940807413.0,1200793201984.0,1229664654753.0,
		1258859553852.0,1288942870826.0,1318387513476.0,1350106708851.0,1380953557714.0,
		1412701758231.0,1445029075410.0,1478524960499.0,1510958875124.0,1545828320944.0,
		1579836163663.0,1615031983526.0,1650633837255.0,1687251001646.0,1722891690230.0,
		1761486858603.0,1798766111141.0,1837122684330.0,1876161616738.0,1916578886834.0,
		1955488896527.0,1997460067515.0,2038221930609.0,2080345657442.0,2122955966320.0,
		2166736126621.0,2209078031438.0,2255178769870.0,2299438875159.0,2344926745263.0,
		2391244871134.0,2439106746306.0,2484958645953.0,2534634177388.0,2582611072160.0,
		2632168425298.0,2682240532609.0,2733670271933.0,2783112497050.0,2837230489025.0,
		2888894618068.0,2941853265128.0,2995891756016.0,3051660042958.0,3104767472734.0,
		3162563744311.0,3218043627736.0,3275360961764.0,3333263200931.0,3392656968354.0,
		3449444784169.0,3511896738853.0,3571211947622.0,3631923921246.0,3693898055143.0,
		3757825905571.0,3818254141801.0,3884452437395.0,3947620657441.0,4012808078894.0,
		4078742873607.0,4146170172081.0,4210356166513.0,4281312742666.0,4348322989890.0,
		4416813432768.0,4486725743338.0,4558885135807.0,4626589823897.0,4701213701031.0,
		4772014300423.0,4844958280949.0,4918849115624.0,4994281605507.0,5065673714659.0,
		5145105975532.0,5219536269565.0,5295578644667.0,5373344920669.0,5453514688706.0,
		5528246913032.0,5610999970646.0,5689151477642.0,5769568988105.0,5851111867550.0,
		5934254490733.0,6012292042386.0,6099910322075.0,6181431052782.0,6264592068298.0,
		6349759732538.0,6437387602738.0,6518605404688.0,6609104692930.0,6694023861862.0,
		6781347290998.0,6869903660528.0,6960163670762.0,7044284644899.0,7139478673018.0,
		7227404440045.0,7316810814354.0,7408733240002.0,7503189825320.0,7590006834188.0,
		7687565246744.0,7778336162162.0,7871781279129.0,7966558915539.0,8063070608706.0,
		8152313629219.0,8254072856976.0,8347448928924.0,8442213258782.0,8539941697070.0,
		8640260985672.0,8731525794812.0,8835086998813.0,8930692136652.0,9029073538144.0,
		9129051757175.0,9230514868224.0,9323655743181.0,9431032524071.0,9528624874319.0,
		9627541467692.0,9729582938813.0,9834542687305.0,9929010901383.0,10037310045015.0,
		10136466533218.0,10238206204546.0,10342052466732.0,10447184927543.0,10542845571487.0,
		10654367071745.0,10754527524991.0,10856119669793.0,10961192350924.0,11069237273424.0,
		11165324143296.0,11276689844631.0,11377814350682.0,11481521136048.0,11587600810974.0,
		11694795587395.0,11791070148199.0,11905123369078.0,12006389137900.0,12108836326696.0,
		12215320870394.0,12324524302623.0,12420590233220.0,12533317865124.0,12634647204290.0,
		12738539392373.0,12844872830026.0,12952292824908.0,13047534122481.0,13162279614437.0,
		13262806537088.0,13364048988137.0,13470096637547.0,13578701949772.0,13672822605512.0,
		13785062433603.0,13884447694348.0,13986448415800.0,14091375706435.0,14197063116408.0,
		14289470098497.0,14402524382274.0,14500464856817.0,14598610344677.0,14702235774738.0,
		14808161394645.0,14898138984629.0,15007846049060.0,15103572646163.0,15201747706926.0,
		15303220749815.0,15404705461344.0,15492258545920.0,15601800408027.0,15695140152123.0,
		15788048776972.0,15887120196515.0,15988240582641.0,16072427987913.0,16177257423656.0,
		16267433279899.0,16359231471443.0,16455345980112.0,16550787567251.0,16631516514241.0,
		16735379604141.0,16821852235896.0,16907559750347.0,17000200080433.0,17094311047979.0,
		17170856508279.0,17268373045095.0,17351075775171.0,17434561844994.0,17523495819082.0,
		17610718175193.0,17682576260188.0,17778509270020.0,17856543423617.0,17932844279958.0,
		18017260683356.0,18101991309513.0,18169029272129.0,18257437605605.0,18330908541606.0,
		18404171969867.0,18483597614848.0,18560547519883.0,18622177488599.0,18708088856467.0,
		18776019418998.0,18840595203226.0,18915117455253.0,18988685901231.0,19044738988397.0,
		19121993811936.0,19184242866101.0,19245385411842.0,19314123453900.0,19378879435276.0,
		19428640757488.0,19502292045565.0,19558681752552.0,19610214170344.0,19673190966726.0,
		19733928957693.0,19777199917400.0,19841493539362.0,19891419709963.0,19938762535043.0,
		19995428301771.0,20046012801256.0,20082948643503.0,20142842986187.0,20186355142454.0,
		20223282611715.0,20273184252759.0,20319489842495.0,20349166714775.0,20399149497983.0,
		20435682972965.0,20467601570064.0,20510883904024.0,20546380605786.0,20569365509148.0,
		20614222163192.0,20643586012014.0,20664734386288.0,20700923384813.0,20731611537875.0,
		20747154846528.0,20781045490645.0,20803343375820.0,20819238175741.0,20848351832523.0,
		20867747821352.0,20875695395860.0,20904703065485.0,20919560728771.0,20924315837214.0,
		20946019429972.0,20959919763426.0,20960701416945.0,20978172755770.0,20985828270435.0,
		20985035871687.0,20999156227635.0,21001980230919.0,20995098750152.0,
		21007393207290.0},
		{1.0,18.0,136.0,594.0,1862.0,5004.0,11961.0,25152.0,49233.0,91148.0,158022.0,263396.0,424729.0,
		659872.0,996898.0,1475800.0,2126005.0,3009464.0,4185955.0,5725742.0,7713704.0,10287216.0,
		13501720.0,17568030.0,22618115.0,28829554.0,36387113.0,45677638.0,56731291.0,70074188.0,
		85927084.0,104731654.0,126755371.0,152868836.0,182903101.0,218209818.0,258832918.0,
		305819850.0,359263695.0,421373482.0,490994720.0,571117292.0,661076271.0,763606684.0,
		877645197.0,1007933256.0,1151014354.0,1313826580.0,1492899691.0,1694565994.0,
		1914599798.0,2163801154.0,2432898894.0,2735827906.0,3063304890.0,3429904412.0,
		3823719022.0,4265782238.0,4735837798.0,5262757590.0,5824235657.0,6448344118.0,
		7109356761.0,7848839840.0,8625597496.0,9490682906.0,10400294971.0,11410126500.0,
		12466784433.0,13642540178.0,14863085962.0,16220903954.0,17633218457.0,19194155188.0,
		20809547184.0,22605980186.0,24452577859.0,26499473704.0,28605119754.0,30934778002.0,
		33322224843.0,35968569606.0,38662379514.0,41651032022.0,44697605786.0,48060636140.0,
		51472245177.0,55260892034.0,59084923308.0,63318476114.0,67591857293.0,72321573604.0,
		77080007851.0,82353425238.0,87629436661.0,93486183164.0,99347908204.0,105831065448.0,
		112292856298.0,119477153002.0,126610028422.0,134518103140.0,142364614975.0,
		151075753160.0,159690719441.0,169261785680.0,178682767289.0,189172493448.0,
		199496560041.0,210961815432.0,222199259001.0,234736497460.0,246993374871.0,
		260634789092.0,273945941002.0,288805025414.0,303256417384.0,319385904788.0,
		335022857841.0,352517818436.0,369458955207.0,388385407984.0,406637906202.0,
		427118962004.0,446836686817.0,468910699190.0,490099437157.0,513927001358.0,
		536731193060.0,562342159872.0,586805072708.0,614348266422.0,640599308951.0,
		670161979750.0,698216042997.0,729923308960.0,759994610194.0,793907456034.0,
		825944600015.0,862289692614.0,896524767864.0,935262614074.0,971726918902.0,
		1013116944360.0,1051941142391.0,1096069983198.0,1137281136811.0,1184255924272.0,
		1228171911029.0,1278100441208.0,1324539741489.0,1377730063242.0,1427060443375.0,
		1483371017432.0,1535616406719.0,1595447309878.0,1650685749166.0,1714124916964.0,
		1772463385810.0,1839561666488.0,1901416968083.0,1972358900524.0,2037334876507.0,
		2112565050500.0,2181259893174.0,2260416914202.0,2332816824107.0,2416533040742.0,
		2492652929007.0,2581016263878.0,2661039900079.0,2753964412124.0,2838454586684.0,
		2936301648524.0,3024543824988.0,3127895746092.0,3220805908396.0,3328950185040.0,
		3426508483238.0,3540448786830.0,3642473969169.0,3762259925764.0,3869098838833.0,
		3994471229652.0,4106886122003.0,4238425512146.0,4355192206031.0,4493627253642.0,
		4616206615615.0,4760368846098.0,4888633548867.0,5040002076576.0,5173465433800.0,
		5332132377466.0,5471437116783.0,5636754170214.0,5782861473455.0,5955729062556.0,
		6106807799089.0,6288206175808.0,6446355375326.0,6634380044138.0,6799347426485.0,
		6996281533710.0,7167158038525.0,7372976006286.0,7550777712879.0,7764303601210.0,
		7950367818323.0,8173050486108.0,8364544921211.0,8597556361500.0,8797477259721.0,
		9038081663100.0,9246068763455.0,9497436106682.0,9711917159744.0,9973899632866.0,
		10196568573485.0,10467306316232.0,10699790153514.0,10981394608642.0,11219544258642.0,
		11513623153732.0,11761722791800.0,12064194385472.0,12321597976802.0,12636829963992.0,
		12901281350630.0,13229077330872.0,13503007624072.0,13840446310166.0,14125760938216.0,
		14476074985326.0,14767104955419.0,15132154506054.0,15434655445693.0,15808650759746.0,
		16121966726550.0,16510966923306.0,16831554673397.0,17235105471844.0,17566364339751.0,
		17980481168878.0,18324910108944.0,18753940996960.0,19103641261791.0,19549756686846.0,
		19912793064865.0,20368250234338.0,20743459525948.0,21216219173694.0,21598516056663.0,
		22088144733780.0,22482424057578.0,22983156382422.0,23392325081223.0,23909989627442.0,
		24323894130612.0,24861246982042.0,25290188631487.0,25836759277132.0,26279105396468.0,
		26845736787618.0,27294692201683.0,27880513189698.0,28342563127787.0,28939485739764.0,
		29418489081079.0,30034568357352.0,30517072735389.0,31155367791072.0,31654543959727.0,
		32301880854144.0,32815780073482.0,33485832486568.0,34005179943166.0,34696493658862.0,
		35230390517732.0,35932713301492.0,36485446390069.0,37208878224500.0,37762976303981.0,
		38511754996368.0,39084378319478.0,39841226164988.0,40429610292380.0,41211623641510.0,
		41804219849483.0,42609868554530.0,43218089594556.0,44033735551022.0,44662396549044.0,
		45501806534240.0,46129358394477.0,46996839211412.0,47644376080100.0,48518093603902.0,
		49182879375015.0,50084591556772.0,50751412677177.0,51678750357308.0,52361802827004.0,
		53298246663264.0,54003635993996.0,54965930012454.0,55666588254973.0,56659498216538.0,
		57382304301114.0,58379134227992.0,59120149196547.0,60147437548962.0,60887228648896.0,
		61942772282702.0,62699740322535.0,63762418941222.0,64542960362685.0,65633049115264.0,
		66405294723775.0,67528962869228.0,68324967076399.0,69449201767432.0,70263670804956.0,
		71421488989306.0,72231244286019.0,73419284876688.0,74246430067604.0,75438310643814.0,
		76291469005988.0,77512875916762.0,78352530959968.0,79609686047486.0,80474033448139.0,
		81728548250432.0,82612090878171.0,83902860976864.0,84776756255868.0,86098871204622.0,
		86991316115360.0,88313971302442.0,89233793676116.0,90587053734674.0,91487068734748.0,
		92879400519596.0,93805529035929.0,95190333990502.0,96135495159436.0,97558318767650.0,
		98489432941671.0,99945453469538.0,100895212853457.0,102346758447746.0,
		103324468176732.0,104808978312600.0,105760248199620.0,107286179121388.0,
		108264384739814.0,109776236571960.0,110774292291539.0,112326615789664.0,
		113304625487246.0,114890751941380.0,115886481010103.0,117464077010604.0,
		118489236357476.0,120100675030752.0,121091106390696.0,122745151961172.0,
		123764576500140.0,125398317153752.0,126437501665399.0,128112990821846.0,
		129124029446562.0,130835438933566.0,131864418404243.0,133561162399868.0,
		134619687450561.0,136350248788974.0,137366867901764.0,139141973736634.0,
		140188328131571.0,141934760903298.0,142999438973390.0,144790735476420.0,
		145820428699541.0,147648053964682.0,148693933956442.0,150498993540206.0,
		151576574912004.0,153416260434794.0,154442615641784.0,156327887069716.0,
		157383577792876.0,159232975813220.0,160306617438111.0,162202217202590.0,
		163231860407357.0,165162613523038.0,166209552160240.0,168110628707556.0,
		169189485354381.0,171124488529084.0,172141064141442.0,174124238832316.0,
		175171023434964.0,177109540308768.0,178172500397101.0,180156569122436.0,
		181168401156172.0,183188209476482.0,184216326265676.0,186197232223676.0,
		187256392544381.0,189272534856010.0,190259537075385.0,192324572590484.0,
		193341254201796.0,195350210500336.0,196383827756153.0,198440293621284.0,
		199413554207307.0,201503538629354.0,202490364565469.0,204534834664902.0,
		205553480881838.0,207632497116826.0,208567602486480.0,210694342313312.0,
		211661000188927.0,213722168690570.0,214704423062177.0,216812227860060.0,
		217723281610912.0,219866121737950.0,220790260068956.0,222877764190976.0,
		223832714173407.0,225952088491776.0,226814949859023.0,228982910159184.0,
		229877664630414.0,231968460007734.0,232875072077533.0,235014807779262.0,
		235841681929104.0,238015004219058.0,238852693124989.0,240959831099444.0,
		241830445333156.0,243968463899032.0,244736397737415.0,246921615576596.0,
		247719316911469.0,249818778803292.0,250628647979770.0,252776926573794.0,
		253496084783959.0,255674048550074.0,256405205261344.0,258508525670714.0,
		259272294711230.0,261404089706206.0,262052704220001.0,264233193557522.0,
		264912751220188.0,266996958854180.0,267685726461461.0,269815750326608.0,
		270408247902640.0,272567049028560.0,273169702731470.0,275243016113168.0,
		275876257763817.0,277978865884060.0,278488204689340.0,280639046919006.0,
		281177741474051.0,283218897973568.0,283768426711396.0,285855931751084.0,
		286300533069163.0,288413420573740.0,288865420357221.0,290886530147718.0,
		291369391484786.0,293417369232636.0,293766317385850.0,295858737298890.0,
		296239973723035.0,298214524202550.0,298605586553727.0,300623452277908.0,
		300899349429269.0,302943106864338.0,303226669581725.0,305170120881174.0,
		305483743116032.0,307449178700744.0,307622908675259.0,309632997287328.0,
		309839403401083.0,311720485530438.0,311933122925130.0,313859817060298.0,
		313952193316319.0,315901687721824.0,315999508957046.0,317837871470772.0,
		317968985841165.0,319828521771372.0,319813574437798.0,321714588702656.0,
		321728871714954.0,323495703151176.0,323517308224387.0,325328065262984.0,
		325222012493912.0,327051059478864.0,326953585675266.0,328665113872974.0,
		328601078215119.0,330329850213118.0,330111176006519.0,331883040903020.0,
		331696230348009.0,333326047932664.0,333144326552119.0,334813826093932.0,
		334503527602628.0,336190096156154.0,335888104697329.0,337450315371090.0,
		337179217647398.0,338758791998524.0,338330238963514.0,339951720010406.0,
		339554099147310.0,341024055425652.0,340635692623965.0,342145161120802.0,
		341624359410294.0,343146903417554.0,342632061556411.0,344028125783582.0,
		343546667566924.0,344958994248178.0,344315715132553.0,345764085971068.0,
		345155705464399.0,346449493207508.0,345850862233879.0,347180979494178.0,
		346445644041350.0,347790375381878.0,347062689757094.0,348277115540722.0,
		347582078365373.0,348807009545580.0,347952677566396.0,349214698037034.0,
		348396327799037.0,349497529818922.0,348686793458558.0,349826579115682.0,
		348880251259541.0,350032557251554.0,349094109516155.0,350110468449828.0,
		349208398284764.0,350235317755496.0,349174373111790.0},
		{1.0,19.0,153.0,716.0,2382.0,6669.0,16597.0,36446.0,73740.0,140963.0,252497.0,432483.0,715652.0,
		1141067.0,1764643.0,2669784.0,3933551.0,5680746.0,8058167.0,11236152.0,15410887.0,20903452.0,
		27916056.0,36905562.0,48246481.0,62470722.0,79994722.0,101839813.0,128273573.0,160593726.0,
		199453444.0,246337439.0,301773238.0,368378339.0,446082210.0,538357235.0,645585103.0,
		771577590.0,916043160.0,1085801830.0,1278397891.0,1502343783.0,1755838721.0,2048766893.0,
		2376703313.0,2755449529.0,3175960827.0,3658378150.0,4193012107.0,4802695413.0,
		5472314676.0,6237219020.0,7071320455.0,8017962677.0,9048854918.0,10214954102.0,
		11474974964.0,12901265996.0,14433107296.0,16160089834.0,18013302629.0,20094128424.0,
		22311738084.0,24808212127.0,27454269869.0,30419841399.0,33560303412.0,37073508180.0,
		40771606220.0,44913832635.0,49252620779.0,54100589967.0,59175564475.0,64831123057.0,
		70718514187.0,77297993759.0,84115798256.0,91712192043.0,99578864717.0,108334784083.0,
		117358114241.0,127416888961.0,137737431004.0,149229183437.0,161012856529.0,
		174110406774.0,187475465190.0,202373718206.0,217519459681.0,234367730358.0,
		251481037073.0,270510685791.0,289760422650.0,311202650948.0,332806793832.0,
		356865890538.0,381083919267.0,408019519829.0,435029475483.0,465150021382.0,
		495249658848.0,528775493073.0,562238237133.0,599518871401.0,636601084156.0,
		677977634271.0,718978159240.0,764749359811.0,810059530957.0,860596728822.0,
		910461887962.0,966208916409.0,1021036172423.0,1082321681404.0,1142494179463.0,
		1209793790715.0,1275681498809.0,1349457503757.0,1421448013541.0,1502155587375.0,
		1580786874731.0,1668885878132.0,1754490804428.0,1850619771187.0,1943724962793.0,
		2048341416532.0,2149442130972.0,2263130300447.0,2372782727358.0,2496176400638.0,
		2614807831626.0,2748558188672.0,2876859946617.0,3021521195238.0,3160000809257.0,
		3316407442143.0,3465648707381.0,3634447058943.0,3795100218924.0,3976983700330.0,
		4149859461447.0,4345609198469.0,4531063394759.0,4741698494401.0,4940671987046.0,
		5166707126002.0,5379915093179.0,5622401343246.0,5850473476996.0,6110418128377.0,
		6354119230458.0,6632191039726.0,6892681284583.0,7189898316088.0,7467429035832.0,
		7785277156102.0,8080961794006.0,8419745613833.0,8734801820592.0,9095914666647.0,
		9430765215297.0,9815682002303.0,10171144102250.0,10580460074812.0,10958416474483.0,
		11393304488175.0,11793550852774.0,12256170511114.0,12680196965032.0,13170544035149.0,
		13620144848031.0,14139857795847.0,14614978916853.0,15166462492115.0,15668129474471.0,
		16251533002942.0,16782521985516.0,17399022437712.0,17958571538855.0,18611657972489.0,
		19201422294690.0,19890213053558.0,20512902838690.0,21239551795762.0,21894484491952.0,
		22662569228129.0,23350730844050.0,24159374537881.0,24885230238475.0,25736009897435.0,
		26497460528462.0,27395370439685.0,28194160023743.0,29137352966446.0,29977965527270.0,
		30968776415491.0,31849082802876.0,32892662916827.0,33813942107141.0,34908372656305.0,
		35877113896156.0,37023820491053.0,38035753163899.0,39242575657557.0,40299977575537.0,
		41562877329581.0,42672306427881.0,43993657705861.0,45151395124876.0,46539323950161.0,
		47746372331770.0,49196521188838.0,50462001452210.0,51976384467677.0,53293731748903.0,
		54883269761001.0,56254626459503.0,57912032866998.0,59347680149183.0,61076032474365.0,
		62569095645459.0,64379897684690.0,65930656019515.0,67817003723326.0,69439403437184.0,
		71402884731727.0,73085893461710.0,75141496235924.0,76888228233654.0,79025284775111.0,
		80850059440286.0,83071423595274.0,84962515517146.0,87285330375018.0,89243511808939.0,
		91656153042785.0,93700282280944.0,96203396299338.0,98318258849773.0,
		100933734162376.0,103121817086534.0,105832906625653.0,108113669031488.0,
		110924301250374.0,113281393126004.0,116214883839028.0,118647668824781.0,
		121685297681267.0,124221428710496.0,127364716800416.0,129981055600829.0,
		133258871107342.0,135956953372590.0,139346593289981.0,142154688705846.0,
		145659450637313.0,148552971309938.0,152203371348416.0,155182425719939.0,
		158953436475863.0,162054028102971.0,165945351938358.0,169134178161766.0,
		173186624346626.0,176466421004121.0,180646888879605.0,184054877730803.0,
		188364705889433.0,191868312808240.0,196350977602452.0,199948399043656.0,
		204567187206203.0,208304632604769.0,213060807535673.0,216895191229121.0,
		221840734444692.0,225773086034021.0,230861240255984.0,234943561813066.0,
		240177538561923.0,244364068341711.0,249798829686729.0,254083902007949.0,
		259672967296384.0,264120382597100.0,269862305028266.0,274412605278046.0,
		280372822256423.0,285029159606717.0,291148528787739.0,295977000633644.0,
		302256124689102.0,307193049085691.0,313707099985325.0,318748699857717.0,
		325432898987163.0,330658158943216.0,337507274555118.0,342843097158835.0,
		349944662483604.0,355391054762972.0,362665784072603.0,368304495402251.0,
		375755439747398.0,381508553890486.0,389228936372484.0,395087424645386.0,
		402989774145259.0,409059286666516.0,417140493993768.0,423323524727354.0,
		431691398113811.0,437983524294597.0,446541132415186.0,453051203273170.0,
		461798223821835.0,468422168869056.0,477471128467615.0,484203773249251.0,
		493449499126720.0,500418781014911.0,509852340266238.0,516931584748567.0,
		526692648178770.0,533880567455860.0,543843975092864.0,551272802047515.0,
		561431068177873.0,568976966762764.0,579478109924774.0,587128508544784.0,
		597834161360052.0,605742867607514.0,616649331035932.0,624666238677679.0,
		635940529547011.0,644058505976097.0,655538385508058.0,663927806583468.0,
		675612196344652.0,684114201199863.0,696178172447309.0,704771359162141.0,
		717053719730947.0,725933663108040.0,738421871875041.0,747399474973577.0,
		760290762272172.0,769365042683967.0,782470614121885.0,791843973134844.0,
		805153289266031.0,814623124183527.0,828359816651741.0,837910890413192.0,
		851870469664613.0,861732022643949.0,875892467528587.0,885845355077684.0,
		900453328017884.0,910489376348938.0,925309566567493.0,935663459176167.0,
		950693873309941.0,961134272441939.0,976634268695375.0,987133001603585.0,
		1002848320307381.0,1013692681860869.0,1029608327070515.0,1040527808589872.0,
		1056930024562266.0,1067902693018945.0,1084522007642440.0,1095843882160815.0,
		1112668802178495.0,1124052264415175.0,1141380026938149.0,1152808587414920.0,
		1170349507069665.0,1182150448807958.0,1199878382944453.0,1211722182730468.0,
		1229988828853764.0,1241865098055070.0,1260342862912077.0,1272587065474656.0,
		1291247568900041.0,1303539430336215.0,1322750134195550.0,1335057971296154.0,
		1354466006827732.0,1367163434762080.0,1386753167554757.0,1399468872416601.0,
		1419641214330962.0,1432351162093955.0,1452708267166414.0,1465824201106946.0,
		1486353910659831.0,1499485832955001.0,1520599709011327.0,1533700620622900.0,
		1555007640854280.0,1568528318174030.0,1589998228736887.0,1603497335573258.0,
		1625575890335674.0,1639043538979614.0,1661293918313432.0,1675193775469694.0,
		1697584666561879.0,1711449731266004.0,1734480714424743.0,1748277964897997.0,
		1771479298125542.0,1785714102427126.0,1809035793558337.0,1823222449877205.0,
		1847200795128602.0,1861314905218484.0,1885427745805550.0,1899980353846512.0,
		1924220414222016.0,1938702907722255.0,1963621810610603.0,1977980574292998.0,
		2003025185073060.0,2017859626975022.0,2042997374862554.0,2057739449616812.0,
		2083562254545758.0,2098163350744996.0,2124105488535589.0,2139177937409490.0,
		2165208852280594.0,2180150305601843.0,2206879388496086.0,2221663129876100.0,
		2248489134699232.0,2263772530385804.0,2290642910718489.0,2305759399001197.0,
		2333367559840234.0,2348297813204875.0,2375986732665905.0,2391397834989316.0,
		2419112462103784.0,2434361074732990.0,2462813599345547.0,2477845352878975.0,
		2506341417671100.0,2521872070712614.0,2550384998102667.0,2565702563828097.0,
		2594990926396297.0,2610046506572625.0,2639343320797079.0,2654923109607282.0,
		2684206139856382.0,2699563298843691.0,2729603662654639.0,2744660475783639.0,
		2774714108928946.0,2790298686544342.0,2820318879913645.0,2835614826253159.0,
		2866412005702119.0,2881406908859449.0,2912174243828037.0,2927709154853979.0,
		2958390668642883.0,2973615101931411.0,3005106760195885.0,3019974212478958.0,
		3051425420750206.0,3066826613638241.0,3098153742720379.0,3113224828231998.0,
		3145369427301846.0,3160072310474762.0,3192110373861470.0,3207344364286779.0,
		3239265770224910.0,3254129792528533.0,3286883218909532.0,3301307035466803.0,
		3333928672501224.0,3348929828205428.0,3381377623684598.0,3395984164005634.0,
		3429250978955065.0,3443385257289807.0,3476512023899476.0,3491207180225777.0,
		3524150087347059.0,3538389823017995.0,3572156004079678.0,3585909733072011.0,
		3619488610715616.0,3633838484897514.0,3667157599115278.0,3681006680768456.0,
		3715195327210534.0,3728519359976790.0,3762494564228116.0,3776372898819927.0,
		3810060799124238.0,3823444783452086.0,3857985659129943.0,3870814391953615.0,
		3905082386852979.0,3918480450074397.0,3952446459075249.0,3965290032669963.0,
		4000140194788443.0,4012363610177816.0,4046892075177000.0,4059724929444699.0,
		4093903876602312.0,4106167448325997.0,4141192426027727.0,4152791012046455.0,
		4187501326021002.0,4199701510323370.0,4234040558510924.0,4245588092702262.0,
		4280779485197889.0,4291675752550929.0,4326486334767037.0,4338002081177924.0,
		4372368184904805.0,4383208216501984.0,4418459672907434.0,4428579108459740.0,
		4463442801018689.0,4474155577947330.0,4508526839033581.0,4518558209958511.0,
		4553810156891497.0,4563114539663057.0,4597882469187122.0,4607780385348278.0,
		4642066940086857.0,4651235581847145.0,4686415110707154.0,4694778369014137.0,
		4729440590885007.0,4738446333502077.0,4772562206127010.0,4780819828903665.0,
		4815791874079433.0,4823214678140890.0,4857671941718252.0,4865714735024594.0,
		4899610922117159.0,4906836670651445.0,4941578744417201.0,4947976664178565.0,
		4982147459864842.0,4989206260422632.0,5022722781366243.0,5028919307131658.0,
		5063337781192229.0,5068659241994812.0,5102482593642595.0,5108413757001044.0,
		5141559440324343.0,5146650703291219.0,5180656194414006.0,5184864712409000.0,
		5218196242474478.0,5223026584038838.0,5255679523928123.0,5259617670132495.0,
		5293159899772307.0,5296137595325681.0,5328962444601912.0,5332610399428372.0,
		5364703662271707.0,5367457945505998.0,5400386308321151.0,5402149559414795.0,
		5434373483888046.0,5436796381178260.0,5468271751560209.0,5469719865517279.0,
		5502027116285867.0,5502522038504049.0,5534056031913726.0,5535231617962721.0,
		5565942985051388.0,5566123756479629.0,5597705226521272.0,5596877915519230.0,
		5627692229060715.0,5627501605853619.0,5657444085165624.0,5656289299923529.0,
		5687078548086944.0,5684926383671250.0,5714850331660774.0,5713345440213916.0,
		5742426171951309.0,5739905254479653.0,5769849213942037.0,5766256690734781.0,
		5795309865086594.0,5792424898850149.0,5820579546508816.0,5816684671194755.0,
		5845639590547018.0,5840664648132235.0,5868745370268928.0,5864454179295095.0,
		5891639090089400.0,5886278162716357.0,5914249431311248.0,5907840493774972.0,
		5934891599825222.0,5929202445645354.0,5955269953353661.0,5948492571832983.0,
		5975407627968599.0,5967545133923135.0,5993527369510328.0,5986340037948580.0,
		6011319777739654.0,6003089576398656.0,6028870827298203.0,6019584068146502.0,
		6044357388090003.0,6035744464095871.0,6059547823505765.0,6049855483294864.0,
		6074487247515710.0,6063672061555587.0,6087274973516615.0,6077197973971855.0,
		6099780483509010.0,6088651202976531.0,6111990631181024.0,6099736422375190.0,
		6122084124791527.0,6110555714786801.0,6131889733794399.0,6119240549576962.0,
		6141331687469746.0,6127614787316686.0,6148663138218140.0,6135704280915708.0,
		6155678511912170.0,6141597618548324.0,6162366293225920.0,6147197171521768.0,
		6166940727689198.0,6152478740402618.0,6171127294452895.0,6155613404287202.0,
		6175021412702829.0,6158442355678605.0,6176755064503856.0,6160895307644946.0,
		6178164702913999.0,6161221834366245.0,6179276762966832.0},
		{1.0,20.0,171.0,854.0,3011.0,8790.0,22729.0,52016.0,108848.0,214558.0,396731.0,698286.0,1185202.0,
		1937816.0,3067720.0,4740760.0,7140013.0,10517196.0,15211505.0,21606626.0,30177652.0,
		41608106.0,56535422.0,75901868.0,100784847.0,132437306.0,172134967.0,222091440.0,
		283744524.0,359832020.0,452811930.0,566186792.0,702408366.0,867285950.0,1063147915.0,
		1297143816.0,1573382192.0,1900374206.0,2281375324.0,2730823332.0,3250033343.0,
		3855863150.0,4552663167.0,5361184190.0,6281347113.0,7345760596.0,8549265348.0,
		9930718836.0,11487726556.0,13265618944.0,15252544577.0,17518853918.0,20038003737.0,
		22891231544.0,26055048258.0,29627170012.0,33559622415.0,37993354708.0,42853340409.0,
		48305034714.0,54270080701.0,60938669872.0,68189938771.0,76296893582.0,85079635310.0,
		94849408348.0,105416361378.0,117149878080.0,129773701619.0,143781370404.0,
		158802495688.0,175414549038.0,193205288205.0,212836572650.0,233759018769.0,
		256857743330.0,281405660653.0,308408617104.0,337069087057.0,368566459422.0,
		401859051991.0,438432625094.0,476987772218.0,519256531752.0,563761058744.0,
		612478263580.0,663573961696.0,719542427914.0,778114441175.0,842107540906.0,
		908983155179.0,982024445220.0,1058112264940.0,1141188746966.0,1227532594047.0,
		1321711181770.0,1419458086727.0,1525956965700.0,1636174844234.0,1756324499054.0,
		1880431463916.0,2015500551056.0,2154789194577.0,2306402155620.0,2462382657186.0,
		2632070431784.0,2806290692324.0,2995792103358.0,3190053756232.0,3401178279854.0,
		3617151466567.0,3851936523416.0,4091702891475.0,4352163279226.0,4617617433019.0,
		4906096831808.0,5199636987173.0,5518342966000.0,5842074307468.0,6193792212148.0,
		6550346874066.0,6937476012878.0,7329398724864.0,7754937016220.0,8185059193834.0,
		8652078078630.0,9122981962891.0,9634571125984.0,10150026901365.0,10709257263556.0,
		11271776931916.0,11882946616800.0,12496191377096.0,13162224939520.0,13830080240745.0,
		14555118371976.0,15281042870084.0,16069703431452.0,16857099979629.0,17713171348094.0,
		18567829420652.0,19495272097834.0,20419693135593.0,21425213720058.0,22424427514861.0,
		23510971616010.0,24590778467601.0,25763888751658.0,26928127062121.0,28194833649648.0,
		29447701080100.0,30812007872842.0,32162278458367.0,33629259796472.0,35078865713922.0,
		36658646487666.0,38214070456321.0,39908818350316.0,41578977936515.0,43396060874620.0,
		45184354660782.0,47134276293736.0,49045539072151.0,51131887954774.0,53179702045476.0,
		55408530648064.0,57592725347826.0,59979286530216.0,62308459162197.0,64852921953338.0,
		67340306481836.0,70052031471042.0,72699283216687.0,75594236516272.0,78407079783858.0,
		81486935021642.0,84485678611200.0,87757160749448.0,90937986661211.0,94424414163160.0,
		97797896264640.0,101494996553746.0,105080947185903.0,109000760350614.0,
		112797449715191.0,116963697374550.0,120977181207364.0,125387100009530.0,
		129648226878087.0,134309913026578.0,138807533405621.0,143755155335060.0,
		148502306154053.0,153724655183354.0,158751277126743.0,164263022467782.0,
		169560757813710.0,175396409038550.0,180971835167750.0,187122105124688.0,
		193020433281607.0,199493562801648.0,205692034143808.0,212539083390524.0,
		219054075047271.0,226251338906488.0,233126759665980.0,240691770431694.0,
		247909285171869.0,255893330174376.0,263459100442698.0,271840445951122.0,
		279819308013044.0,288607719504280.0,296960697082870.0,306228932299852.0,
		314975505805569.0,324681478795800.0,333885986664799.0,344051518335112.0,
		353679284153270.0,364377581529344.0,374432889024686.0,385625712211214.0,
		396203076224732.0,407898921354730.0,418933351523166.0,431235114939418.0,
		442751658037427.0,455592108743156.0,467681798529772.0,481086811687026.0,
		493689908841879.0,507763895385608.0,520884921357647.0,535563363833784.0,
		549333344501667.0,564623079388716.0,578944787304698.0,594990524654440.0,
		609892031971956.0,626589727608174.0,642197799407786.0,659579555117868.0,
		675803145007864.0,694013863757074.0,710852722440720.0,729789628787808.0,
		747428422462595.0,767098903684156.0,785391193682242.0,805992637925402.0,
		824971153651867.0,846351702636802.0,866192674683495.0,888389700276100.0,
		908955899903572.0,932165000714158.0,953455262214184.0,977528632325962.0,
		999790128507978.0,1024729175559316.0,1047752100365130.0,1073827525612906.0,
		1097652732849795.0,1124645678002394.0,1149511720862391.0,1177462074308764.0,
		1203173349367797.0,1232350361556896.0,1258898602242386.0,1289086595552600.0,
		1316800879648214.0,1348002658899150.0,1376593206445615.0,1409164090492620.0,
		1438677841498968.0,1472311821388486.0,1503070969290928.0,1537819344992940.0,
		1569549671582474.0,1605763792739372.0,1638444122842953.0,1675832031339972.0,
		1709902219827063.0,1748456720378710.0,1783520014635108.0,1823706750491892.0,
		1859821097515379.0,1901227595671516.0,1938815653784294.0,1981498311450118.0,
		2020180294862485.0,2064607097439772.0,2104360216571193.0,2150126481287946.0,
		2191515299794972.0,2238604351640448.0,2281108754842761.0,2330128252357370.0,
		2373811797405224.0,2424212217991238.0,2469615348804221.0,2521465790789224.0,
		2568093718434287.0,2621993694360178.0,2669803719357634.0,2725211554197036.0,
		2774941686926318.0,2831834372985226.0,2882792772161507.0,2941946027873076.0,
		2994202634404588.0,3054904667211132.0,3109162803574630.0,3171491122945982.0,
		3227090455645136.0,3291798061178158.0,3348696055259538.0,3415088368785792.0,
		3474210043725197.0,3542245895703960.0,3602699197135938.0,3673364936213314.0,
		3735234135785273.0,3807612153379702.0,3871781806985391.0,3945949261036648.0,
		4011584886075606.0,4088509379254620.0,4155536667049817.0,4234310120230462.0,
		4303887235225899.0,4384468533091906.0,4455471359800900.0,4539085755559052.0,
		4611609825499696.0,4697076609797680.0,4772236991390156.0,4859665407405638.0,
		4936393737959885.0,5026974052051242.0,5105166295220413.0,5197775319900344.0,
		5278875717250864.0,5373435054067736.0,5456031830164196.0,5554049121273732.0,
		5638263989138599.0,5738282728811910.0,5825492822222016.0,5927615598076974.0,
		6016462533310842.0,6122186012076892.0,6212559403903855.0,6320460129983662.0,
		6414122945645949.0,6524097527512686.0,6619312948604427.0,6733216090425302.0,
		6830119760849287.0,6946139200107382.0,7046397574624363.0,7164676978314214.0,
		7266643374556055.0,7388981732830958.0,7492489757428199.0,7617128804341632.0,
		7724353390970855.0,7851174453770540.0,7959975384499584.0,8091224773491086.0,
		8201727248588629.0,8335203291304168.0,8449469413169406.0,8585322283795706.0,
		8701311058111103.0,8841703153755418.0,8959254866136277.0,9102053072884096.0,
		9223750676731521.0,9368803286925886.0,9492040867205504.0,9642069400518968.0,
		9767024618882621.0,9919358793537210.0,10048472177247427.0,10203243500098834.0,
		10334097323110517.0,10493935808737440.0,10626300330654621.0,10788615073267012.0,
		10925574849637271.0,11090195426187088.0,11228637672407237.0,11398801025089398.0,
		11538908300044780.0,11711379023455906.0,11856107481141054.0,12031090748568494.0,
		12177496187347966.0,12358067976494550.0,12505872509860544.0,12688985276797666.0,
		12841865265918465.0,13027290224094658.0,13181540694841283.0,13373054057859808.0,
		13528905193734646.0,13722728964238868.0,13883652039355675.0,14079972959185186.0,
		14242452645804086.0,14444970727259342.0,14608695457837976.0,14813742092139446.0,
		14983027661220599.0,15190306388052474.0,15360819611534109.0,15574815855913580.0,
		15746809225861623.0,15963014326032414.0,16140498508034269.0,16359203184056504.0,
		16538104299648691.0,16763576648064886.0,16943504063990832.0,17171432748638828.0,
		17357445622762874.0,17587505057157482.0,17774528871322956.0,18011911680159978.0,
		18200174912922076.0,18439687737867968.0,18633947807367709.0,18875844948937024.0,
		19071271428127566.0,19320502031334736.0,19516720437655759.0,19768302620590258.0,
		19971138509550823.0,20224680132284470.0,20428169914391737.0,20689702876424480.0,
		20894202370231839.0,21157677004055842.0,21368612098271910.0,21634283734038838.0,
		21846177974454386.0,22119775373887456.0,22332104775067962.0,22607863009773016.0,
		22827290443993810.0,23104807020925482.0,23324554001934085.0,23610742617182142.0,
		23831118359180259.0,24118925620888174.0,24346279134869865.0,24636079517158066.0,
		24864030393644124.0,25162342956342818.0,25390290779450279.0,25690542089564080.0,
		25926129438404149.0,26227844858229556.0,26463282883910829.0,26774254168724662.0,
		27009991532082772.0,27322304233623332.0,27565461598252308.0,27879425967467760.0,
		28122721923360799.0,28445856072777768.0,28688666742941184.0,29013439522051180.0,
		29264421919916740.0,29590175815403124.0,29840534108103525.0,30176243615651942.0,
		30426434002267364.0,30763017138493658.0,31021055825855952.0,31359020916221246.0,
		31616696599826118.0,31964406191407524.0,32221004955630114.0,32569894897087766.0,
		32835247452979509.0,33184698832664610.0,33448873432759820.0,33808849956366890.0,
		34072219631987361.0,34432669631416954.0,34704381629922804.0,35065749848868914.0,
		35336512016719149.0,35708171473437782.0,35977242735704237.0,36349618799183252.0,
		36627994033463709.0,37000339945309356.0,37276768150364451.0,37660377054386338.0,
		37935463128253399.0,38318924106188322.0,38602736415931562.0,38986533461348778.0,
		39268834360342751.0,39663503165350518.0,39943411150187281.0,40338253102810832.0,
		40627852955671854.0,41022087583620636.0,41309057922035496.0,41715176095979872.0,
		42000041628868856.0,42405289477329348.0,42699462657698168.0,43104434358954048.0,
		43396363057446473.0,43812723537858774.0,44101369339705797.0,44517339766276686.0,
		44816249312287963.0,45230958348658888.0,45526308090404775.0,45953382255979378.0,
		46245996821011054.0,46671505993725094.0,46973828433270626.0,47398351589853778.0,
		47697609109033119.0,48134078091396058.0,48429200411542340.0,48864608759516676.0,
		49170437149014264.0,49603658100524066.0,49905176816529723.0,50351448138169772.0,
		50649344906783731.0,51093145192788700.0,51401080493020828.0,51843253678908682.0,
		52147304390210664.0,52601943699551202.0,52900935325976619.0,53353560928574412.0,
		53663812375998634.0,54113470675668946.0,54418463961080705.0,54881627683616318.0,
		55182043293538853.0,55642027847964524.0,55952860208409573.0,56410359567901796.0,
		56716384281425068.0,57186684405611122.0,57486746967112610.0,57954284900096954.0,
		58266143348770216.0,58729640709809112.0,59035079086078656.0,59512759922707480.0,
		59812747973988216.0,60286266117308466.0,60597006164753677.0,61067103743069048.0,
		61372150739235639.0,61855482707677672.0,62153581339133094.0,62633172256576890.0,
		62943340253777788.0,63418069431028132.0,63720916096698274.0,64210235483467630.0,
		64506549167480622.0,64990594961602362.0,65298149380450154.0,65777860171190766.0,
		66078778916966441.0,66572118344744444.0,66864795849374184.0,67353542038008434.0,
		67658825072901636.0,68141661388187656.0,68438430281326568.0,68936189910451678.0,
		69225662810421422.0,69717069315551040.0,70018068472607384.0,70504126524770648.0,
		70797343803264857.0,71297472733626264.0,71581472539142471.0,72076101252918938.0,
		72372930334703796.0,72860365350531316.0,73147783088245554.0,73650624384347354.0,
		73929689768712289.0,74425042619172864.0,74715885153796325.0,75204926692915628.0,
		75486991447638893.0,75990454049289176.0,76262114081150410.0,76758836957601890.0,
		77043928009722742.0,77532516415428706.0,77807000762444251.0,78311214236326226.0,
		78576205976286733.0,79071974983889332.0,79349059950926229.0,79837533600191644.0,
		80104834930481954.0,80607713678645688.0,80863634398209501.0,81358858139125384.0,
		81628569114055224.0,82114383036569576.0,82372268383702466.0,82874307845463584.0,
		83121672010167122.0,83614072376863858.0,83873770552919883.0,84357638054210532.0,
		84606673461837255.0,85105303124496056.0,85341982927134332.0,85831698902748752.0,
		86082273469489082.0,86561685428681206.0,86799449480897455.0,87295308012940342.0,
		87521515222656269.0,88006532389585028.0,88245402550928690.0,88720866996011842.0,
		88948158172194540.0,89438453817125304.0,89652100067203613.0,90132672878831008.0,
		90360746898310653.0,90829778902745726.0,91043845815663589.0,91529425247886996.0,
		91731180322313989.0,92204831754671354.0,92419550720882386.0,92882629454059398.0,
		93084503841424597.0,93562693163680334.0,93750077615084891.0,94217522928558976.0,
		94419478615505628.0,94874135791462630.0,95061434061070281.0,95532793017965828.0,
		95706812217610602.0,96165112817323070.0,96352120461106881.0,96798989757442218.0,
		96972438864451780.0,97434641426697024.0,97592425402960647.0,98042605886488478.0,
		98215518327515878.0,98651962689414424.0,98809231201782356.0,99262487338913732.0,
		99405562389177165.0,99844800749606120.0,100001119782946584.0,100428022853323956.0,
		100569851997947918.0,101011864739299200.0,101137450627086936.0,
		101566733719063220.0,101707593841466296.0,102121954729836916.0,
		102246193874372976.0,102677687891630680.0,102787002835261663.0,
		103203568214028322.0,103326348370210955.0,103729318727937546.0,
		103837031152064419.0,104255318202827496.0,104346018381648115.0,
		104750502193434690.0,104856570939786514.0,105245565272712388.0,
		105334237807479229.0,105740365273181870.0,105813404101389860.0,
		106203456792694670.0,106290326544772929.0,106666124469748032.0,
		106737425956620595.0,107128279084417804.0,107181588879440278.0,
		107558133834815944.0,107627163648067820.0,107987300420085054.0,
		108038248444713057.0,108415458724873260.0,108450289488819583.0,
		108810651967551964.0,108859571862449566.0,109204806036547880.0,
		109237316236910349.0,109597873242166312.0,109612102120908290.0,
		109957469431045186.0,109987446973927619.0,110315490261431510.0,
		110327106452579011.0,110672268697544550.0,110667379267308847.0,
		110994994869265498.0,111003985631111310.0,111315976375090102.0,
		111308316067152205.0,111635580322434230.0,111609000667019195.0,
		111920283719298400.0,111910061263441011.0,112203334893346012.0,
		112174279165631796.0,112484582099056442.0,112438432660574150.0,
		112730742721740888.0,112698842709497383.0,112975129846758120.0,
		112926003531683569.0,113217155848464874.0,113149127803089366.0,
		113423890416862068.0,113372323634661142.0,113628506089508762.0,
		113557737698820216.0,113830989092961994.0,113742956671687766.0,
		113997800102708526.0,113924059273489690.0,114162099979666078.0,
		114071270935114907.0,114324351995605798.0,114214292416221704.0,
		114450372888024436.0,114356789548572244.0,114574129567796884.0,
		114461264465168135.0,114695656084747784.0,114565451786419314.0,
		114780664513243176.0,114665073422877828.0,114863370267898598.0,
		114730636328767852.0,114943653520636338.0,114791482194641429.0,
		114987615516509750.0,114852039967330610.0,115029080618986086.0,
		114874174886796117.0,115067900060947974.0,114895874704190560.0,
		115070379762887386.0,114913276077265202.0},
		{1.0,21.0,190.0,1009.0,3764.0,11464.0,30758.0,73211.0,158483.0,321852.0,613687.0,1109961.0,
		1931498.0,3236409.0,5243357.0,8275086.0,12730734.0,19125847.0,28192471.0,40781504.0,
		57986725.0,81263558.0,112287133.0,153090114.0,206417896.0,275195488.0,363002279.0,
		474583100.0,614842885.0,789699171.0,1006752293.0,1274072046.0,1600573542.0,1998603653.0,
		2479571608.0,3058234866.0,3751672086.0,4578362836.0,5557263137.0,6716715283.0,
		8078980080.0,9675473837.0,11540009826.0,13711931905.0,16224791245.0,19136395249.0,
		22485527171.0,26336075528.0,30745199374.0,35787430279.0,41519066300.0,48050816613.0,
		55441395969.0,63806011604.0,73238214408.0,83874493127.0,95795403270.0,109193540029.0,
		124156711785.0,140887750475.0,159521427839.0,180281964544.0,203288884761.0,
		228868861925.0,257130789409.0,288399289737.0,322872649410.0,360922115946.0,
		402691423461.0,448688617732.0,499059804089.0,554330404214.0,614741850444.0,
		680860692688.0,752869358151.0,831577222179.0,917107746877.0,1010252573471.0,
		1111323915890.0,1221216669384.0,1340072718939.0,1469085079647.0,1608372476222.0,
		1759174578351.0,1921752294697.0,2097430566634.0,2286314152245.0,2490233873754.0,
		2709118645560.0,2944766746065.0,3197415872893.0,3469115197866.0,3759683025313.0,
		4071741147580.0,4405024468380.0,4762295930325.0,5143403354313.0,5551312162776.0,
		5985562367803.0,6450043530888.0,6943848116129.0,7470891016877.0,8030657595921.0,
		8627658729035.0,9260500080421.0,9934614056581.0,10648462900827.0,11407876259290.0,
		12211180369482.0,13064684362381.0,13966166722662.0,14923445997675.0,15933391414783.0,
		17004073394113.0,18132676079708.0,19328518744166.0,20587179524043.0,21919233831282.0,
		23320189075607.0,24801590510584.0,26357910184256.0,28001835285581.0,29727065143737.0,
		31548447629365.0,33458125572086.0,35471614146319.0,37580930594840.0,39804085426282.0,
		42130513427326.0,44579540051846.0,47140777340005.0,49835727442881.0,52650921104303.0,
		55610380966907.0,58699843930053.0,61945721961443.0,65331462282896.0,68885087881793.0,
		72588704739933.0,76475170665594.0,80522477425452.0,84764085510824.0,89179191519308.0,
		93805745276114.0,98615711038756.0,103651795872982.0,108885889275029.0,
		114362330080358.0,120050182186313.0,125997410595048.0,132168459115229.0,
		138620287489908.0,145311494199784.0,152297454254958.0,159540363690278.0,
		167103560497168.0,174934508892046.0,183105456555337.0,191565884438377.0,
		200386985929463.0,209514857200178.0,219028024652532.0,228861671393470.0,
		239110746823858.0,249702849592762.0,260725228634200.0,272114139679721.0,
		283971043761645.0,296204430737377.0,308931784232751.0,322067289712597.0,
		335721141868397.0,349804554793875.0,364442148660790.0,379522948463443.0,
		395198725505407.0,411349749276759.0,428108772449675.0,445374451775596.0,
		463303846037882.0,481744700701337.0,500882418223464.0,520577599832978.0,
		540996459081842.0,561999406645336.0,583776999558089.0,606148268812312.0,
		629348420461369.0,653188827372636.0,677865837907374.0,703222704439377.0,
		729497198868086.0,756445305003613.0,784353016362872.0,813002237608045.0,
		842636197925879.0,873043014582821.0,904506541206713.0,936744156931963.0,
		970111108382406.0,1004317753009489.0,1039648460194851.0,1075868604811042.0,
		1113330808762452.0,1151657067391482.0,1191276191379915.0,1231857646033004.0,
		1273749360713190.0,1316640625260903.0,1360946471399215.0,1406234317807431.0,
		1453030409904083.0,1500901876576260.0,1550254860473272.0,1600746677002143.0,
		1652887037457502.0,1706108637080394.0,1761038703763827.0,1817192641074687.0,
		1875058997800861.0,1934189562467979.0,1995179701471776.0,2057385244216918.0,
		2121573378046827.0,2187112214970939.0,2254566955374027.0,2323450864440824.0,
		2394485564654086.0,2466844102402505.0,2541426355616171.0,2617534477471511.0,
		2695842319369185.0,2775716592391763.0,2858000967179177.0,2941759417106124.0,
		3028080877444538.0,3116067636609827.0,3206491568273537.0,3298680325904430.0,
		3393636501691632.0,3490177076222312.0,3589569320882189.0,3690828714211107.0,
		3794874211361966.0,3900832623480498.0,4009867491120767.0,4120651707827874.0,
		4234702456289793.0,4350776830852830.0,4469909584533746.0,4591183512966576.0,
		4715971399847803.0,4842613543813778.0,4972867995263022.0,5105377601274681.0,
		5241363371607641.0,5379647199333815.0,5521804424875682.0,5666004528457935.0,
		5814319524825632.0,5965051221953709.0,6119569814393978.0,6276644298810994.0,
		6438132272738615.0,6601750749233813.0,6769887995300245.0,6940708064293321.0,
		7115804361785143.0,7293629597942539.0,7476282305205544.0,7661267335996990.0,
		7851374188859245.0,8044325490297196.0,8241914304704295.0,8442517966526361.0,
		8648597795602843.0,8857073016736372.0,9071132234174390.0,9288347206553444.0,
		9510774853147871.0,9736389152601441.0,9967952736324876.0,10202119695072887.0,
		10442605616657566.0,10686399851388583.0,10935801052399867.0,11188712889346095.0,
		11448342512159742.0,11710613824587499.0,11979728076243172.0,12252497978095396.0,
		12531547099659311.0,12814259253190293.0,13104249291176029.0,13397089467111871.0,
		13697637938329401.0,14001980224933869.0,14313024444881505.0,14628111573282398.0,
		14951376496981960.0,15277477045773343.0,15611880752848231.0,15950450424252339.0,
		16296527931201600.0,16646771480541226.0,17005821626913029.0,17367909318842593.0,
		17739312255610257.0,18115021400555497.0,18498674935072593.0,18886913813294263.0,
		19285017978217285.0,19686061212082598.0,20097110384737473.0,20512867136789128.0,
		20937500150340835.0,21366793750166771.0,21806647285166577.0,22249661591179822.0,
		22703858277772797.0,23162853199876040.0,23631186730806396.0,24104631948952065.0,
		24589898653079859.0,25078121677108468.0,25578286464509818.0,26083688489209506.0,
		26599475609292885.0,27120436072177657.0,27653980570821743.0,28190670431221469.0,
		28740675826491518.0,29295932786254422.0,29862095307391210.0,30433895003948391.0,
		31019747084316720.0,31608415133155693.0,32211205283439252.0,32819770616790624.0,
		33440418512460467.0,34066690364683136.0,34707835648770596.0,35351947476602171.0,
		36011828304463206.0,36677385991444032.0,37355553881893534.0,38039839710061945.0,
		38740676983748315.0,39444033465259773.0,40164025213395185.0,40890255128813309.0,
		41630418277447878.0,42376569531083640.0,43140223308730043.0,43906486114477550.0,
		44691257265799455.0,45482065185349816.0,46287310283528895.0,47099120487316908.0,
		47930344021649893.0,48763528558731676.0,49616150505461439.0,50475367986341510.0,
		51350599069942675.0,52232123844508863.0,53134055478986271.0,54037985782627092.0,
		54963470275925664.0,55895287166013288.0,56843558705033484.0,57798733084976256.0,
		58776510850193921.0,59755349212152263.0,60756821289245126.0,61765187796448585.0,
		62791772951310983.0,63824811261246837.0,64881481151487339.0,65939291177564586.0,
		67022084281982265.0,68111345749177087.0,69219211824170504.0,70334140989317413.0,
		71475283855852749.0,72616319413476020.0,73783483382805238.0,74957668229844732.0,
		76152405102335237.0,77353663828631347.0,78582179923601247.0,79810560656602197.0,
		81067747597864236.0,82331304392988123.0,83615815302135162.0,84907459723721931.0,
		86229260637157686.0,87549349113093092.0,88899350855184451.0,90256452210311608.0,
		91636652913064554.0,93023171633530835.0,94440932289850829.0,95856808840953485.0,
		97305771763309485.0,98760859326171219.0,100239363259460884.0,101724836360607717.0,
		103244725919464801.0,104760927682001450.0,106311294301715405.0,
		107868543964026129.0,109451548894742840.0,111040406466771875.0,
		112664956880161759.0,114285456452280965.0,115943669189218383.0,
		117607497734172913.0,119297220076162654.0,120993612320841678.0,
		122729222462894506.0,124458554053149079.0,126226623865152671.0,
		128001048638832882.0,129804150134294608.0,131612426044208177.0,
		133461149695131726.0,135303128049511720.0,137187756524841168.0,
		139077297201681278.0,140995432884312658.0,142919588009198411.0,
		144888120726886184.0,146847077221745401.0,148849918286719353.0,
		150858412873415670.0,152898480394380186.0,154942719773337927.0,
		157032451723651416.0,159112259786391843.0,161240181230780507.0,
		163371942945285550.0,165535026456325819.0,167703011240570711.0,
		169921131715670660.0,172125855825929355.0,174379865507260263.0,
		176638441148317122.0,178931538789338632.0,181227592898650186.0,
		183574672288514683.0,185907898490892537.0,188295063985989597.0,
		190684488027298437.0,193108152984635083.0,195535494134132600.0,
		198019002484324564.0,200484477754642744.0,203004908880292592.0,
		205528662983744946.0,208090076482643076.0,210652676547552728.0,
		213272256587599137.0,215873164259734971.0,218534401784865351.0,
		221196110838714419.0,223894876732396969.0,226595613659793383.0,
		229358761117036432.0,232098784228256432.0,234899947049916026.0,
		237702614917178152.0,240546074275430356.0,243388385267349570.0,
		246294167575008705.0,249175863363912501.0,252124606677052615.0,
		255071512877379366.0,258058036716872500.0,261044680553246870.0,
		264100618338590961.0,267127282357409900.0,270221526435716706.0,
		273314964455304449.0,276452538253805212.0,279586341907206631.0,
		282790293953752646.0,285963893995782474.0,289211360463208291.0,
		292454475415390689.0,295740056693522119.0,299023266968349960.0,
		302382843226814175.0,305705976636328851.0,309103743859688739.0,
		312498158277157412.0,315939779674171438.0,319374556660475464.0,
		322886235231472355.0,326360662157671973.0,329916423903627738.0,
		333464653168837418.0,337057929098511864.0,340645623861657342.0,
		344317544228389133.0,347945219010573832.0,351654538097915353.0,
		355357475164789021.0,359110335777774873.0,362853084665752280.0,
		366680001554787934.0,370461825201130083.0,374332611834926715.0,
		378191834200486290.0,382098934317641237.0,385997117946187146.0,
		389987351146614428.0,393924465798469985.0,397950362903983918.0,
		401966721053448701.0,406035830656105897.0,410090839334734630.0,
		414237416016145781.0,418329818145674739.0,422519365832952053.0,
		426693397944217786.0,430917573187711398.0,435128832109024021.0,
		439439938629436796.0,443688587091259863.0,448033637030706656.0,
		452365179996135134.0,456752150180105725.0,461120151707614160.0,
		465587632202788429.0,469991424403349745.0,474500494402902464.0,
		478989357456639436.0,483529962446423714.0,488053859608887901.0,
		492685930223019577.0,497244871500244982.0,501907840358726523.0,
		506552606635072349.0,511255574570093257.0,515934621213494208.0,
		520721032312928280.0,525433175222078177.0,530258337572091365.0,
		535058697281456156.0,539912585094334460.0,544745044582852558.0,
		549693929659119669.0,554557938152788972.0,559534157913426777.0,
		564487384057528989.0,569500949869567822.0,574485059727787603.0,
		579583913843575158.0,584597588866440025.0,589732843473214350.0,
		594837811627893352.0,599997357482679292.0,605130003984562807.0,
		610387958867413198.0,615548877606459927.0,620829690751663159.0,
		626082388645123691.0,631396687120794896.0,636675971782007018.0,
		642078037732435535.0,647382813677875352.0,652817395894298380.0,
		658215230407750403.0,663669152514781916.0,669090848846019775.0,
		674646105451179960.0,680091237682041292.0,685663403506184541.0,
		691202517871598560.0,696804541344822320.0,702365465304206760.0,
		708056777030894413.0,713637286827226158.0,719356528719704926.0,
		725032865532994436.0,730765687224387713.0,736460255501083637.0,
		742296320659360578.0,748009061199235571.0,753856334349279906.0,
		759664861999181789.0,765536953764202210.0,771360790833991112.0,
		777323074295169927.0,783161439769188923.0,789146628107780990.0,
		795082036568599274.0,801073230084347604.0,807020746504052895.0,
		813118063284824870.0,819077551648916436.0,825178924282696169.0,
		831234888649014553.0,837355104340460795.0,843420468130166578.0,
		849631605702464116.0,855704653744496645.0,861931684631887223.0,
		868102968246344303.0,874329443340573392.0,880505783704672584.0,
		886839714273652371.0,893020241133410208.0,899350292759137775.0,
		905628850701305595.0,911971495860439434.0,918252100344853308.0,
		924684524804306251.0,930965250006046311.0,937407679061535301.0,
		943787379832554638.0,950220576765470936.0,956596737834847584.0,
		963138779499214023.0,969512021311746566.0,976041516057496938.0,
		982513037569616817.0,989046856567641321.0,995512189204991442.0,
		1002136257308050553.0,1008593929510470860.0,1015219960431815683.0,
		1021775611700363399.0,1028383378881597472.0,1034927942731722338.0,
		1041645298044080870.0,1048178303607642320.0,1054872860062116669.0,
		1061503725629505055.0,1068195517913411018.0,1074811676396999307.0,
		1081592373574889358.0,1088190828386820573.0,1094965288378452342.0,
		1101662628976429002.0,1108408892982492783.0,1115085609063633415.0,
		1121940703722467974.0,1128596661335521299.0,1135419711824772266.0,
		1142173229125951993.0,1148984881941809088.0,1155712815680653218.0,
		1162611623012649277.0,1169313565106715890.0,1176197457747748825.0,
		1182997038387109329.0,1189841179309131234.0,1196610603768057039.0,
		1203564133730089168.0,1210303098381302171.0,1217213655705864700.0,
		1224047897251963877.0,1230937691003997595.0,1237737622794518233.0,
		1244712970877917105.0,1251476280088889916.0,1258425815668490375.0,
		1265285589461195454.0,1272185490227050452.0,1279004888366460898.0,
		1286013338407756363.0,1292790995673347407.0,1299744828691956716.0,
		1306617304994702709.0,1313541019743783828.0,1320368340040675370.0,
		1327373591806685151.0,1334153900085899678.0,1341124978650536260.0,
		1347999983685291411.0,1354909376694523059.0,1361732107005130217.0,
		1368748830910829692.0,1375520219826091952.0,1382470967025320324.0,
		1389335266369726103.0,1396244064286330877.0,1403052106362862464.0,
		1410040978468824788.0,1416791353852892584.0,1423735218578633830.0,
		1430576925377968894.0,1437447471379321253.0,1444226852464719305.0,
		1451203312742073632.0,1457920156018244663.0,1464817063734410652.0,
		1471624373883919817.0,1478470390743795983.0,1485210884745163080.0,
		1492132933183101856.0,1498802934282670984.0,1505669525960836554.0,
		1512429850728233346.0,1519211057522288033.0,1525897593611052109.0,
		1532781625583100459.0,1539393957085636839.0,1546187432749684194.0,
		1552888132475463757.0,1559619679601314782.0,1566240468007268330.0,
		1573044549394505700.0,1579585404926156421.0,1586323158673829164.0,
		1592951076216158961.0,1599589684275979499.0,1606132422036922240.0,
		1612873017444925707.0,1619330700955894010.0,1625968333778646061.0,
		1632509562014472847.0,1639074235072787317.0,1645525904794055812.0,
		1652159564559786996.0,1658519368379560526.0,1665074434932150601.0,
		1671518720152086789.0,1677963510205991050.0,1684311390803992448.0,
		1690855487145279968.0,1697105296539084075.0,1703533867296052564.0,
		1709866063436252679.0,1716211666852325047.0,1722442207379401533.0,
		1728850769889861181.0,1734978393454897757.0,1741299232429147863.0,
		1747508377548995775.0,1753706535914504066.0,1759806740327244473.0,
		1766101161269070010.0,1772093605102108908.0,1778260949891164445.0,
		1784332212787620708.0,1790403930908756899.0,1796362609974966606.0,
		1802495276553705928.0,1808339994811231348.0,1814373763052835680.0,
		1820295230188351267.0,1826194330301531948.0,1831997515830097658.0,
		1837990665722516534.0,1843675205054945973.0,1849527159435252093.0,
		1855287092664801132.0,1861035133265667409.0,1866672128764967636.0,
		1872476276600297251.0,1877986983698515863.0,1883682419670701897.0,
		1889268003353778344.0,1894817427286416646.0,1900274019012710600.0,
		1905912764947724120.0,1911240031209238506.0,1916728322695131884.0,
		1922128682046776140.0,1927502151837392739.0,1932767155544804104.0,
		1938192782212758070.0,1943323223236188440.0,1948630595850939534.0,
		1953832498289245193.0,1958981386135738164.0,1964043869989168867.0,
		1969280924416565367.0,1974204810704585342.0,1979280232262221854.0,
		1984271880100407960.0,1989223309605225717.0,1994072339629979579.0,
		1999071883011831710.0,2003776112112382196.0,2008646407575764991.0,
		2013418999336627436.0,2018122250349781746.0,2022746862917573328.0,
		2027535540933166103.0,2032009803147739067.0,2036626597875704357.0,
		2041167901062560656.0,2045652371201365001.0,2050041381338489646.0,
		2054568354168019368.0,2058804214493264792.0,2063195071591109912.0,
		2067496579290653947.0,2071710677200696038.0,2075853626930796652.0,
		2080150246083353127.0,2084136686155292841.0,2088253288762898171.0,
		2092303045298593396.0,2096276977058324054.0,2100166607972025176.0,
		2104181585282306822.0,2107910319905406719.0,2111781241986299216.0,
		2115571310304439289.0,2119256446640216799.0,2122882205620254348.0,
		2126648252335340043.0,2130109422069461060.0,2133684956942572288.0,
		2137207171223685868.0,2140635516502779319.0,2143990400722562050.0,
		2147455865363639630.0,2150640957586012105.0,2153955669302210070.0,
		2157201585968954168.0,2160323777309125001.0,2163398821395910367.0,
		2166597013040131526.0,2169500616111512535.0,2172503710551564334.0,
		2175466680283015846.0,2178315711368530853.0,2181103293689756418.0,
		2183987239283064520.0,2186600668107871757.0,2189328398891660526.0,
		2192000304078222230.0,2194526982408461492.0,2197022222585637049.0,
		2199625559235406068.0,2201944914207439143.0,2204346291428461119.0,
		2206720729772585961.0,2208963167369271195.0,2211159407642714713.0,
		2213434736474108901.0,2215451708327482278.0,2217564531844427311.0,
		2219637759919487089.0,2221546426138786435.0,2223439399328275787.0,
		2225422703614981901.0,2227132901175895885.0,2228909998098501519.0,
		2230676608136800809.0,2232290849579522579.0,2233874617642698345.0,
		2235518014871545783.0,2236918830119931708.0,2238398236424142216.0,
		2239854828224847059.0,2241126290540288761.0,2242396700531614626.0,
		2243741462577896956.0,2244828475089666448.0,2245964359941574716.0,
		2247105982578510426.0,2248074223911880824.0,2249030920169255194.0,
		2250028882852216548.0,2250800412258050111.0,2251631952108446930.0,
		2252456132781266967.0,2253077054090870083.0,2253715652519808958.0,
		2254410257864528929.0,2254862480272501688.0,2255343837567443024.0,
		2255850433736791930.0,2256164913113768153.0,2256485510267024143.0,
		2256828831902121348.0,2256961328932287467.0,2257136647230667004.0,
		2257323403728064042.0,2257287926517768227.0}};

	/**
	 * Spearman exact cumulative distribution function for n <= 22. For n > 22,
	 * cumulative_as89 is invoked. Taken from pspearman package.
	 * @param is
	 * @param n
	 * @param lower_tail
	 * @return
	 */
	public static final double cumulative(double is, int n, boolean lower_tail)
	{
		if (n > spearmanArray.length)
			return cumulative_as89(is, n, lower_tail);
		int m = n * (n * n - 1) / 6 + 1;
		double[]
			freq = new double[m],
			g = spearmanArray[n - 1];
		int l = g.length;
		System.arraycopy(g, 0, freq, 0, l);
		for (int i = 0; i < l; i++)
			freq[m - i - 1] = g[i];
		if (!lower_tail)
			is = n * (n * n - 1) / 3 - is;
		int k = ((int) is) / 2 + 1;
		double sumk = 0, sum;
		for (int i = 0; i < k; i++)
			sumk += freq[i];
		sum = sumk;
		for (int i = k; i < m; i++)
			sum += freq[i];
		return sumk / sum;
	}

	/**
	 * Spearman cumulative distribution. (taken from src/library/stats/src/prho.c)
	 * Algorithm AS89 -- actually an approximation
	 * @param is
	 * @param n
	 * @param lower_tail
	 * @return
	 */
	public static final double cumulative_as89(double is, int n, boolean lower_tail)
	{
		final double
		c1 = .2274,
		c2 = .2531,
		c3 = .1745,
		c4 = .0758,
		c5 = .1033,
		c6 = .3932,
		c7 = .0879,
		c8 = .0151,
		c9 = .0072,
		c10= .0831,
		c11= .0131,
		c12= 4.6e-4;
		final int n_small = 9;

		/* Local variables */
		double b, u, x, y, n3;/*, js */
		int l[] = new int[n_small];
		int nfac, i, m, mt, ifr, ise, n1;
		double pv = lower_tail ? 0. : 1.;

		if (is <= 0)
			return pv;
		n3 = n;
		n3 *= (n3 * n3 - 1.) / 3.;/* = (n^3 - n)/3 */
		if (is > n3)
			return 1 - pv;

		if (n <= n_small) { /* 2 <= n <= n_small :
		 * Exact evaluation of probability */
			nfac = 1;
			for (i = 1; i <= n; ++i) {
				nfac *= i;
				l[i - 1] = i;
			}
			/* KH mod next line: was `!=' in the code but `.eq.' in the paper */
			if (is == n3) {
				ifr = 1;
			}
			else {
				ifr = 0;
				for (m = 0; m < nfac; ++m) {
					ise = 0;
					for (i = 0; i < n; ++i) {
						n1 = i + 1 - l[i];
						ise += n1 * n1;
					}
					if (is <= ise)
						++ifr;

					n1 = n;
					do {
						mt = l[0];
						for (i = 1; i < n1; ++i)
							l[i - 1] = l[i];
						--n1;
						l[n1] = mt;
					} while (mt == n1+1 && n1 > 1);
				}
			}
			pv = (lower_tail ? nfac-ifr : ifr) / (double) nfac;
		} /* exact for n <= n_small */
		else { /* n >= n_small : Evaluation by Edgeworth series expansion */
			y = (double) (n);
			b = 1 / y;
			x = (6. * (is - 1) * b / (y * y - 1) - 1) * sqrt(y - 1);
			/* = rho * sqrt(n-1)  ==  rho / sqrt(var(rho))  ~  (0,1) */
			y = x * x;
			u = x * b * (c1 + b * (c2 + c3 * b) +
					y * (-c4 + b * (c5 + c6 * b) -
							y * b * (c7 + c8 * b -
									y * (c9 - c10 * b + y * b * (c11 - c12 * y))
									)));
			y = u / exp(y / 2.);
			pv = (lower_tail ? -y : y) + Normal.cumulative(x, 0., 1., lower_tail, /*log_p = */false);
			/* above was call to alnorm() [algorithm AS 66] */
			if (pv < 0) pv = 0.;
			if (pv > 1) pv = 1.;
		}
		return pv;
	}

	/**
	 * Spearman cumulative distribution function, approximation using T (df=n-2)
	 * @param is
	 * @param n
	 * @param lower_tail
	 * @return
	 */
	public static final double cumulative_t(double is, int n, boolean lower_tail)
	{
		double r = 1 - (6.0 / n) * (is / (n * n - 1.0));
		return T.cumulative(r / sqrt((1 - r * r) / (n - 2.0)), n-2, !lower_tail, false);
	}
}
