/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.fromcatalina;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuffer _buffer = new StringBuffer();
    protected Writer _writer = null;
    protected Map<String, String> _namespaces;
    protected boolean _isRootElement = true;

    public XMLWriter(Map<String, String> namespaces) {
        this._namespaces = namespaces;
    }

    public XMLWriter(Writer writer, Map<String, String> namespaces) {
        this._writer = writer;
        this._namespaces = namespaces;
    }

    public String toString() {
        return this._buffer.toString();
    }

    public void writeProperty(String name, String value) {
        this.writeElement(name, 0);
        this._buffer.append(value);
        this.writeElement(name, 1);
    }

    public void writeProperty(String name) {
        this.writeElement(name, 2);
    }

    public void writeElement(String name, int type) {
        int pos;
        StringBuffer nsdecl = new StringBuffer();
        if (this._isRootElement) {
            for (String fullName : this._namespaces.keySet()) {
                String abbrev = this._namespaces.get(fullName);
                nsdecl.append(" xmlns:").append(abbrev).append("=\"").append(fullName).append("\"");
            }
            this._isRootElement = false;
        }
        if ((pos = name.lastIndexOf(58)) >= 0) {
            String fullns = name.substring(0, pos);
            String prefix = this._namespaces.get(fullns);
            if (prefix == null) {
                name = name.substring(pos + 1);
                nsdecl.append(" xmlns=\"").append(fullns).append("\"");
            } else {
                name = prefix + ":" + name.substring(pos + 1);
            }
        } else {
            throw new IllegalArgumentException("All XML elements must have a namespace");
        }
        switch (type) {
            case 0: {
                this._buffer.append("<" + name + nsdecl + ">");
                break;
            }
            case 1: {
                this._buffer.append("</" + name + ">\n");
                break;
            }
            default: {
                this._buffer.append("<" + name + nsdecl + "/>");
            }
        }
    }

    public void writeText(String text) {
        this._buffer.append(text);
    }

    public void writeData(String data) {
        this._buffer.append("<![CDATA[" + data + "]]>");
    }

    public void writeXMLHeader() {
        this._buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this._writer != null) {
            this._writer.write(this._buffer.toString());
            this._writer.flush();
            this._buffer = new StringBuffer();
        }
    }
}

