/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.freetts.en.us;

import com.sun.speech.freetts.Age;
import com.sun.speech.freetts.Gender;
import com.sun.speech.freetts.ValidationException;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceDirectory;
import com.sun.speech.freetts.en.us.CMULexicon;
import com.sun.speech.freetts.util.Utilities;
import de.dfki.lt.freetts.en.us.MbrolaVoice;
import de.dfki.lt.freetts.en.us.MbrolaVoiceValidator;
import java.util.ArrayList;
import java.util.Locale;

public class MbrolaVoiceDirectory
extends VoiceDirectory {
    public Voice[] getVoices() {
        String base = Utilities.getProperty("mbrola.base", null);
        if (base == null || base.trim().length() == 0) {
            System.out.println("System property \"mbrola.base\" is undefined.  Will not use MBROLA voices.");
            return new Voice[0];
        }
        CMULexicon lexicon = new CMULexicon("cmulex");
        MbrolaVoice mbrola1 = new MbrolaVoice("us1", "us1", 150.0f, 180.0f, 22.0f, "mbrola_us1", Gender.FEMALE, Age.YOUNGER_ADULT, "MBROLA Voice us1", Locale.US, "general", "mbrola", lexicon);
        MbrolaVoice mbrola2 = new MbrolaVoice("us2", "us2", 150.0f, 115.0f, 12.0f, "mbrola_us2", Gender.MALE, Age.YOUNGER_ADULT, "MBROLA Voice us2", Locale.US, "general", "mbrola", lexicon);
        MbrolaVoice mbrola3 = new MbrolaVoice("us3", "us3", 150.0f, 125.0f, 12.0f, "mbrola_us3", Gender.MALE, Age.YOUNGER_ADULT, "MBROLA Voice us3", Locale.US, "general", "mbrola", lexicon);
        Voice[] voices = new Voice[]{mbrola1, mbrola2, mbrola3};
        ArrayList<Voice> validVoices = new ArrayList<Voice>();
        int count = 0;
        for (int i = 0; i < voices.length; ++i) {
            MbrolaVoiceValidator validator = new MbrolaVoiceValidator((MbrolaVoice)voices[i]);
            try {
                validator.validate();
                validVoices.add(voices[i]);
                ++count;
                continue;
            }
            catch (ValidationException ve) {
                // empty catch block
            }
        }
        if (count == 0) {
            System.err.println("\nCould not validate any MBROLA voices at\n\n  " + base + "\n");
            if (base.indexOf(126) != -1) {
                System.err.println("DO NOT USE ~ as part of the path name\nto specify the mbrola.base property.");
            }
            System.err.println("Make sure you FULLY specify the path to\nthe MBROLA directory using the mbrola.base\nsystem property.\n");
            return new Voice[0];
        }
        return validVoices.toArray(new Voice[count]);
    }

    public static void main(String[] args) {
        System.out.println(new MbrolaVoiceDirectory().toString());
    }
}

