/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.websockets.jsr.WebsocketClientSslProvider;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Endpoint;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class DefaultWebSocketClientSslProvider
implements WebsocketClientSslProvider {
    public static final String SSL_CONTEXT = "io.undertow.websocket.SSL_CONTEXT";
    private static final ThreadLocal<SSLContext> LOCAL_SSL_CONTEXT = new ThreadLocal();

    @Override
    public XnioSsl getSsl(XnioWorker worker, Class<?> annotatedEndpoint, URI uri) {
        return this.getThreadLocalSsl(worker);
    }

    @Override
    public XnioSsl getSsl(XnioWorker worker, Object annotatedEndpointInstance, URI uri) {
        return this.getThreadLocalSsl(worker);
    }

    @Override
    public XnioSsl getSsl(XnioWorker worker, Endpoint endpoint, ClientEndpointConfig cec, URI uri) {
        XnioSsl ssl = this.getThreadLocalSsl(worker);
        if (ssl != null) {
            return ssl;
        }
        SSLContext sslContext = (SSLContext)cec.getUserProperties().get(SSL_CONTEXT);
        if (sslContext != null) {
            return new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, sslContext);
        }
        return null;
    }

    public static void setSslContext(SSLContext context) {
        LOCAL_SSL_CONTEXT.set(context);
    }

    private XnioSsl getThreadLocalSsl(XnioWorker worker) {
        SSLContext val = LOCAL_SSL_CONTEXT.get();
        if (val != null) {
            LOCAL_SSL_CONTEXT.remove();
            return new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, val);
        }
        return null;
    }
}

