/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParseMojoSupport;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class I18nParseXmlMojoSupport
extends I18nParseMojoSupport {
    String rules;
    private XPathFactory factory;
    private DocumentBuilderFactory documentBuilderFactory;
    @Parameter
    String[] userRulesFiles;
    @Parameter
    Map<String, String> namespaces;

    protected abstract String getCoreRuleFile();

    protected abstract XmlFileParser newXmlFileParser(File var1, XPath var2, DocumentBuilder var3);

    private List<String> getRuleFiles() {
        String[] userFiles;
        ArrayList<String> result = new ArrayList<String>();
        String s = this.getCoreRuleFile();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            result.add(s);
        }
        if ((userFiles = this.getUserRuleFiles()) != null) {
            for (String f : userFiles) {
                if (StringUtils.isEmpty((CharSequence)f)) continue;
                result.add(f);
            }
        }
        return result;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.factory = XPathFactory.newInstance();
        List<String> files = this.getRuleFiles();
        if (files.isEmpty()) {
            throw new MojoFailureException("No rules files defined, fill the coreRulesFile or userRulesFiles parameters");
        }
        this.rules = this.loadRules(files);
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(false);
        this.documentBuilderFactory.setCoalescing(false);
        this.documentBuilderFactory.setIgnoringComments(true);
    }

    private String[] getUserRuleFiles() {
        return this.userRulesFiles;
    }

    @Override
    public final FileParser newFileParser(File basedir, Pattern acceptPattern) {
        DocumentBuilder builder;
        try {
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(String.format("could not load DocumentBuilder for reason %s", ex.getMessage()), ex);
        }
        XPath xpath = this.factory.newXPath();
        return this.newXmlFileParser(basedir, xpath, builder);
    }

    private String loadRules(List<String> files) {
        ArrayList<String> rules = new ArrayList<String>();
        boolean verbose = !this.isSilent() && this.isVerbose();
        for (String file : files) {
            this.getLog().info((CharSequence)String.format("Load rules file %s", file));
            try {
                String fileRules = this.loadRulesFile(file);
                rules.add(fileRules);
                if (!verbose) continue;
                this.getLog().info((CharSequence)String.format("Rules for file [%s] : %s", file, fileRules));
            }
            catch (IOException e) {
                throw new ParserException(e);
            }
        }
        String result = StringUtils.join(rules, (String)" | ");
        if (verbose) {
            this.getLog().info((CharSequence)String.format("Loaded rules : %s", result));
        }
        return result;
    }

    private String loadRulesFile(String fileRules) throws IOException {
        Object classLoader;
        InputStream inputStream;
        File f = new File(fileRules);
        if (f.exists()) {
            try {
                inputStream = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParserException(e);
            }
        } else {
            classLoader = this.getClass().getClassLoader();
            inputStream = ((ClassLoader)classLoader).getResourceAsStream(fileRules);
        }
        if (inputStream == null) {
            throw new ParserException("could not found file of rules : " + fileRules);
        }
        inputStream = new BufferedInputStream(inputStream);
        try {
            classLoader = this.readInputStream(inputStream);
            return classLoader;
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        finally {
            inputStream.close();
        }
    }

    private String readInputStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                sb.append(" ").append(line);
            }
        }
        String txt = sb.toString().trim();
        txt = txt.replaceAll("\\s+", " | ");
        txt = txt.replaceAll("(^ \\| )|( \\| $)", "");
        return txt;
    }

    public static abstract class XmlFileParser
    extends AbstractFileParser {
        private final XPath xpath;
        private final String rules;
        private final DocumentBuilder builder;
        private final Map<String, String> namespaces;
        private final Map<String, String> namespaces2;
        private final boolean verbose;

        public abstract String extract(File var1, String var2);

        XmlFileParser(Log log, String encoding, Pattern acceptKeyPattern, String rules, XPath xpath, DocumentBuilder builder, Map<String, String> namespaces, boolean verbose) {
            super(log, encoding, acceptKeyPattern);
            this.xpath = xpath;
            this.rules = rules;
            this.builder = builder;
            this.verbose = verbose;
            if (namespaces != null && !namespaces.isEmpty()) {
                this.namespaces = namespaces;
                this.namespaces2 = new TreeMap<String, String>();
                for (Map.Entry<String, String> e : namespaces.entrySet()) {
                    this.namespaces2.put(e.getValue(), e.getKey());
                }
                NamespaceContext ctx = new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String prefix) {
                        return (String)namespaces.get(prefix);
                    }

                    @Override
                    public String getPrefix(String namespaceURI) {
                        return (String)namespaces2.get(namespaceURI);
                    }

                    public Iterator<?> getPrefixes(String namespaceURI) {
                        return null;
                    }
                };
                xpath.setNamespaceContext(ctx);
            } else {
                this.namespaces2 = null;
                this.namespaces = null;
            }
        }

        @Override
        public File prepareFile(File file) throws IOException {
            return file;
        }

        @Override
        public void parseFile(File file) throws IOException {
            File fileToProcess = this.prepareFile(file);
            if (fileToProcess == null) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Skip file %s", file));
                }
                return;
            }
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Start parsing file %s", fileToProcess));
                }
                Document doc = this.fileToDocument(fileToProcess);
                XPathExpression expression = this.xpath.compile(this.rules);
                NodeList list = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Detected nodes [%s] : %d", file, list.getLength()));
                }
                for (int index = 0; index < list.getLength(); ++index) {
                    Node node = list.item(index);
                    this.parseLine(fileToProcess, node.getTextContent());
                }
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
        }

        @Override
        public void parseLine(File file, String key) throws IOException {
            if ((key = this.extract(file, key)) != null) {
                this.registerKey(file, key);
            }
        }

        protected Document fileToDocument(File fileToProcess) throws SAXException, IOException {
            return this.builder.parse(fileToProcess.getAbsolutePath());
        }
    }
}

