/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="check-i18n-artifacts", defaultPhase=LifecyclePhase.INITIALIZE)
@Execute(goal="collect-i18n-artifacts")
public class CheckI18nArtifactsMojo
extends AbstractI18nBundleMojo {
    @Parameter(property="i18n.checkConvergence", defaultValue="true")
    private boolean checkConvergence;
    @Parameter(property="i18n.checkIntegrity", defaultValue="true")
    private boolean checkIntegrity;

    @Override
    public void init() throws Exception {
        super.init();
        this.createDirectoryIfNecessary(this.collectDirectory);
    }

    protected void doAction() throws Exception {
        Cloneable keys;
        HashMultimap allKeysByLocale = HashMultimap.create();
        LinkedHashMap<Locale, Integer> bundlesCount = new LinkedHashMap<Locale, Integer>();
        for (Locale locale : this.locales) {
            keys = new TreeMap();
            URL[] urls = this.getCollectI18nResources(locale);
            bundlesCount.put(locale, urls.length);
            for (URL url : urls) {
                Properties p = new Properties();
                Throwable throwable = null;
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), this.charset);){
                    p.load(reader);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                for (Map.Entry entry : p.entrySet()) {
                    String key = (String)entry.getKey();
                    keys.putIfAbsent(key, new I18nKey(locale, key));
                    I18nKey i18nKey = (I18nKey)keys.get(key);
                    i18nKey.addTranslation(url.toString(), (String)entry.getValue());
                    allKeysByLocale.put((Object)locale, (Object)key);
                }
            }
            if (this.checkConvergence) {
                this.getLog().info((CharSequence)String.format("Checking convergence for locale %s", locale));
            }
            if (this.checkConvergence && keys.values().stream().anyMatch(I18nKey::isNotValid)) {
                StringBuilder builder = new StringBuilder();
                Set badI18nKeys = keys.values().stream().filter(I18nKey::isNotValid).collect(Collectors.toSet());
                for (I18nKey i18nKey : badI18nKeys) {
                    builder.append("\n").append(i18nKey.getKey());
                    for (Map.Entry<String, String> entry : i18nKey.getTranslations().entrySet()) {
                        String string = entry.getKey();
                        String translation = entry.getValue();
                        builder.append(String.format("\n\tbundle %s:\n\t\t%s", string, translation));
                    }
                }
                throw new MojoExecutionException(String.format("For locale %s, there is %d divergent i18n key(s):%s", locale, badI18nKeys.size(), builder.toString()));
            }
            this.getLog().info((CharSequence)String.format("%d bundle(s) converge - %d translation(s)", urls.length, keys.size()));
        }
        if (this.checkIntegrity) {
            HashSet allKeys = new HashSet(allKeysByLocale.values());
            for (Map.Entry entry : allKeysByLocale.asMap().entrySet()) {
                Locale locale;
                locale = (Locale)entry.getKey();
                this.getLog().info((CharSequence)String.format("Checking integrity for locale %s", locale));
                keys = new TreeSet(allKeys);
                keys.removeAll((Collection)entry.getValue());
                if (!keys.isEmpty()) {
                    throw new MojoExecutionException(String.format("For locale %s, there is missing %d key(s):\n%s", locale, keys.size(), Joiner.on((String)"\n").join((Iterable)((Object)keys))));
                }
                this.getLog().info((CharSequence)String.format("%d bundle(s) are upstanding - %d translation(s)", bundlesCount.get(locale), allKeys.size()));
            }
        }
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        return PluginHelper.getLinesAsURL((File)file);
    }

    public static class I18nKey {
        private final Locale locale;
        private final String key;
        private final Map<String, String> translations;

        I18nKey(Locale locale, String key) {
            this.locale = locale;
            this.key = key;
            this.translations = new TreeMap<String, String>();
        }

        void addTranslation(String bundle, String translation) {
            this.translations.put(bundle, translation);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getKey() {
            return this.key;
        }

        boolean isValid() {
            return new HashSet<String>(this.translations.values()).size() == 1;
        }

        boolean isNotValid() {
            return !this.isValid();
        }

        public Map<String, String> getTranslations() {
            return this.translations;
        }
    }
}

