/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.Renderable;
import io.sundr.model.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class For
implements Statement {
    private final List<Expression> init;
    private final Expression compare;
    private final List<Expression> update;
    private final Statement body;

    public For(List<Expression> init, Expression compare, List<Expression> update, Statement body) {
        this.init = init;
        this.compare = compare;
        this.update = update;
        this.body = body;
    }

    public For(Expression init, Expression compare, Expression update, Statement body) {
        this.init = Arrays.asList(init);
        this.compare = compare;
        this.update = Arrays.asList(update);
        this.body = body;
    }

    public List<Expression> getInit() {
        return this.init;
    }

    public Expression getCompare() {
        return this.compare;
    }

    public List<Expression> getUpdate() {
        return this.update;
    }

    public Statement getBody() {
        return this.body;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("for").append(" ").append("(");
        sb.append(this.init.stream().map(e -> e.render()).map(Renderable::noSemicolon).collect(Collectors.joining(",")));
        sb.append(";");
        sb.append(this.compare.render());
        sb.append(";");
        sb.append(this.update.stream().map(e -> e.render()).collect(Collectors.joining(",")));
        sb.append(")");
        sb.append(" ").append("{").append("\n");
        sb.append(this.tab(this.body.renderStatement()));
        sb.append("}").append("\n");
        return sb.toString();
    }
}

