/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Property;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Declare
implements ExpressionOrStatement {
    private final List<Property> properties;
    private final Optional<Expression> value;

    public Declare(List<Property> properties, Optional<Expression> value) {
        this.properties = properties;
        this.value = value;
    }

    public Declare(Property property, Expression expression) {
        this(Arrays.asList(property), Optional.of(expression));
    }

    public Declare(Property property, Object value, Object ... rest) {
        this(Arrays.asList(property), Optional.of(ValueRef.from(value, rest)));
    }

    public Declare(Property property, Property valueProperty) {
        this(Arrays.asList(property), Optional.of(valueProperty.toReference()));
    }

    public Declare(Property property) {
        this.properties = Arrays.asList(property);
        this.value = Optional.empty();
    }

    public Declare(Class type, String name) {
        this.properties = Arrays.asList(Property.newProperty(ClassRef.forName(type.getName()), name));
        this.value = Optional.empty();
    }

    public Declare(Class type, String name, Object value) {
        this.properties = Arrays.asList(Property.newProperty(ClassRef.forClass(type), name));
        this.value = Optional.of(ValueRef.from(value, new Object[0]));
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        TypeRef typeRef = this.properties.get(0).getTypeRef();
        sb.append(typeRef.render());
        sb.append(" ");
        sb.append(this.properties.stream().map(Property::getName).collect(Collectors.joining(", ")));
        sb.append(this.value.map(v -> " = " + v.render()).orElse(""));
        sb.append(";");
        return sb.toString();
    }
}

