/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Order(value=-2147483648)
public class PropertyDiscriminatorBasedInheritancePlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public PropertyDiscriminatorBasedInheritancePlugin(TypeResolver typeResolver, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor) {
        this.typeResolver = typeResolver;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
    }

    public void apply(ModelContext context) {
        List<ModelReference> modelRefs = this.modelRefs(context);
        if (!modelRefs.isEmpty()) {
            context.getBuilder().discriminator(this.discriminator(context)).subTypes(modelRefs);
        }
    }

    private List<ModelReference> modelRefs(ModelContext context) {
        JsonSubTypes subTypes = (JsonSubTypes)AnnotationUtils.getAnnotation(this.forClass(context), JsonSubTypes.class);
        ArrayList<ModelReference> modelRefs = new ArrayList<ModelReference>();
        if (subTypes != null) {
            for (JsonSubTypes.Type each : subTypes.value()) {
                modelRefs.add(ResolvedTypes.modelRefFactory(context, this.enumTypeDeterminer, this.typeNameExtractor).apply(this.typeResolver.resolve((Type)each.value(), new Type[0])));
            }
        }
        return modelRefs;
    }

    private String discriminator(ModelContext context) {
        JsonTypeInfo typeInfo = (JsonTypeInfo)AnnotationUtils.getAnnotation(this.forClass(context), JsonTypeInfo.class);
        if (typeInfo != null && typeInfo.use() == JsonTypeInfo.Id.NAME && typeInfo.include() == JsonTypeInfo.As.PROPERTY) {
            return Optional.ofNullable(typeInfo.property()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(typeInfo.use().getDefaultPropertyName());
        }
        return "";
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve((Type)context.getType(), new Type[0]).getErasedType();
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

