/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.yaml;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class YamlConfigSourceLoader
extends AbstractLocationConfigSourceLoader {
    protected String[] getFileExtensions() {
        return new String[]{"yaml", "yml"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new YamlConfigSource(url, ordinal);
    }

    public static class InFileSystem
    extends YamlConfigSourceLoader
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            configSources.addAll(this.loadConfigSources(Paths.get(System.getProperty("user.dir"), "config", "application.yaml").toUri().toString(), 265, classLoader));
            configSources.addAll(this.loadConfigSources(Paths.get(System.getProperty("user.dir"), "config", "application.yml").toUri().toString(), 265, classLoader));
            return configSources;
        }

        protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
            return Collections.emptyList();
        }
    }

    public static class InClassPath
    extends YamlConfigSourceLoader
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            configSources.addAll(this.loadConfigSources("application.yaml", 255, classLoader));
            configSources.addAll(this.loadConfigSources("application.yml", 255, classLoader));
            configSources.addAll(this.loadConfigSources("META-INF/microprofile-config.yaml", 110, classLoader));
            configSources.addAll(this.loadConfigSources("META-INF/microprofile-config.yml", 110, classLoader));
            return configSources;
        }

        protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
            return Collections.emptyList();
        }
    }
}

