package io.smallrye.common.net;

import java.util.Locale;
import java.io.Serializable;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidAddress$str() {
        return "SRCOM02000: Invalid address string \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidAddress(final String address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddress$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidAddressBytes$str() {
        return "SRCOM02001: Invalid address length of %d; must be 4 or 16";
    }
    @Override
    public final IllegalArgumentException invalidAddressBytes(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddressBytes$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
