/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.rsocket.RSocketErrorException;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.internal.BaseDuplexConnection;
import java.net.SocketAddress;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public final class WebsocketDuplexConnection
extends BaseDuplexConnection {
    private final String side;
    private final Connection connection;

    public WebsocketDuplexConnection(Connection connection) {
        this("unknown", connection);
    }

    public WebsocketDuplexConnection(String side, Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
        this.side = side;
        connection.outbound().sendObject((Publisher)this.sender.map(BinaryWebSocketFrame::new)).then().doFinally(__ -> connection.dispose()).subscribe();
    }

    public ByteBufAllocator alloc() {
        return this.connection.channel().alloc();
    }

    public SocketAddress remoteAddress() {
        return this.connection.channel().remoteAddress();
    }

    protected void doOnClose() {
        this.connection.dispose();
    }

    public Mono<Void> onClose() {
        return Mono.whenDelayError((Publisher[])new Publisher[]{super.onClose(), this.connection.onTerminate()});
    }

    public Flux<ByteBuf> receive() {
        return this.connection.inbound().receive();
    }

    public void sendErrorAndClose(RSocketErrorException e) {
        ByteBuf errorFrame = ErrorFrameCodec.encode((ByteBufAllocator)this.alloc(), (int)0, (Throwable)e);
        this.sender.tryEmitFinal(errorFrame);
    }

    public String toString() {
        return "WebsocketDuplexConnection{side='" + this.side + '\'' + ", connection=" + this.connection + '}';
    }
}

