/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.util.Optional;

@ConfigGroup
public interface HttpStaticDirConfig {
    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="static")
    public String endpoint();

    public Optional<String> path();

    default public String normalizedPath() {
        Optional<String> path = this.path();
        if (path.isEmpty()) {
            return null;
        }
        String d = path.get().trim();
        if (d.isEmpty()) {
            throw new IllegalArgumentException("quarkus.http.static-dir.path must not be empty or blank");
        }
        if (d.contains("..")) {
            throw new IllegalArgumentException("quarkus.http.static-dir.path must not contain '..': " + d);
        }
        Path p = Path.of(d, new String[0]);
        if (p.getNameCount() == 0 || ".".equals(d)) {
            throw new IllegalArgumentException("quarkus.http.static-dir.path must not resolve to the project root directory (e.g. '.', './'): " + d);
        }
        if (p.isAbsolute()) {
            throw new IllegalArgumentException("quarkus.http.static-dir.path must be relative, but was: " + d);
        }
        return d;
    }

    default public String normalizedEndpoint() {
        Object p = this.endpoint().trim();
        if (((String)p).contains("*")) {
            throw new IllegalArgumentException("quarkus.http.static-dir.endpoint must not contain '*': " + (String)p);
        }
        if (((String)p).contains("..")) {
            throw new IllegalArgumentException("quarkus.http.static-dir.endpoint must not contain '..': " + (String)p);
        }
        if (((String)p).indexOf(32) >= 0) {
            throw new IllegalArgumentException("quarkus.http.static-dir.endpoint must not contain spaces: " + (String)p);
        }
        if (((String)p).contains("\\")) {
            throw new IllegalArgumentException("quarkus.http.static-dir.endpoint must use '/' as separator: " + (String)p);
        }
        if (((String)p).isEmpty()) {
            return "/";
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        while (((String)p).endsWith("/") && ((String)p).length() > 1) {
            p = ((String)p).substring(0, ((String)p).length() - 1);
        }
        return p;
    }
}

