/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.security.Permission;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class RoutingContextAwareSecurityIdentity
implements SecurityIdentity {
    private static final String ROUTING_CONTEXT_KEY = RoutingContext.class.getName();
    private final SecurityIdentity delegate;
    private final RoutingContext routingContext;

    private RoutingContextAwareSecurityIdentity(SecurityIdentity delegate, RoutingContext routingContext) {
        this.delegate = delegate;
        this.routingContext = routingContext;
    }

    static SecurityIdentity addRoutingCtxToIdentityIfMissing(SecurityIdentity delegate, RoutingContext routingContext) {
        if (delegate != null && delegate.getAttribute(ROUTING_CONTEXT_KEY) == null) {
            return new RoutingContextAwareSecurityIdentity(delegate, routingContext);
        }
        return delegate;
    }

    public Principal getPrincipal() {
        return this.delegate.getPrincipal();
    }

    public boolean isAnonymous() {
        return this.delegate.isAnonymous();
    }

    public Set<String> getRoles() {
        return this.delegate.getRoles();
    }

    public boolean hasRole(String s) {
        return this.delegate.hasRole(s);
    }

    public <T extends Credential> T getCredential(Class<T> aClass) {
        return (T)this.delegate.getCredential(aClass);
    }

    public Set<Credential> getCredentials() {
        return this.delegate.getCredentials();
    }

    public Set<Permission> getPermissions() {
        return this.delegate.getPermissions();
    }

    public <T> T getAttribute(String s) {
        if (ROUTING_CONTEXT_KEY.equals(s)) {
            return (T)this.routingContext;
        }
        return (T)this.delegate.getAttribute(s);
    }

    public Map<String, Object> getAttributes() {
        Map delegateAttributes = this.delegate.getAttributes();
        if (delegateAttributes == null || delegateAttributes.isEmpty()) {
            return Map.of(ROUTING_CONTEXT_KEY, this.routingContext);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(delegateAttributes);
        result.put(ROUTING_CONTEXT_KEY, this.routingContext);
        return result;
    }

    public Uni<Boolean> checkPermission(Permission permission) {
        return this.delegate.checkPermission(permission);
    }
}

