/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.scheduler.deployment.KotlinUtil;
import io.quarkus.scheduler.deployment.SchedulerDotNames;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.MethodInfo;

public final class ScheduledBusinessMethodItem
extends MultiBuildItem {
    private final BeanInfo bean;
    private final List<AnnotationInstance> schedules;
    private final MethodInfo method;
    private final boolean nonBlocking;
    private final boolean runOnVirtualThread;

    public ScheduledBusinessMethodItem(BeanInfo bean, MethodInfo method, List<AnnotationInstance> schedules) {
        this(bean, method, schedules, false, false);
    }

    public ScheduledBusinessMethodItem(BeanInfo bean, MethodInfo method, List<AnnotationInstance> schedules, boolean hasNonBlockingAnnotation, boolean hasRunOnVirtualThreadAnnotation) {
        this.bean = bean;
        this.method = method;
        this.schedules = schedules;
        this.nonBlocking = hasNonBlockingAnnotation || SchedulerDotNames.COMPLETION_STAGE.equals((Object)method.returnType().name()) || SchedulerDotNames.UNI.equals((Object)method.returnType().name()) || KotlinUtil.isSuspendMethod(method);
        this.runOnVirtualThread = hasRunOnVirtualThreadAnnotation;
    }

    public BeanInfo getBean() {
        return this.bean;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public List<AnnotationInstance> getSchedules() {
        return this.schedules;
    }

    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    public boolean isRunOnVirtualThread() {
        return this.runOnVirtualThread;
    }

    public String getMethodDescription() {
        return String.valueOf(this.method.declaringClass().name()) + "#" + this.method.name() + "()";
    }
}

