/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.InstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracer;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Map;
import java.util.function.BiConsumer;

public class RedisClientInstrumenterVertxTracer
implements InstrumenterVertxTracer<CommandTrace, Object> {
    private final Instrumenter<CommandTrace, Object> redisClientInstrumenter;

    public RedisClientInstrumenterVertxTracer(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        InstrumenterBuilder clientInstrumenterBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)DbClientSpanNameExtractor.create((DbClientAttributesGetter)RedisClientAttributesGetter.INSTANCE));
        clientInstrumenterBuilder.setEnabled(!runtimeConfig.sdkDisabled());
        this.redisClientInstrumenter = clientInstrumenterBuilder.addAttributesExtractor(DbClientAttributesExtractor.create((DbClientAttributesGetter)RedisClientAttributesGetter.INSTANCE)).addAttributesExtractor((AttributesExtractor)RedisClientAttributesExtractor.INSTANCE).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        if (request instanceof CommandTrace) {
            return true;
        }
        return "redis".equals(tagExtractor.extract(request).get("db.type"));
    }

    @Override
    public <R> OpenTelemetryVertxTracer.SpanOperation sendRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        CommandTrace commandTrace = CommandTrace.commandTrace(tagExtractor.extract(request));
        return InstrumenterVertxTracer.super.sendRequest(context, kind, policy, commandTrace, operation, (BiConsumer)headers, (TagExtractor)tagExtractor);
    }

    @Override
    public <R> void receiveResponse(io.vertx.core.Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        InstrumenterVertxTracer.super.receiveResponse(context, response, spanOperation, failure, tagExtractor);
    }

    @Override
    public Instrumenter<CommandTrace, Object> getReceiveRequestInstrumenter() {
        return null;
    }

    @Override
    public Instrumenter<CommandTrace, Object> getSendResponseInstrumenter() {
        return null;
    }

    @Override
    public Instrumenter<CommandTrace, Object> getSendRequestInstrumenter() {
        return this.redisClientInstrumenter;
    }

    @Override
    public Instrumenter<CommandTrace, Object> getReceiveResponseInstrumenter() {
        return this.redisClientInstrumenter;
    }

    static enum RedisClientAttributesGetter implements DbClientAttributesGetter<CommandTrace>
    {
        INSTANCE;


        public String getStatement(CommandTrace commandTrace) {
            return null;
        }

        public String getOperation(CommandTrace commandTrace) {
            return commandTrace.operation();
        }

        public String getSystem(CommandTrace commandTrace) {
            return "redis";
        }

        public String getUser(CommandTrace commandTrace) {
            return commandTrace.user();
        }

        public String getName(CommandTrace commandTrace) {
            return null;
        }

        public String getConnectionString(CommandTrace commandTrace) {
            return commandTrace.peerAddress();
        }
    }

    static enum RedisClientAttributesExtractor implements AttributesExtractor<CommandTrace, Object>
    {
        INSTANCE;


        public void onStart(AttributesBuilder attributes, Context parentContext, CommandTrace request) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.DB_REDIS_DATABASE_INDEX, (Object)request.dbIndex());
        }

        public void onEnd(AttributesBuilder attributes, Context context, CommandTrace request, Object response, Throwable error) {
        }
    }

    static class CommandTrace {
        static final String DB_STATEMENT = "db.statement";
        static final String DB_USER = "db.user";
        static final String PEER_ADDRESS = "peer.address";
        static final String DB_INSTANCE = "db.instance";
        private final Map<String, String> attributes;

        CommandTrace(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        static CommandTrace commandTrace(Map<String, String> attributes) {
            return new CommandTrace(attributes);
        }

        public String operation() {
            return this.attributes.get(DB_STATEMENT);
        }

        public String user() {
            return this.attributes.get(DB_USER);
        }

        public String peerAddress() {
            return this.attributes.get(PEER_ADDRESS);
        }

        public Long dbIndex() {
            String dbInstance = this.attributes.get(DB_INSTANCE);
            return dbInstance != null ? Long.valueOf(dbInstance) : null;
        }
    }
}

