/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.tracing;

import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.opentelemetry.deployment.tracing.DropNonApplicationUrisBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.DropStaticResourcesBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerEnabled;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.cdi.TracerProducer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.websockets.WebSocketTracesInterceptorImpl;
import io.quarkus.opentelemetry.runtime.tracing.security.EndUserSpanProcessor;
import io.quarkus.opentelemetry.runtime.tracing.security.SecurityEventUtil;
import io.quarkus.vertx.http.deployment.spi.FrameworkEndpointsBuildItem;
import io.quarkus.vertx.http.deployment.spi.StaticResourcesBuildItem;
import jakarta.enterprise.inject.spi.EventContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={TracerEnabled.class})
public class TracerProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)TracerProcessor.class.getName());
    private static final DotName ID_GENERATOR = DotName.createSimple((String)IdGenerator.class.getName());
    private static final DotName RESOURCE = DotName.createSimple((String)Resource.class.getName());
    private static final DotName SAMPLER = DotName.createSimple((String)Sampler.class.getName());
    private static final DotName SPAN_EXPORTER = DotName.createSimple((String)SpanExporter.class.getName());
    private static final DotName SPAN_PROCESSOR = DotName.createSimple((String)SpanProcessor.class.getName());
    private static final DotName TEXT_MAP_PROPAGATOR = DotName.createSimple((String)TextMapPropagator.class.getName());
    private static final DotName PATH = DotName.createSimple((String)"jakarta.ws.rs.Path");

    @BuildStep
    UnremovableBeanBuildItem ensureProducersAreRetained(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(TracerProducer.class).build());
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(ID_GENERATOR.toString());
        index.getAllKnownImplementors(ID_GENERATOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(RESOURCE.toString());
        index.getAllKnownImplementors(RESOURCE).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SAMPLER.toString());
        index.getAllKnownImplementors(SAMPLER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_EXPORTER.toString());
        index.getAllKnownImplementors(SPAN_EXPORTER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_PROCESSOR.toString());
        index.getAllKnownImplementors(SPAN_PROCESSOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(TEXT_MAP_PROPAGATOR.toString());
        index.getAllKnownImplementors(TEXT_MAP_PROPAGATOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        HashSet<String> retainProducers = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (!knownClasses.contains(returnType)) break;
                    retainProducers.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (!knownClasses.contains(fieldType)) break;
                    retainProducers.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        return new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(retainProducers));
    }

    @BuildStep
    void dropNames(Optional<FrameworkEndpointsBuildItem> frameworkEndpoints, Optional<StaticResourcesBuildItem> staticResources, BuildProducer<DropNonApplicationUrisBuildItem> dropNonApplicationUris, BuildProducer<DropStaticResourcesBuildItem> dropStaticResources) {
        ArrayList<String> nonApplicationUris = new ArrayList<String>();
        frameworkEndpoints.ifPresent(frameworkEndpointsBuildItem -> {
            for (String endpoint : frameworkEndpointsBuildItem.getEndpoints()) {
                if (endpoint.startsWith("http://") || endpoint.startsWith("https://")) {
                    try {
                        nonApplicationUris.add(new URL(endpoint).getPath());
                    }
                    catch (Exception ignored) {
                        nonApplicationUris.add(endpoint);
                    }
                    continue;
                }
                nonApplicationUris.add(endpoint);
            }
        });
        dropNonApplicationUris.produce((BuildItem)new DropNonApplicationUrisBuildItem(nonApplicationUris));
        ArrayList<String> resources = new ArrayList<String>();
        if (staticResources.isPresent()) {
            for (StaticResourcesBuildItem.Entry entry : staticResources.get().getEntries()) {
                if (entry.isDirectory()) continue;
                resources.add(entry.getPath());
            }
        }
        dropStaticResources.produce((BuildItem)new DropStaticResourcesBuildItem(resources));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupSampler(TracerRecorder recorder, DropNonApplicationUrisBuildItem dropNonApplicationUris, DropStaticResourcesBuildItem dropStaticResources) {
        recorder.setupSampler(dropNonApplicationUris.getDropNames(), dropStaticResources.getDropNames());
    }

    @BuildStep(onlyIf={SecurityEventsEnabled.class})
    void registerSecurityEventObserver(Capabilities capabilities, OTelBuildConfig buildConfig, ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerProducer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            if (buildConfig.securityEvents().eventTypes().contains(OTelBuildConfig.SecurityEvents.SecurityEventType.ALL)) {
                observerProducer.produce((BuildItem)TracerProcessor.createEventObserver(observerRegistrationPhase, OTelBuildConfig.SecurityEvents.SecurityEventType.ALL, "addAllEvents"));
            } else {
                for (OTelBuildConfig.SecurityEvents.SecurityEventType eventType : buildConfig.securityEvents().eventTypes()) {
                    observerProducer.produce((BuildItem)TracerProcessor.createEventObserver(observerRegistrationPhase, eventType, "addEvent"));
                }
            }
        } else {
            LOGGER.warn((Object)"Exporting of Quarkus Security events as OpenTelemetry Span events is enabled,\nbut the Quarkus Security is missing. This feature will only work if you add the Quarkus Security extension.\n");
        }
    }

    @BuildStep(onlyIf={EndUserAttributesEnabled.class})
    void addEndUserAttributesSpanProcessor(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.security")) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EndUserSpanProcessor.class));
        }
    }

    @BuildStep(onlyIf={EndUserAttributesEnabled.class})
    void registerEndUserAttributesEventObserver(Capabilities capabilities, ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerProducer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            observerProducer.produce((BuildItem)TracerProcessor.createEventObserver(observerRegistrationPhase, OTelBuildConfig.SecurityEvents.SecurityEventType.AUTHENTICATION_SUCCESS, "addEndUserAttributes"));
            observerProducer.produce((BuildItem)TracerProcessor.createEventObserver(observerRegistrationPhase, OTelBuildConfig.SecurityEvents.SecurityEventType.AUTHORIZATION_SUCCESS, "updateEndUserAttributes"));
            observerProducer.produce((BuildItem)TracerProcessor.createEventObserver(observerRegistrationPhase, OTelBuildConfig.SecurityEvents.SecurityEventType.AUTHORIZATION_FAILURE, "updateEndUserAttributes"));
        }
    }

    @BuildStep
    void registerWebSocketTracesInterceptor(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.websockets.next")) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(WebSocketTracesInterceptorImpl.class));
        }
    }

    private static ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem createEventObserver(ObserverRegistrationPhaseBuildItem observerRegistrationPhase, OTelBuildConfig.SecurityEvents.SecurityEventType eventType, String utilMethodName) {
        return new ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem(new ObserverConfigurator[]{observerRegistrationPhase.getContext().configure().beanClass(DotName.createSimple((String)TracerProducer.class.getName())).observedType(eventType.getObservedType()).notify(ng -> {
            BlockCreator bc = ng.notifyMethod();
            Var eventContext = ng.eventContext();
            Expr event = bc.invokeInterface(MethodDesc.of(EventContext.class, (String)"getEvent", Object.class, (Class[])new Class[0]), (Expr)eventContext);
            bc.invokeStatic(MethodDesc.of(SecurityEventUtil.class, (String)utilMethodName, Void.TYPE, (Class[])new Class[]{eventType.getObservedType()}), bc.cast(event, eventType.getObservedType()));
            bc.return_();
        })});
    }

    private static boolean containsPathExpression(String value) {
        return value.indexOf(123) != -1;
    }

    private static String sanitizeForTraceless(String path) {
        int braceIndex = path.indexOf(123);
        if (braceIndex == -1) {
            return path;
        }
        if (braceIndex > 0 && path.charAt(braceIndex - 1) == '/') {
            return path.substring(0, braceIndex - 1);
        }
        return path.substring(0, braceIndex);
    }

    private static boolean isClassAnnotatedWithPath(AnnotationInstance annotation) {
        return annotation.target().kind().equals((Object)AnnotationTarget.Kind.CLASS) && annotation.name().equals((Object)PATH);
    }

    private String combinePaths(String basePath, String relativePath) {
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return (String)basePath + relativePath;
    }

    static final class EndUserAttributesEnabled
    implements BooleanSupplier {
        private final boolean enabled;

        EndUserAttributesEnabled(OTelBuildConfig config) {
            this.enabled = config.traces().addEndUserAttributes();
        }

        @Override
        public boolean getAsBoolean() {
            return this.enabled;
        }
    }

    static final class SecurityEventsEnabled
    implements BooleanSupplier {
        private final boolean enabled;

        SecurityEventsEnabled(OTelBuildConfig config) {
            this.enabled = config.securityEvents().enabled();
        }

        @Override
        public boolean getAsBoolean() {
            return this.enabled;
        }
    }
}

