/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.kubernetes.spi.BaseTargetable;
import java.util.Objects;
import org.jboss.logging.Logger;

public final class KubernetesEnvBuildItem
extends BaseTargetable {
    private static final Logger log = Logger.getLogger(KubernetesEnvBuildItem.class);
    private final String name;
    private final String value;
    private final String configmap;
    private final String secret;
    private final String field;
    private final EnvType type;
    private final String prefix;

    public static KubernetesEnvBuildItem createFromField(String name, String targetField, String target) {
        return KubernetesEnvBuildItem.create(name, null, null, null, targetField, target, null);
    }

    public static KubernetesEnvBuildItem createFromConfigMap(String configMapName, String target, String prefix) {
        return KubernetesEnvBuildItem.create(configMapName, null, null, configMapName, null, target, prefix);
    }

    public static KubernetesEnvBuildItem createFromSecret(String secretName, String target, String prefix) {
        return KubernetesEnvBuildItem.create(secretName, null, secretName, null, null, target, prefix);
    }

    public static KubernetesEnvBuildItem createSimpleVar(String name, String value, String target) {
        return KubernetesEnvBuildItem.create(name, value, null, null, null, target, null);
    }

    public static KubernetesEnvBuildItem createFromConfigMapKey(String varName, String key, String configmap, String target, String prefix) {
        return KubernetesEnvBuildItem.create(varName, key, null, configmap, null, target, prefix);
    }

    public static KubernetesEnvBuildItem createFromSecretKey(String varName, String key, String secret, String target, String prefix) {
        return KubernetesEnvBuildItem.create(varName, key, secret, null, null, target, prefix);
    }

    public static KubernetesEnvBuildItem createFromResourceKey(String varName, String key, String secret, String configmap, String target) {
        return KubernetesEnvBuildItem.create(varName, key, secret, configmap, null, target, null);
    }

    public static KubernetesEnvBuildItem create(String name, String value, String secret, String configmap, String field, String target, String prefix) throws IllegalArgumentException {
        EnvType type;
        boolean fieldPresent;
        boolean secretPresent = secret != null;
        boolean configmapPresent = configmap != null;
        boolean valuePresent = value != null;
        boolean bl = fieldPresent = field != null;
        if (valuePresent) {
            if (secretPresent && configmapPresent) {
                throw new IllegalArgumentException(String.format("'%s' env var can't simultaneously take its value from '%s' configmap & '%s' secret", name, configmap, secret));
            }
            if (fieldPresent) {
                throw new IllegalArgumentException(String.format("'%s' env var can't simultaneously have a '%s' value & take is value from the '%s' field", name, value, field));
            }
        }
        if (secretPresent && configmapPresent) {
            log.warn((Object)String.format("The '%s' name was used to try to import both from '%s' secret & '%s' configmap. Only values from '%s' secret will be imported.\nIf you want to import from both, use a different property name for either.", name, secret, configmap, secret));
        }
        if (secretPresent) {
            if (valuePresent) {
                type = EnvType.keyFromSecret;
            } else {
                name = secret;
                type = EnvType.secret;
            }
        } else if (configmapPresent) {
            if (valuePresent) {
                type = EnvType.keyFromConfigmap;
            } else {
                name = configmap;
                type = EnvType.configmap;
            }
        } else {
            type = field != null ? EnvType.field : EnvType.var;
        }
        return new KubernetesEnvBuildItem(name, value, configmap, secret, field, type, target, prefix);
    }

    KubernetesEnvBuildItem(String name, String value, String configmap, String secret, String field, EnvType type, String target, String prefix) {
        super(target);
        this.name = name;
        this.value = value;
        this.configmap = configmap;
        this.secret = secret;
        this.field = field;
        this.type = type;
        this.prefix = prefix;
    }

    public String getConfigMap() {
        return this.configmap;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public EnvType getType() {
        return this.type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public KubernetesEnvBuildItem newWithTarget(String newTarget) {
        return new KubernetesEnvBuildItem(this.name, this.value, this.configmap, this.secret, this.field, this.type, newTarget, this.prefix);
    }

    public String toString() {
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> String.format("'%s' env var with value '%s'", this.name, this.value);
            case 1 -> String.format("'%s' env var with value from field '%s'", this.name, this.field);
            case 2 -> "all values from '" + this.secret + "' secret";
            case 3 -> "all values from '" + this.configmap + "' configmap";
            case 4 -> String.format("'%s' env var with value from '%s' key of '%s' configmap", this.name, this.value, this.configmap);
            case 5 -> String.format("'%s' env var with value from '%s' key of '%s' secret", this.name, this.value, this.secret);
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesEnvBuildItem that = (KubernetesEnvBuildItem)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!Objects.equals(this.configmap, that.configmap)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.field, that.field)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.configmap != null ? this.configmap.hashCode() : 0);
        result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        return result;
    }

    public static enum EnvType {
        var(false),
        field(false),
        secret(true),
        configmap(true),
        keyFromConfigmap(false),
        keyFromSecret(false);

        public final boolean allowMultipleDefinitions;

        private EnvType(boolean allowMultipleDefinitions) {
            this.allowMultipleDefinitions = allowMultipleDefinitions;
        }

        public boolean mightConflictWith(EnvType type) {
            if (this == type) {
                return true;
            }
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> {
                    if (type == var || type == keyFromConfigmap || type == keyFromSecret) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> {
                    if (type == field || type == keyFromConfigmap || type == keyFromSecret) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (type == configmap) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (type == secret) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (type == field || type == var || type == keyFromSecret) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> type == field || type == var || type == keyFromConfigmap;
            };
        }
    }
}

