/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.BootstrapAppModelFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.ClassCoercingTestProfile;
import io.quarkus.test.junit.PrepareResult;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestBuildChainFunction;
import jakarta.enterprise.inject.Alternative;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.Index;

public class AppMakerHelper {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected static final String TEST_PROFILE = "test-profile";

    public static ApplicationModel getGradleAppModelForIDE(Path projectRoot) throws IOException, AppModelResolverException {
        return System.getProperty("quarkus-internal-test.serialized-app-model.path") == null ? BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot) : null;
    }

    static PrepareResult prepare(Class<?> requiredTestClass, CuratedApplication curatedApplication, Class<? extends QuarkusTestProfile> profile) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Path testClassLocation = PathTestHelper.getTestClassesLocation(requiredTestClass, (CuratedApplication)curatedApplication);
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Path)testClassLocation);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Path)testClassLocation, requiredTestClass);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getOrCreateBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        if (profile != null) {
            props.put(TEST_PROFILE, profile.getName());
        }
        return new PrepareResult(curatedApplication.createAugmentor(TestBuildChainFunction.class.getName(), props), AppMakerHelper.getQuarkusTestProfile(profile), curatedApplication);
    }

    static QuarkusTestProfile getQuarkusTestProfile(Class<? extends QuarkusTestProfile> profile) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return profile == null ? null : new ClassCoercingTestProfile(profile.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    static Runnable setExtraPropertiesRestorably(Class<?> profileClass, QuarkusTestProfile profileInstance) {
        HashMap<String, String> additional = new HashMap<String, String>();
        additional.putAll(profileInstance.getConfigOverrides());
        if (!profileInstance.getEnabledAlternatives().isEmpty()) {
            additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                try {
                    if (!c.isAnnotationPresent(profileClass.getClassLoader().loadClass(Alternative.class.getName()))) {
                        throw new RuntimeException("Enabled alternative " + String.valueOf(c) + " is not annotated with @Alternative");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).map(Class::getName).collect(Collectors.joining(",")));
        }
        if (profileInstance.disableApplicationLifecycleObservers()) {
            additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
        }
        if (profileInstance.getConfigProfile() != null) {
            additional.put(LaunchMode.TEST.getProfileKey(), profileInstance.getConfigProfile());
        }
        return () -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close();
    }

    public static CuratedApplication makeCuratedApplication(Class<?> requiredTestClass, String displayName, boolean isContinuousTesting) throws IOException, AppModelResolverException, BootstrapException {
        Path testClassLocation;
        PathList.Builder rootBuilder = PathList.builder();
        Consumer<Path> addToBuilderIfConditionMet = path -> {
            if (path != null && Files.exists(path, new LinkOption[0]) && !rootBuilder.contains(path = path.normalize().toAbsolutePath())) {
                rootBuilder.add(path);
            }
        };
        Path projectRoot = Path.of("", new String[0]).normalize().toAbsolutePath();
        ApplicationModel testAppModel = null;
        ApplicationModel gradleAppModel = AppMakerHelper.getGradleAppModelForIDE(projectRoot);
        if (gradleAppModel != null && gradleAppModel.getApplicationModule() != null) {
            WorkspaceModule module = gradleAppModel.getApplicationModule();
            String testClassFileName = ClassLoaderHelper.fromClassNameToResourceName((String)requiredTestClass.getName());
            Path testClassesDir = null;
            for (String classifier : module.getSourceClassifiers()) {
                ArtifactSources sources = module.getSources(classifier);
                if (!sources.isOutputAvailable() || !sources.getOutputTree().contains(testClassFileName)) continue;
                for (SourceDir src : sources.getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                    if (!Files.exists(src.getOutputDir().resolve(testClassFileName), new LinkOption[0])) continue;
                    testClassesDir = src.getOutputDir();
                }
                for (SourceDir src : sources.getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
            }
            PathTestHelper.validateTestDir(requiredTestClass, testClassesDir, (WorkspaceModule)module);
            testClassLocation = testClassesDir;
        } else {
            Path appClassLocation;
            if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
                String[] sourceDirectories;
                for (String sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                    Path directory = Paths.get(sourceDirectory, new String[0]);
                    addToBuilderIfConditionMet.accept(directory);
                }
            }
            if (!(appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((Path)(testClassLocation = PathTestHelper.getTestClassesLocation(requiredTestClass)))).equals(testClassLocation)) {
                addToBuilderIfConditionMet.accept(testClassLocation);
                Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
                addToBuilderIfConditionMet.accept(testResourcesLocation);
            }
            addToBuilderIfConditionMet.accept(appClassLocation);
            testAppModel = BootstrapAppModelFactory.newInstance().setTest(true).setEnableClasspathCache(true).setProjectRoot(projectRoot).resolveAppModel().getApplicationModel();
            for (Path rootDir : testAppModel.getAppArtifact().getContentTree().getRoots()) {
                addToBuilderIfConditionMet.accept(rootDir);
            }
        }
        CuratedApplication curatedApplication = QuarkusBootstrap.builder().setExistingModel(testAppModel).setBaseName(displayName + " (QuarkusTest)").setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST).setTest(true).setAuxiliaryApplication(isContinuousTesting).setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation)).setProjectRoot(projectRoot).setApplicationRoot((PathCollection)rootBuilder.build()).build().bootstrap();
        if (!curatedApplication.getApplicationModel().getDependencies(4).iterator().hasNext()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        return curatedApplication;
    }

    public static StartupAction getStartupAction(Class<?> testClass, CuratedApplication curatedApplication, Class profile) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        PrepareResult prepareResult = AppMakerHelper.prepare(testClass, curatedApplication, profile);
        Runnable configCleanup = prepareResult.profileInstance() == null ? null : AppMakerHelper.setExtraPropertiesRestorably(profile, prepareResult.profileInstance());
        try {
            StartupAction startupAction = prepareResult.augmentAction().createInitialRuntimeApplication();
            return startupAction;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (configCleanup != null) {
                configCleanup.run();
            }
        }
    }
}

